/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\r\u001a\u00020\u000e*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInsideAnonymousObject", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "description", "", "getDescription", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)Ljava/lang/String;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirNestedClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNestedClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n77#2:72\n61#2:73\n35#2:74\n35#2:75\n28#2:76\n35#2:77\n61#2:78\n77#2:82\n1761#3,3:79\n*S KotlinDebug\n*F\n+ 1 FirNestedClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker\n*L\n32#1:72\n33#1:73\n36#1:74\n40#1:75\n45#1:76\n48#1:77\n49#1:78\n68#1:82\n57#1:79,3\n*E\n"})
public final class FirNestedClassChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNestedClassChecker INSTANCE = new FirNestedClassChecker();

    private FirNestedClassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (DeclarationAttributesKt.isReplSnippetDeclaration(declaration2) != null) {
            return;
        }
        FirRegularClass $this$isCompanion$iv = declaration2;
        boolean $i$f$isCompanion = false;
        boolean isCompanion = $this$isCompanion$iv.getStatus().isCompanion();
        if (!isCompanion && (declaration2.getClassKind().isSingleton() || declaration2.getClassKind() == ClassKind.ENUM_CLASS)) {
            FirClassLikeDeclaration $this$isLocal$iv = declaration2;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                return;
            }
        }
        FirClass firClass = (object = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirClass ? (FirClass)object : null;
        if (firClass == null) {
            return;
        }
        FirClass containingDeclaration = firClass;
        if (isCompanion) {
            FirMemberDeclaration $this$isInner$iv = containingDeclaration;
            boolean $i$f$isInner = false;
            if (!$this$isInner$iv.getStatus().isInner()) {
                return;
            }
        }
        if (containingDeclaration.getClassKind() == ClassKind.ENUM_ENTRY) {
            FirMemberDeclaration $this$isInner$iv = declaration2;
            boolean $i$f$isInner = false;
            if (!$this$isInner$iv.getStatus().isInner() && !isCompanion) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), (Object)this.getDescription(declaration2), (DiagnosticContext)context2, null, 16, null);
                return;
            }
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = containingDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        boolean containerIsLocal = Intrinsics.areEqual((Object)object2, (Object)EffectiveVisibility.Local.INSTANCE) && !Intrinsics.areEqual((Object)DeclarationAttributesKt.isReplSnippetDeclaration(containingDeclaration), (Object)true);
        FirMemberDeclaration $this$isInner$iv = declaration2;
        boolean $i$f$isInner = false;
        if (!$this$isInner$iv.getStatus().isInner()) {
            $this$isInner$iv = containingDeclaration;
            $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner() || containerIsLocal || this.isInsideAnonymousObject(context2)) {
                FirClassLikeDeclaration $this$isLocal$iv = declaration2;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getSymbol().getClassId().isLocal() && isCompanion) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED_IN_LOCAL(), (Object)this.getDescription(declaration2), (DiagnosticContext)context2, null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), (Object)this.getDescription(declaration2), (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }

    private final boolean isInsideAnonymousObject(CheckerContext $this$isInsideAnonymousObject) {
        boolean bl2;
        block3: {
            Iterable $this$any$iv = $this$isInsideAnonymousObject.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof FirAnonymousObject)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private final String getDescription(FirRegularClass $this$description) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$description.getClassKind().ordinal()]) {
            case 1: {
                string = "Class";
                break;
            }
            case 2: {
                string = "Interface";
                break;
            }
            case 3: {
                string = "Enum class";
                break;
            }
            case 4: {
                string = "Enum entry";
                break;
            }
            case 5: {
                string = "Annotation class";
                break;
            }
            case 6: {
                FirRegularClass $this$isCompanion$iv = $this$description;
                boolean $i$f$isCompanion = false;
                if ($this$isCompanion$iv.getStatus().isCompanion()) {
                    string = "Companion object";
                    break;
                }
                string = "Object";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

