/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import ksp.org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import ksp.org.jetbrains.kotlin.lexer.KtKeywordToken;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J%\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0016J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkParameterTypes", "function", "checkParameterType", "valueParameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "checkVarargParameters", "checkUninitializedParameter", "checkValOrVarParameter", "checkValOrVar", "checkValOrVar$checkers", "checkParameterNameChangedOnOverride", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFunctionParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunctionParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,168:1\n774#2:169\n865#2,2:170\n37#3:172\n59#3:173\n*S KotlinDebug\n*F\n+ 1 FirFunctionParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker\n*L\n66#1:169\n66#1:170,2\n153#1:172\n153#1:173\n*E\n"})
public final class FirFunctionParameterChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionParameterChecker INSTANCE = new FirFunctionParameterChecker();

    private FirFunctionParameterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkVarargParameters(declaration2, context2, reporter);
        this.checkParameterTypes(declaration2, context2, reporter);
        this.checkUninitializedParameter(declaration2, context2, reporter);
        this.checkValOrVarParameter(declaration2, context2, reporter);
        this.checkParameterNameChangedOnOverride(declaration2, context2, reporter);
    }

    private final void checkParameterTypes(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        if (function2 instanceof FirAnonymousFunction) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            this.checkParameterType(valueParameter2, reporter, context2);
        }
        for (FirValueParameter valueParameter2 : function2.getContextParameters()) {
            this.checkParameterType(valueParameter2, reporter, context2);
        }
    }

    private final void checkParameterType(FirValueParameter valueParameter2, DiagnosticReporter reporter, CheckerContext context2) {
        FirTypeRef returnTypeRef = valueParameter2.getReturnTypeRef();
        if (!(returnTypeRef instanceof FirErrorTypeRef)) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirErrorTypeRef)returnTypeRef).getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        ConeDiagnostic diagnostic = ((FirErrorTypeRef)returnTypeRef).getDiagnostic();
        if (diagnostic instanceof ConeSimpleDiagnostic && ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.ValueParameterWithNoTypeAnnotation) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getVALUE_PARAMETER_WITHOUT_EXPLICIT_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (!it.isVararg()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (FirValueParameter parameter2 : varargParameters) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getMULTIPLE_VARARG_PARAMETERS(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        for (FirValueParameter varargParameter : varargParameters) {
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(varargParameter.getReturnTypeRef());
            ConeKotlinType coneKotlinType = function2 instanceof FirAnonymousFunction ? coneType : FirTypeUtilsKt.arrayElementType$default(coneType, false, 1, null);
            if (coneKotlinType == null || (object = TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType, context2.getSession(), null, 2, null)) == null) continue;
            Object varargParameterType = object;
            if (!ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing(TypeExpansionUtilsKt.fullyExpandedType$default(FirHelpersKt.leastUpperBound((ConeKotlinType)varargParameterType, context2.getSession()), context2.getSession(), null, 2, null)) && (!FirHelpersKt.isValueClass((ConeKotlinType)varargParameterType, context2.getSession()) || ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType((ConeKotlinType)varargParameterType))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)varargParameter.getSource(), FirErrors.INSTANCE.getFORBIDDEN_VARARG_PARAMETER_TYPE(), varargParameterType, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkUninitializedParameter(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterator iterator2 = ((Iterable)function2.getValueParameters()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index2 = n2++;
            FirValueParameter parameter2 = (FirValueParameter)iterator2.next();
            FirExpression firExpression = parameter2.getDefaultValue();
            if (firExpression == null) continue;
            firExpression.accept(new FirVisitorVoid(function2, index2, reporter, context2){
                final /* synthetic */ FirFunction $function;
                final /* synthetic */ int $index;
                final /* synthetic */ DiagnosticReporter $reporter;
                final /* synthetic */ CheckerContext $context;
                {
                    this.$function = $function;
                    this.$index = $index;
                    this.$reporter = $reporter;
                    this.$context = $context;
                }

                public void visitElement(FirElement element2) {
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    element2.acceptChildren(this);
                }

                public void visitQualifiedAccessExpression(FirQualifiedAccessExpression qualifiedAccessExpression) {
                    int referredParameterIndex;
                    FirValueParameterSymbol referredParameter;
                    block5: {
                        int n2;
                        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
                        FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(qualifiedAccessExpression.getCalleeReference(), false, 1, null);
                        if (firValueParameterSymbol == null) {
                            return;
                        }
                        referredParameter = firValueParameterSymbol;
                        List<FirValueParameter> $this$indexOfFirst$iv = this.$function.getValueParameters();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<FirValueParameter> iterator2 = $this$indexOfFirst$iv.iterator();
                        while (iterator2.hasNext()) {
                            FirValueParameter item$iv;
                            FirValueParameter it = item$iv = iterator2.next();
                            boolean bl2 = false;
                            if (Intrinsics.areEqual((Object)it.getSymbol(), (Object)referredParameter)) {
                                n2 = index$iv;
                                break block5;
                            }
                            ++index$iv;
                        }
                        n2 = referredParameterIndex = -1;
                    }
                    if (referredParameterIndex < 0) {
                        return;
                    }
                    if (this.$index <= referredParameterIndex) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)qualifiedAccessExpression.getSource(), FirErrors.INSTANCE.getUNINITIALIZED_PARAMETER(), (Object)referredParameter, (DiagnosticContext)this.$context, null, 16, null);
                    }
                }

                public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                    Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                    this.visitQualifiedAccessExpression(propertyAccessExpression);
                }
            });
        }
    }

    private final void checkValOrVarParameter(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        if (function2 instanceof FirConstructor && ((FirConstructor)function2).isPrimary()) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            this.checkValOrVar$checkers(valueParameter2, reporter, context2);
        }
    }

    public final void checkValOrVar$checkers(@NotNull FirValueParameter valueParameter2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        block3: {
            KtSourceElement source;
            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            KtSourceElement ktSourceElement = source = valueParameter2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
            KtKeywordToken ktKeywordToken = FirKeywordUtilsKt.getValOrVarKeyword(source);
            if (ktKeywordToken == null) break block3;
            KtKeywordToken it = ktKeywordToken;
            boolean bl2 = false;
            if (valueParameter2.getContainingDeclarationSymbol() instanceof FirConstructorSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER(), (Object)it, (DiagnosticContext)context2, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_FUN_PARAMETER(), (Object)it, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    private final void checkParameterNameChangedOnOverride(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        block4: {
            block3: {
                if (!(function2 instanceof FirSimpleFunction)) break block3;
                FirMemberDeclaration $this$isOverride$iv = function2;
                boolean $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block3;
                FirMemberDeclaration $this$hasStableParameterNames$iv = function2;
                boolean $i$f$getHasStableParameterNames = false;
                if ($this$hasStableParameterNames$iv.getStatus().getHasStableParameterNames()) break block4;
            }
            return;
        }
        for (FirNamedFunctionSymbol overriddenFunctionSymbol : FirHelpersKt.directOverriddenFunctions(((FirSimpleFunction)function2).getSymbol(), context2)) {
            if (!overriddenFunctionSymbol.getResolvedStatus().getHasStableParameterNames()) continue;
            DeclarationUtilsKt.checkValueParameterNamesWith(((FirSimpleFunction)function2).getSymbol(), overriddenFunctionSymbol, (Function3<? super FirValueParameterSymbol, ? super FirValueParameterSymbol, ? super Integer, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FirFunctionParameterChecker.checkParameterNameChangedOnOverride$lambda$2(reporter, context2, arg_0, arg_1, arg_2)));
        }
    }

    private static final Unit checkParameterNameChangedOnOverride$lambda$2(DiagnosticReporter $reporter, CheckerContext $context, FirValueParameterSymbol currentParameter, FirValueParameterSymbol overriddenParameter, int n2) {
        Intrinsics.checkNotNullParameter((Object)currentParameter, (String)"currentParameter");
        Intrinsics.checkNotNullParameter((Object)overriddenParameter, (String)"overriddenParameter");
        AbstractKtSourceElement abstractKtSourceElement = currentParameter.getSource();
        KtDiagnosticFactory2<FirRegularClassSymbol, FirValueParameterSymbol> ktDiagnosticFactory2 = FirErrors.INSTANCE.getPARAMETER_NAME_CHANGED_ON_OVERRIDE();
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(overriddenParameter.getContainingDeclarationSymbol());
        Intrinsics.checkNotNull(firClassLikeSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol");
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)((FirRegularClassSymbol)firClassLikeSymbol), (Object)overriddenParameter, (DiagnosticContext)$context, null, 32, null);
        return Unit.INSTANCE;
    }
}

