/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypesKt;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "originalBounds", "", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "unwrapBound", "extractTypeParamSymbols", "ref", "extractTypeParamSymbol", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCyclicTypeBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCyclicTypeBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n827#2:78\n855#2,2:79\n1869#2,2:82\n774#2:84\n865#2,2:85\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n1869#2,2:100\n1374#2:102\n1460#2,5:103\n1617#2,9:108\n1869#2:117\n1870#2:119\n1626#2:120\n1374#2:121\n1460#2,5:122\n1869#2,2:127\n756#2,10:129\n1#3:81\n1#3:97\n1#3:118\n*S KotlinDebug\n*F\n+ 1 FirCyclicTypeBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker\n*L\n24#1:78\n24#1:79,2\n44#1:82,2\n50#1:84\n50#1:85,2\n50#1:87,9\n50#1:96\n50#1:98\n50#1:99\n54#1:100,2\n61#1:102\n61#1:103,5\n72#1:108,9\n72#1:117\n72#1:119\n72#1:120\n34#1:121\n34#1:122,5\n35#1:127,2\n40#1:129,10\n50#1:97\n72#1:118\n*E\n"})
public final class FirCyclicTypeBoundsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirCyclicTypeBoundsChecker INSTANCE = new FirCyclicTypeBoundsChecker();

    private FirCyclicTypeBoundsChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration2 instanceof FirConstructor || declaration2 instanceof FirTypeAlias) {
            return;
        }
        Iterable $this$filterNot$iv = ((FirMemberDeclaration)declaration2).getTypeParameters();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
            boolean bl2 = false;
            if (it instanceof FirOuterClassTypeParameterRef) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable it = $this$filterNot$iv = (List)destination$iv$iv;
        boolean bl3 = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? $this$filterNot$iv : null;
        if (iterable2 == null) {
            return;
        }
        Iterable actualTypeParameters = iterable2;
        Set processed = new LinkedHashSet();
        List typeParameterCycles = new ArrayList();
        List path = new ArrayList();
        Iterable $this$forEach$iv = actualTypeParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef param = (FirTypeParameterRef)element$iv;
            boolean bl4 = false;
            FirCyclicTypeBoundsChecker.check$findCycles(processed, path, typeParameterCycles, param.getSymbol());
        }
        for (List typeParameterCycle : typeParameterCycles) {
            for (FirTypeParameterSymbol typeParameter : typeParameterCycle) {
                List list;
                if (declaration2 instanceof FirRegularClass) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.originalBounds(typeParameter);
                    boolean $i$f$filter = false;
                    Iterable iterable3 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        FirTypeRef it2 = (FirTypeRef)element$iv$iv;
                        boolean bl5 = false;
                        if (!CollectionsKt.contains((Iterable)typeParameterCycle, (Object)INSTANCE.extractTypeParamSymbol(FirTypeUtilsKt.getConeType(it2)))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        KtSourceElement it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl6 = false;
                        FirTypeRef it3 = (FirTypeRef)element$iv$iv;
                        boolean bl7 = false;
                        if (it3.getSource() == null) continue;
                        boolean bl8 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.listOf((Object)typeParameter.getSource());
                }
                List targets = list;
                Iterable $this$forEach$iv2 = targets;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    KtSourceElement it4 = (KtSourceElement)element$iv;
                    boolean bl9 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it4, FirErrors.INSTANCE.getCYCLIC_GENERIC_UPPER_BOUND(), (Object)typeParameterCycle, (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeRef> originalBounds(FirTypeParameterSymbol $this$originalBounds) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$originalBounds.getResolvedBounds();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = INSTANCE.unwrapBound(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FirTypeRef> unwrapBound(FirTypeRef $this$unwrapBound) {
        List list;
        if ($this$unwrapBound instanceof FirErrorTypeRef && ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic() instanceof ConeCyclicTypeBound) {
            ConeDiagnostic coneDiagnostic = ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic();
            Intrinsics.checkNotNull((Object)coneDiagnostic, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound");
            list = ((ConeCyclicTypeBound)coneDiagnostic).getBounds();
        } else {
            list = CollectionsKt.listOf((Object)$this$unwrapBound);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeParameterSymbol> extractTypeParamSymbols(FirTypeRef ref) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.unwrapBound(ref);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirTypeParameterSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl3 = false;
            if (INSTANCE.extractTypeParamSymbol(FirTypeUtilsKt.getConeType(it)) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final FirTypeParameterSymbol extractTypeParamSymbol(ConeKotlinType type2) {
        ConeSimpleKotlinType coneSimpleKotlinType = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type2);
        Object object = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
        return object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$findCycles(Set<FirTypeParameterSymbol> processed, List<FirTypeParameterSymbol> path, List<List<FirTypeParameterSymbol>> typeParameterCycles, FirTypeParameterSymbol typeParameterSymbol) {
        if (processed.add(typeParameterSymbol)) {
            Iterator $this$flatMapTo$iv$iv;
            path.add(typeParameterSymbol);
            Iterable $this$flatMap$iv = typeParameterSymbol.getResolvedBounds();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = INSTANCE.extractTypeParamSymbols(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Set resolvedBounds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$forEach$iv = resolvedBounds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                boolean bl3 = false;
                FirCyclicTypeBoundsChecker.check$findCycles(processed, path, typeParameterCycles, it);
            }
            path.remove(path.size() - 1);
        } else if (!((Collection)path).isEmpty()) {
            void $this$dropWhile$iv;
            Iterable resolvedBounds = path;
            List<List<FirTypeParameterSymbol>> list = typeParameterCycles;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                FirTypeParameterSymbol it = (FirTypeParameterSymbol)item$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)typeParameterSymbol)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            list.add(list$iv);
        }
    }
}

