/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.MappingsKt;
import ksp.org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmDefaultParameterInjector;
import ksp.org.jetbrains.kotlin.config.JvmDefaultMode;
import ksp.org.jetbrains.kotlin.config.JvmTarget;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="Interface", prerequisite={JvmDefaultParameterInjector.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0010*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u00020\u0010*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020&H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lksp/org/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "removedFunctions", "Ljava/util/HashMap;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lkotlin/collections/HashMap;", "removedFunctionsWithoutRemapping", "", "lower", "", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "handleInterface", "createJvmDefaultCompatibilityDelegate", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "handleAnnotationClass", "createDefaultImpl", "forCompatibility", "", "bridgeToStatic", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "callTarget", "bridgeViaAccessorTo", "visitReturn", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrReturn;", "visitCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunctionReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInterfaceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n808#2,11:316\n1878#2,3:327\n1878#2,3:330\n1878#2,3:333\n*S KotlinDebug\n*F\n+ 1 InterfaceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering\n*L\n190#1:316,11\n231#1:327,3\n235#1:330,3\n253#1:333,3\n*E\n"})
public final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashMap<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> removedFunctions;
    @NotNull
    private final Set<IrSimpleFunctionSymbol> removedFunctionsWithoutRemapping;

    public InterfaceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.removedFunctions = new HashMap();
        this.removedFunctionsWithoutRemapping = new LinkedHashSet();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!JvmIrUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[irClass.getKind().ordinal()]) {
            case 1: {
                this.handleInterface(irClass);
                break;
            }
            case 2: {
                this.handleAnnotationClass(irClass);
                break;
            }
            default: {
                return;
            }
        }
        CollectionsKt.removeAll(irClass.getDeclarations(), arg_0 -> InterfaceLowering.lower$lambda$0(this, arg_0));
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass);
        if (!((Collection)defaultImplsIrClass.getDeclarations()).isEmpty()) {
            irClass.getDeclarations().add(defaultImplsIrClass);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInterface(IrClass irClass) {
        void $this$filterIsInstanceTo$iv$iv;
        Object superImpl;
        JvmDefaultMode jvmDefaultMode = this.context.getConfig().getJvmDefaultMode();
        boolean isCompatibilityMode = jvmDefaultMode == JvmDefaultMode.ENABLE && !JvmDefaultUtilsKt.hasJvmDefaultNoCompatibilityAnnotation(irClass) || jvmDefaultMode == JvmDefaultMode.NO_COMPATIBILITY && JvmDefaultUtilsKt.hasJvmDefaultWithCompatibilityAnnotation(irClass);
        for (IrSimpleFunction function2 : IrUtilsKt.getFunctions(irClass)) {
            DescriptorVisibility visibility;
            DescriptorVisibility descriptorVisibility;
            IrSimpleFunction defaultImpl;
            if (function2.getModality() == Modality.ABSTRACT) continue;
            if (function2.isFakeOverride()) {
                String string = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                if (StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) continue;
                IrSimpleFunction implementation2 = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)function2);
                if (DescriptorVisibilities.isPrivate(implementation2.getVisibility()) || IrUtilsKt.isMethodOfAny(implementation2)) continue;
                if (!JvmDefaultUtilsKt.isDefinitelyNotDefaultImplsMethod(function2, jvmDefaultMode, implementation2)) {
                    IrSimpleFunction irSimpleFunction;
                    IrSimpleFunction defaultImpl2 = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                    superImpl = JvmIrUtilsKt.firstSuperMethodFromKotlin(function2, implementation2);
                    IrSimpleFunction it = irSimpleFunction = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), (IrSimpleFunction)superImpl.getOwner(), false, 2, null);
                    boolean bl2 = false;
                    this.bridgeToStatic(defaultImpl2, it);
                    continue;
                }
                if (!isCompatibilityMode || !JvmDefaultUtilsKt.isCompiledToJvmDefault(implementation2, jvmDefaultMode)) continue;
                this.createJvmDefaultCompatibilityDelegate(function2);
                continue;
            }
            if (!JvmDefaultUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode) && (DescriptorVisibilities.isPrivate(function2.getVisibility()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS())) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS()) && isCompatibilityMode && JvmDefaultUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode)) {
                if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINLINE_LAMBDA())) {
                    IrClass defaultImplsClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass);
                    defaultImplsClass.getDeclarations().add(function2);
                    this.removedFunctionsWithoutRemapping.add(function2.getSymbol());
                    function2.setParent(defaultImplsClass);
                    continue;
                }
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
                ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
                continue;
            }
            if (!JvmDefaultUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode)) {
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
                function2.setBody(null);
                continue;
            }
            if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
                IrFunction irFunction = MappingsKt.getDefaultArgumentsOriginalFunction(function2);
                Intrinsics.checkNotNull((Object)irFunction);
                descriptorVisibility = irFunction.getVisibility();
            } else {
                descriptorVisibility = visibility = function2.getVisibility();
            }
            if (!DescriptorVisibilities.isPrivate(visibility)) {
                if (!isCompatibilityMode) continue;
                this.createJvmDefaultCompatibilityDelegate(function2);
                continue;
            }
            if (this.context.getConfig().getTarget() != JvmTarget.JVM_1_8 || this.context.getState().getClassBuilderMode().generateBodies) continue;
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
            function2.setVisibility(descriptorVisibility2);
        }
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass);
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        superImpl = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrField field : (List)destination$iv$iv) {
            if ((jvmDefaultMode.isEnabled() || !Intrinsics.areEqual((Object)field.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_PROPERTY_REFERENCE())) && !Intrinsics.areEqual((Object)field.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_ASSERTION_ENABLED_FIELD())) continue;
            irClass.getDeclarations().remove(field);
            defaultImplsIrClass.getDeclarations().add(0, field);
            field.setParent(defaultImplsIrClass);
        }
    }

    private final void createJvmDefaultCompatibilityDelegate(IrSimpleFunction function2) {
        IrSimpleFunction defaultImpl = this.createDefaultImpl(function2, true);
        this.bridgeViaAccessorTo(defaultImpl, function2);
    }

    private final void handleAnnotationClass(IrClass irClass) {
        Sequence annotationsMethods = SequencesKt.filter(IrUtilsKt.getFunctions(irClass), InterfaceLowering::handleAnnotationClass$lambda$2);
        if (SequencesKt.none((Sequence)annotationsMethods)) {
            return;
        }
        for (IrSimpleFunction function2 : annotationsMethods) {
            IrSimpleFunction defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
            defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
            ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
        }
    }

    private final IrSimpleFunction createDefaultImpl(IrSimpleFunction function2, boolean forCompatibility) {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction newFunction = irSimpleFunction = this.context.getCachedDeclarations().getDefaultImplsFunction(function2, forCompatibility);
        boolean bl2 = false;
        IrUtilsKt.getParentAsClass(newFunction).getDeclarations().add(newFunction);
        return irSimpleFunction;
    }

    static /* synthetic */ IrSimpleFunction createDefaultImpl$default(InterfaceLowering interfaceLowering, IrSimpleFunction irSimpleFunction, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return interfaceLowering.createDefaultImpl(irSimpleFunction, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeToStatic(IrFunction $this$bridgeToStatic, IrSimpleFunction callTarget) {
        void call2;
        int i2;
        int n2;
        IrCallImpl irCallImpl;
        IrCallImpl irCallImpl2 = irCallImpl = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, $this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), $this$bridgeToStatic.getReturnType(), callTarget.getSymbol(), null, null, 48, null);
        IrFactory irFactory = this.context.getIrFactory();
        IrFunction irFunction = $this$bridgeToStatic;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv = callTarget.getTypeParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter cfr_ignored_0 = (IrTypeParameter)item$iv;
            i2 = n2;
            boolean bl3 = false;
            call2.getTypeArguments().set(i2, JvmIrUtilsKt.createPlaceholderAnyNType(this.context.getIrBuiltIns()));
        }
        $this$forEachIndexed$iv = $this$bridgeToStatic.getValueParameters();
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            i2 = n2;
            boolean bl4 = false;
            call2.putValueArgument(i2, BuildersKt.IrGetValueImpl$default($this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), it.getSymbol(), null, 8, null));
        }
        Unit unit = Unit.INSTANCE;
        irFunction.setBody(IrFactoryHelpersKt.createExpressionBody(irFactory, irCallImpl));
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeViaAccessorTo(IrFunction $this$bridgeViaAccessorTo, IrSimpleFunction callTarget) {
        IrValueParameter it;
        void call2;
        IrCallImpl irCallImpl;
        IrCallImpl irCallImpl2 = irCallImpl = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, $this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getReturnType(), callTarget.getSymbol(), null, IrUtilsKt.getParentAsClass(callTarget).getSymbol(), 16, null);
        IrFactory irFactory = this.context.getIrFactory();
        IrFunction irFunction = $this$bridgeViaAccessorTo;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.drop((Iterable)$this$bridgeViaAccessorTo.getTypeParameters(), (int)IrUtilsKt.getParentAsClass(callTarget).getTypeParameters().size());
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameter;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv;
            int i2 = n2;
            boolean bl3 = false;
            call2.getTypeArguments().set(i2, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
        }
        int offset = 0;
        IrValueParameter irValueParameter = callTarget.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            it = irValueParameter;
            boolean bl4 = false;
            call2.setDispatchReceiver(BuildersKt.IrGetValueImpl$default($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset).getSymbol(), null, 8, null));
            ++offset;
        }
        IrValueParameter irValueParameter2 = callTarget.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            it = irValueParameter2;
            boolean bl5 = false;
            call2.setExtensionReceiver(BuildersKt.IrGetValueImpl$default($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset).getSymbol(), null, 8, null));
            ++offset;
        }
        int n3 = $this$bridgeViaAccessorTo.getValueParameters().size();
        for (int i3 = offset; i3 < n3; ++i3) {
            call2.putValueArgument(i3 - offset, BuildersKt.IrGetValueImpl$default($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(i3).getSymbol(), null, 8, null));
        }
        Unit unit = Unit.INSTANCE;
        irFunction.setBody(IrFactoryHelpersKt.createExpressionBody(irFactory, irCallImpl));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Map map = this.removedFunctions;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)map.get(expression2.getReturnTargetSymbol());
        IrSimpleFunction newFunction = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction != null) {
            void $this$visitReturn_u24lambda_u2411;
            IrReturn irReturn2 = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl2 = false;
            interfaceLowering = interfaceLowering2;
            irReturn = new IrReturnImpl($this$visitReturn_u24lambda_u2411.getStartOffset(), $this$visitReturn_u24lambda_u2411.getEndOffset(), $this$visitReturn_u24lambda_u2411.getType(), newFunction.getSymbol(), $this$visitReturn_u24lambda_u2411.getValue());
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.removedFunctions.get(expression2.getSymbol());
        IrSimpleFunction newFunction = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        return super.visitCall(newFunction != null ? JvmIrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, newFunction, this.context.getIrBuiltIns()) : expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Map map = this.removedFunctions;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)map.get(expression2.getSymbol());
        IrSimpleFunction newFunction = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction != null) {
            void $this$visitFunctionReference_u24lambda_u2413;
            IrFunctionReferenceImpl irFunctionReferenceImpl;
            IrFunctionReference irFunctionReference2 = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl2 = false;
            IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u2413_u24lambda_u2412 = irFunctionReferenceImpl = BuildersKt.IrFunctionReferenceImpl($this$visitFunctionReference_u24lambda_u2413.getStartOffset(), $this$visitFunctionReference_u24lambda_u2413.getEndOffset(), $this$visitFunctionReference_u24lambda_u2413.getType(), newFunction.getSymbol(), newFunction.getTypeParameters().size(), expression2.getReflectionTarget(), $this$visitFunctionReference_u24lambda_u2413.getOrigin());
            boolean bl3 = false;
            JvmIrUtilsKt.copyFromWithPlaceholderTypeArguments($this$visitFunctionReference_u24lambda_u2413_u24lambda_u2412, expression2, this.context.getIrBuiltIns());
            IrDeclarationsKt.copyAttributes$default($this$visitFunctionReference_u24lambda_u2413_u24lambda_u2412, expression2, false, 2, null);
            interfaceLowering = interfaceLowering2;
            irFunctionReference = irFunctionReferenceImpl;
        } else {
            irFunctionReference = expression2;
        }
        return super.visitFunctionReference(irFunctionReference);
    }

    private static final boolean lower$lambda$0(InterfaceLowering this$0, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof IrFunction && (((Map)this$0.removedFunctions).containsKey(((IrFunction)it).getSymbol()) || CollectionsKt.contains((Iterable)this$0.removedFunctionsWithoutRemapping, (Object)((IrFunction)it).getSymbol()));
    }

    private static final boolean handleAnnotationClass$lambda$2(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

