/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.github.benmanes.caffeine.cache;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import ksp.com.github.benmanes.caffeine.cache.CacheLoader;
import ksp.com.github.benmanes.caffeine.cache.LoadingCache;
import ksp.com.github.benmanes.caffeine.cache.LocalManualCache;
import ksp.com.github.benmanes.caffeine.cache.RemovalCause;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

interface LocalLoadingCache<K, V>
extends LocalManualCache<K, V>,
LoadingCache<K, V> {
    public static final Logger logger = Logger.getLogger(LocalLoadingCache.class.getName());

    public CacheLoader<? super K, V> cacheLoader();

    public Function<K, V> mappingFunction();

    public @Nullable Function<Iterable<? extends K>, Map<K, V>> bulkMappingFunction();

    @Override
    default public @Nullable V get(K key) {
        return this.cache().computeIfAbsent(key, this.mappingFunction());
    }

    @Override
    default public Map<K, V> getAll(Iterable<? extends K> keys) {
        Function mappingFunction = this.bulkMappingFunction();
        return mappingFunction == null ? this.loadSequentially(keys) : this.getAll(keys, mappingFunction);
    }

    default public Map<K, V> loadSequentially(Iterable<? extends K> keys) {
        LinkedHashSet<K> uniqueKeys = new LinkedHashSet<K>();
        for (K key : keys) {
            uniqueKeys.add(key);
        }
        int count = 0;
        LinkedHashMap result2 = new LinkedHashMap(uniqueKeys.size());
        try {
            for (Object key : uniqueKeys) {
                ++count;
                V value2 = this.get(key);
                if (value2 == null) continue;
                result2.put(key, value2);
            }
        }
        catch (Throwable t2) {
            this.cache().statsCounter().recordMisses(uniqueKeys.size() - count);
            throw t2;
        }
        return Collections.unmodifiableMap(result2);
    }

    @Override
    default public void refresh(K key) {
        Objects.requireNonNull(key);
        long[] writeTime = new long[1];
        long startTime = this.cache().statsTicker().read();
        Object oldValue = this.cache().getIfPresentQuietly(key, writeTime);
        CompletableFuture<V> refreshFuture = oldValue == null ? this.cacheLoader().asyncLoad(key, this.cache().executor()) : this.cacheLoader().asyncReload(key, oldValue, this.cache().executor());
        refreshFuture.whenComplete((newValue, error) -> {
            long loadTime = this.cache().statsTicker().read() - startTime;
            if (error != null) {
                if (!(error instanceof CancellationException) && !(error instanceof TimeoutException)) {
                    logger.log(Level.WARNING, "Exception thrown during refresh", (Throwable)error);
                }
                this.cache().statsCounter().recordLoadFailure(loadTime);
                return;
            }
            boolean[] discard = new boolean[1];
            this.cache().compute(key, (k2, currentValue) -> {
                if (currentValue == null) {
                    return newValue;
                }
                if (currentValue == oldValue) {
                    long expectedWriteTime = writeTime[0];
                    if (this.cache().hasWriteTime()) {
                        this.cache().getIfPresentQuietly(key, writeTime);
                    }
                    if (writeTime[0] == expectedWriteTime) {
                        return newValue;
                    }
                }
                discard[0] = true;
                return currentValue;
            }, false, false, true);
            if (discard[0] && this.cache().hasRemovalListener()) {
                this.cache().notifyRemoval(key, newValue, RemovalCause.REPLACED);
            }
            if (newValue == null) {
                this.cache().statsCounter().recordLoadFailure(loadTime);
            } else {
                this.cache().statsCounter().recordLoadSuccess(loadTime);
            }
        });
    }

    public static <K, V> Function<K, V> newMappingFunction(CacheLoader<? super K, V> cacheLoader) {
        return key -> {
            try {
                return cacheLoader.load(key);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e3);
            }
            catch (Exception e4) {
                throw new CompletionException(e4);
            }
        };
    }

    public static <K, V> @Nullable Function<Iterable<? extends K>, Map<K, V>> newBulkMappingFunction(CacheLoader<? super K, V> cacheLoader) {
        if (!LocalLoadingCache.hasLoadAll(cacheLoader)) {
            return null;
        }
        return keysToLoad -> {
            try {
                Map loaded = cacheLoader.loadAll((Iterable)keysToLoad);
                return loaded;
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e3);
            }
            catch (Exception e4) {
                throw new CompletionException(e4);
            }
        };
    }

    public static boolean hasLoadAll(CacheLoader<?, ?> loader) {
        try {
            Method classLoadAll = loader.getClass().getMethod("loadAll", Iterable.class);
            Method defaultLoadAll = CacheLoader.class.getMethod("loadAll", Iterable.class);
            return !classLoadAll.equals(defaultLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e2) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e2);
            return false;
        }
    }
}

