/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020!H\u0016\u00a8\u0006#"}, d2={"Lksp/org/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "", "<init>", "()V", "indexFile", "", "stub", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "sink", "Lksp/com/intellij/psi/stubs/IndexSink;", "indexClass", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "indexFunction", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;", "indexTypeAlias", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "indexObject", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "indexProperty", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinPropertyStub;", "indexParameter", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinParameterStub;", "indexAnnotation", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "indexScript", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "createFileStub", "file", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "serializeFileStub", "dataStream", "Lksp/com/intellij/psi/stubs/StubOutputStream;", "deserializeFileStub", "Lksp/com/intellij/psi/stubs/StubInputStream;", "Companion", "psi"})
public class StubIndexService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final StubIndexService NO_INDEX = new StubIndexService();

    protected StubIndexService() {
    }

    public void indexFile(@NotNull KotlinFileStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexClass(@NotNull KotlinClassStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexFunction(@NotNull KotlinFunctionStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexTypeAlias(@NotNull KotlinTypeAliasStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexObject(@NotNull KotlinObjectStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexProperty(@NotNull KotlinPropertyStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexParameter(@NotNull KotlinParameterStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexAnnotation(@NotNull KotlinAnnotationEntryStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public void indexScript(@NotNull KotlinScriptStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new KotlinFileStubImpl(file2, file2.getPackageFqName().asString(), file2.isScript());
    }

    public void serializeFileStub(@NotNull KotlinFileStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub2.getPackageFqName().asString());
        dataStream.writeBoolean(stub2.isScript());
    }

    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef packageFqNameAsString = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        StringRef stringRef = packageFqNameAsString;
        Intrinsics.checkNotNull((Object)stringRef);
        String string2 = stringRef.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return new KotlinFileStubImpl(null, string2, isScript);
    }

    @JvmStatic
    @NotNull
    public static final StubIndexService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/psi/stubs/elements/StubIndexService$Companion;", "", "<init>", "()V", "getInstance", "Lksp/org/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "NO_INDEX", "psi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StubIndexService getInstance() {
            StubIndexService stubIndexService = ApplicationManager.getApplication().getService(StubIndexService.class);
            if (stubIndexService == null) {
                stubIndexService = NO_INDEX;
            }
            return stubIndexService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

