/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class ExceptionUtilRt {
    public static void rethrowUnchecked(@Nullable Throwable t2) throws RuntimeException, Error {
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
    }

    @Contract(value="!null->fail")
    public static void rethrowAll(@Nullable Throwable t2) throws Exception {
        if (t2 != null) {
            ExceptionUtilRt.rethrowUnchecked(t2);
            throw (Exception)t2;
        }
    }

    public static <T> T findCause(Throwable e2, Class<T> klass) {
        while (e2 != null && !klass.isInstance(e2)) {
            e2 = e2.getCause();
        }
        return (T)e2;
    }

    public static boolean causedBy(Throwable e2, Class<?> klass) {
        return ExceptionUtilRt.findCause(e2, klass) != null;
    }

    @NotNull
    public static Throwable unwrapInvocationTargetException(@NotNull Throwable throwable) {
        if (throwable == null) {
            ExceptionUtilRt.$$$reportNull$$$0(0);
        }
        return ExceptionUtilRt.unwrapException(throwable, InvocationTargetException.class);
    }

    @NotNull
    public static Throwable unwrapException(@NotNull Throwable throwable, @NotNull Class<? extends Throwable> classToUnwrap) {
        if (throwable == null) {
            ExceptionUtilRt.$$$reportNull$$$0(1);
        }
        if (classToUnwrap == null) {
            ExceptionUtilRt.$$$reportNull$$$0(2);
        }
        while (classToUnwrap.isInstance(throwable) && throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            ExceptionUtilRt.$$$reportNull$$$0(3);
        }
        return throwable2;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            ExceptionUtilRt.$$$reportNull$$$0(4);
        }
        if (stackFrameSkipPattern == null) {
            ExceptionUtilRt.$$$reportNull$$$0(5);
        }
        String prefix = "\tat ";
        String prefixProxy = "\tat $Proxy";
        String prefixRemoteUtil = "\tat com.intellij.execution.rmi.RemoteUtil";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            private boolean skipping;
            private boolean newLine;

            @Override
            public void print(String x) {
                if (x == null) {
                    return;
                }
                boolean curSkipping = this.skipping;
                if (!this.skipping && x.startsWith(skipPattern)) {
                    curSkipping = true;
                } else if (this.skipping && !x.startsWith("\tat ")) {
                    curSkipping = false;
                }
                if (curSkipping) {
                    if (!this.skipping) {
                        super.print("\tin " + ExceptionUtilRt.stripPackage(x, skipPattern.length()));
                        this.newLine = true;
                    }
                    this.skipping = !x.startsWith("\tat com.intellij.execution.rmi.RemoteUtil");
                } else if (!x.startsWith("\tat $Proxy")) {
                    super.print(x);
                    this.newLine = true;
                }
                this.skipping = curSkipping;
            }

            @Override
            public void println() {
                if (this.newLine) {
                    this.newLine = false;
                    super.println();
                }
            }
        };
        aThrowable.printStackTrace(writer);
        String string2 = stringWriter.toString();
        if (string2 == null) {
            ExceptionUtilRt.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static String stripPackage(String x, int offset) {
        int idx = offset;
        while (idx > 0 && idx < x.length() && !Character.isUpperCase(x.charAt(idx))) {
            idx = x.indexOf(46, idx) + 1;
        }
        return x.substring(Math.max(idx, offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToUnwrap";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/ExceptionUtilRt";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/ExceptionUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapException";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapInvocationTargetException";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrapException";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

