/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeArgumentsNotAllowedExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeArgumentsNotAllowedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1761#2,3:43\n*S KotlinDebug\n*F\n+ 1 FirTypeArgumentsNotAllowedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker\n*L\n33#1:43,3\n*E\n"})
public final class FirTypeArgumentsNotAllowedExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirTypeArgumentsNotAllowedExpressionChecker INSTANCE = new FirTypeArgumentsNotAllowedExpressionChecker();

    private FirTypeArgumentsNotAllowedExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirExpression explicitReceiver;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression firExpression = expression2.getExplicitReceiver();
        FirExpression firExpression2 = explicitReceiver = firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
        if (explicitReceiver instanceof FirResolvedQualifier && ((FirResolvedQualifier)explicitReceiver).getSymbol() == null && !((Collection)((FirResolvedQualifier)explicitReceiver).getTypeArguments()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedQualifier)explicitReceiver).getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED(), (Object)"for packages", (DiagnosticContext)context2, null, 16, null);
            return;
        }
        if (expression2 instanceof FirImplicitInvokeCall && explicitReceiver instanceof FirPropertyAccessExpression) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = ((FirImplicitInvokeCall)expression2).getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeProjection it = (FirTypeProjection)element$iv;
                        boolean bl3 = false;
                        if (!FirHelpersKt.isExplicit(it)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
                boolean bl4 = firCallableSymbol != null && (firCallableSymbol = firCallableSymbol.getTypeParameterSymbols()) != null ? !((Collection)((Object)firCallableSymbol)).isEmpty() : false;
                if (bl4) {
                    FirCallableSymbol<?> firCallableSymbol2 = ReferenceUtilsKt.toResolvedCallableSymbol((FirResolvable)((Object)explicitReceiver));
                    boolean bl5 = firCallableSymbol2 != null && (firCallableSymbol2 = firCallableSymbol2.getTypeParameterSymbols()) != null ? !((Collection)((Object)firCallableSymbol2)).isEmpty() : false;
                    if (bl5) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirImplicitInvokeCall)expression2).getCalleeReference().getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED(), (Object)"on implicit invoke call", (DiagnosticContext)context2, null, 16, null);
                        return;
                    }
                }
            }
        }
    }
}

