/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformer;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "computationSession", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;)V", "acceptableFqNames", "", "Lksp/org/jetbrains/kotlin/name/FqName;", "isAcceptable", "", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformFile", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "", "resolve"})
final class FirPartialImportResolveTransformer
extends FirImportResolveTransformer {
    @NotNull
    private final CompilerRequiredAnnotationsComputationSession computationSession;
    @NotNull
    private final Set<FqName> acceptableFqNames;

    public FirPartialImportResolveTransformer(@NotNull FirSession session, @NotNull CompilerRequiredAnnotationsComputationSession computationSession) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)computationSession, (String)"computationSession");
        super(session, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        this.computationSession = computationSession;
        this.acceptableFqNames = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(session).getAnnotations();
    }

    @Override
    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptable, (String)"<this>");
        return this.acceptableFqNames.contains($this$isAcceptable);
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.computationSession.importsAreResolved(file2)) {
            return file2;
        }
        FirFile it = firFile = super.transformFile(file2, data);
        boolean bl2 = false;
        this.computationSession.recordThatImportsAreResolved(file2);
        return firFile;
    }
}

