/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtTypeProjectionElementType;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u0005*\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00050\bH\u0002\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\tH\u0016J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\f*\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\f*\u00020\rH\u0016J0\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00182\u0014\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001d0\u001cH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0018*\u0004\u0018\u00010\tH\u0002J\u0013\u0010\u001f\u001a\u0004\u0018\u00010\f*\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u0004\u0018\u00010\f*\u00020 H\u0016\u00a2\u0006\u0002\u0010!\u00a8\u0006#"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "<init>", "()V", "withSource", "T", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "f", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isInConstructorCallee", "", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "isInTypeConstraint", "getRawIdentifier", "", "getRawName", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isCatchElementParameter", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isRedundantNullable", "getNullableChild", "Lksp/com/intellij/lang/LighterASTNode;", "source", "node", "ref", "Lksp/com/intellij/openapi/util/Ref;", "", "getParentOfParent", "hasBody", "Lksp/org/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "(Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;)Ljava/lang/Boolean;", "hasInitializer", "checkers"})
@SourceDebugExtension(value={"SMAP\nSourceNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1761#3,3:200\n1761#3,3:203\n*S KotlinDebug\n*F\n+ 1 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator\n*L\n137#1:200,3\n143#1:203,3\n*E\n"})
class LightTreeSourceNavigator
implements SourceNavigator {
    private final <T> T withSource(FirElement $this$withSource, Function1<? super KtSourceElement, ? extends T> f2) {
        Object object;
        KtSourceElement ktSourceElement = $this$withSource.getSource();
        if (ktSourceElement != null) {
            KtSourceElement it = ktSourceElement;
            boolean bl2 = false;
            object = f2.invoke((Object)it);
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    public boolean isInConstructorCallee(@NotNull FirTypeRef $this$isInConstructorCallee) {
        Intrinsics.checkNotNullParameter((Object)$this$isInConstructorCallee, (String)"<this>");
        Boolean bl2 = (Boolean)this.withSource($this$isInConstructorCallee, LightTreeSourceNavigator::isInConstructorCallee$lambda$1);
        return bl2 != null ? bl2 : false;
    }

    @Override
    public boolean isInTypeConstraint(@NotNull FirTypeRef $this$isInTypeConstraint) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$isInTypeConstraint, (String)"<this>");
            KtSourceElement ktSourceElement = $this$isInTypeConstraint.getSource();
            if (ktSourceElement == null) {
                return false;
            }
            KtSourceElement source = ktSourceElement;
            Sequence<LighterASTNode> sequence2 = LightTreePositioningStrategiesKt.getAncestors(source.getTreeStructure(), source.getLighterASTNode());
            for (Object e2 : sequence2) {
                LighterASTNode it = (LighterASTNode)e2;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.TYPE_CONSTRAINT) || Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.TYPE_PARAMETER))) continue;
                v1 = e2;
                break block2;
            }
            v1 = null;
        }
        LighterASTNode lighterASTNode = v1;
        return Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.TYPE_CONSTRAINT);
    }

    @Override
    @Nullable
    public CharSequence getRawIdentifier(@NotNull KtSourceElement $this$getRawIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getRawIdentifier, (String)"<this>");
        IElementType iElementType = $this$getRawIdentifier.getElementType();
        return iElementType instanceof KtNameReferenceExpressionElementType || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IDENTIFIER) ? (CharSequence)$this$getRawIdentifier.getLighterASTNode().toString() : (iElementType instanceof KtTypeProjectionElementType ? (CharSequence)CollectionsKt.last(LightTreeUtilsKt.getChildren($this$getRawIdentifier.getLighterASTNode(), $this$getRawIdentifier.getTreeStructure())).toString() : null);
    }

    @Override
    @Nullable
    public String getRawName(@NotNull FirDeclaration $this$getRawName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getRawName, (String)"<this>");
        KtSourceElement ktSourceElement = $this$getRawName.getSource();
        if (ktSourceElement != null) {
            KtSourceElement it = ktSourceElement;
            boolean bl2 = false;
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.nameIdentifier(it.getTreeStructure(), it.getLighterASTNode());
            string2 = lighterASTNode != null ? lighterASTNode.toString() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol $this$isCatchElementParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isCatchElementParameter, (String)"<this>");
        Object object = $this$isCatchElementParameter.getSource();
        return Intrinsics.areEqual(object != null && (object = this.getParentOfParent((KtSourceElement)object)) != null ? object.getTokenType() : null, (Object)KtNodeTypes.CATCH);
    }

    @Override
    public boolean isRedundantNullable(@NotNull FirTypeRef $this$isRedundantNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedundantNullable, (String)"<this>");
        KtSourceElement ktSourceElement = $this$isRedundantNullable.getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        Ref<LighterASTNode[]> ref = new Ref<LighterASTNode[]>();
        LighterASTNode lighterASTNode = this.getNullableChild(source, source.getLighterASTNode(), ref);
        if (lighterASTNode == null) {
            return false;
        }
        LighterASTNode firstChild = lighterASTNode;
        return this.getNullableChild(source, firstChild, ref) != null;
    }

    private final LighterASTNode getNullableChild(KtSourceElement source, LighterASTNode node, Ref<LighterASTNode[]> ref) {
        source.getTreeStructure().getChildren(node, ref);
        LighterASTNode[] lighterASTNodeArray = ref.get();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNodeArray, (String)"get(...)");
        LighterASTNode lighterASTNode = (LighterASTNode)ArraysKt.firstOrNull((Object[])lighterASTNodeArray);
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode firstChild = lighterASTNode;
        return !Intrinsics.areEqual((Object)firstChild.getTokenType(), (Object)KtNodeTypes.NULLABLE_TYPE) ? null : firstChild;
    }

    private final LighterASTNode getParentOfParent(KtSourceElement $this$getParentOfParent) {
        LighterASTNode parent2;
        block1: {
            KtSourceElement ktSourceElement = $this$getParentOfParent;
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            parent2 = null;
            LighterASTNode lighterASTNode = parent2 = source.getTreeStructure().getParent(source.getLighterASTNode());
            if (lighterASTNode == null) break block1;
            LighterASTNode it = lighterASTNode;
            boolean bl2 = false;
            parent2 = source.getTreeStructure().getParent(it);
        }
        return parent2;
    }

    @Override
    @Nullable
    public Boolean hasBody(@NotNull FirEnumEntry $this$hasBody) {
        boolean bl2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$hasBody, (String)"<this>");
            KtSourceElement ktSourceElement = $this$hasBody.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            List<LighterASTNode> childNodes = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
            Iterable $this$any$iv = childNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.CLASS_BODY)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    @Override
    @Nullable
    public Boolean hasInitializer(@NotNull FirEnumEntry $this$hasInitializer) {
        boolean bl2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$hasInitializer, (String)"<this>");
            KtSourceElement ktSourceElement = $this$hasInitializer.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            List<LighterASTNode> childNodes = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
            Iterable $this$any$iv = childNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.INITIALIZER_LIST)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private static final boolean isInConstructorCallee$lambda$1(KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        LighterASTNode lighterASTNode = source.getTreeStructure().getParent(source.getLighterASTNode());
        return Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.CONSTRUCTOR_CALLEE);
    }
}

