/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source;

import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiImportStatement;
import ksp.com.intellij.psi.PsiImportStaticReferenceElement;
import ksp.com.intellij.psi.PsiImportStaticStatement;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiModifierListOwner;
import ksp.com.intellij.psi.PsiNamedElement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiReferenceParameterList;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.filters.ClassFilter;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.resolve.ResolveCache;
import ksp.com.intellij.psi.impl.source.resolve.StaticImportResolveProcessor;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.processor.FilterScopeProcessor;
import ksp.com.intellij.psi.scope.util.PsiScopesUtil;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public final class PsiImportStaticReferenceElementImpl
extends CompositePsiElement
implements PsiImportStaticReferenceElement {
    private static final Logger LOG = Logger.getInstance(PsiImportStaticReferenceElementImpl.class);
    private volatile String myCanonicalText;

    public PsiImportStaticReferenceElementImpl() {
        super(JavaElementType.IMPORT_STATIC_REFERENCE);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        if (refName != null) {
            return refName.getStartOffset();
        }
        return super.getTextOffset();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCanonicalText = null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement node = this.getFirstChildNode();
                return node.getElementType() == JavaElementType.JAVA_CODE_REFERENCE ? node : null;
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i2 == JavaTokenType.DOT) {
            return 55;
        }
        if (i2 == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(1);
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiImportStaticStatement bindToTargetClass(PsiClass aClass) throws IncorrectOperationException {
        String qualifiedName2 = aClass.getQualifiedName();
        if (qualifiedName2 == null) {
            throw new IncorrectOperationException();
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        CompositeElement newRef = (CompositeElement)parserFacade.createReferenceFromText(qualifiedName2, null).getNode();
        if (this.getQualifier() != null) {
            this.replaceChildInternal(this.findChildByRole(54), newRef);
            return (PsiImportStaticStatement)this.getParent();
        }
        LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, SharedImplUtil.findCharTableByTree(newRef), this.getManager());
        newRef.rawInsertAfterMe(dot);
        CompositeElement errorElement = Factory.createErrorElement(JavaPsiBundle.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
        dot.rawInsertAfterMe(errorElement);
        CompositeElement parentComposite = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.getParent());
        parentComposite.addInternal(newRef, errorElement, this, Boolean.TRUE);
        parentComposite.deleteChildInternal(this);
        return (PsiImportStaticStatement)SourceTreeToPsiMap.treeElementToPsi(parentComposite);
    }

    @Override
    public boolean isQualified() {
        return this.findChildByRole(54) != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.findChildByRole(53);
        if (childByRole == null) {
            return "";
        }
        return childByRole.getText();
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiImportStaticReferenceElementImpl psiImportStaticReferenceElementImpl = this;
        if (psiImportStaticReferenceElementImpl == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(2);
        }
        return psiImportStaticReferenceElementImpl;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String canonicalText = this.myCanonicalText;
        if (canonicalText == null) {
            this.myCanonicalText = canonicalText = this.calcCanonicalText();
        }
        String string2 = canonicalText;
        if (string2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private String calcCanonicalText() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getQualifier();
        if (referenceElement == null) {
            return this.getReferenceName();
        }
        return referenceElement.getCanonicalText() + "." + this.getReferenceName();
    }

    @Override
    public String toString() {
        return "PsiImportStaticReferenceElement:" + this.getText();
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(4);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(5);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, OurGenericsResolver.INSTANCE, false, incompleteCode, file2);
        JavaResolveResult[] javaResolveResultArray = results instanceof JavaResolveResult[] ? (JavaResolveResult[])results : JavaResolveResult.EMPTY_ARRAY;
        if (javaResolveResultArray == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(6);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(7);
        }
        String name2 = this.getReferenceName();
        if (!(element2 instanceof PsiNamedElement) || !name2.equals(((PsiNamedElement)element2).getName())) {
            return false;
        }
        for (JavaResolveResult result2 : this.multiResolve(false)) {
            if (!this.getManager().areElementsEquivalent(result2.getElement(), element2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier;
        if (newElementName == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(8);
        }
        if ((oldIdentifier = this.findChildByRoleAsPsiElement(53)) == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(9);
        }
        if (!(element2 instanceof PsiMember) || !(element2 instanceof PsiNamedElement) || ((PsiNamedElement)element2).getName() == null) {
            throw new IncorrectOperationException();
        }
        if (!((PsiModifierListOwner)element2).hasModifierProperty("static")) {
            if (element2 instanceof PsiClass && ((PsiClass)element2).getContainingClass() == null) {
                return this.replaceWithRegularImport((PsiClass)element2);
            }
            throw new IncorrectOperationException();
        }
        PsiClass containingClass = ((PsiMember)element2).getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException();
        }
        PsiElement qualifier2 = this.getQualifier();
        if (qualifier2 == null) {
            throw new IncorrectOperationException();
        }
        ((PsiReference)((Object)qualifier2)).bindToElement(containingClass);
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(((PsiNamedElement)element2).getName());
        oldIdentifier.replace(identifier);
        return this;
    }

    private PsiElement replaceWithRegularImport(PsiClass psiClass) throws IncorrectOperationException {
        PsiImportStaticStatement baseStatement = PsiTreeUtil.getParentOfType(this.getElement(), PsiImportStaticStatement.class);
        PsiImportStatement statement = JavaPsiFacade.getElementFactory(this.getProject()).createImportStatement(psiClass);
        statement = (PsiImportStatement)baseStatement.replace(statement);
        PsiJavaCodeReferenceElement reference2 = statement.getImportReference();
        assert (reference2 != null);
        return reference2;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(10);
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)new ClassFilter(PsiModifierListOwner.class), processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(11);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportStaticReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiImportStaticReferenceElementImpl> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        public JavaResolveResult @NotNull [] resolve(@NotNull PsiImportStaticReferenceElementImpl referenceElement, boolean incompleteCode) {
            PsiElement qualifier2;
            if (referenceElement == null) {
                OurGenericsResolver.$$$reportNull$$$0(0);
            }
            if (!((qualifier2 = referenceElement.getQualifier()) instanceof PsiJavaCodeReferenceElement)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    OurGenericsResolver.$$$reportNull$$$0(1);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiElement target = ((PsiJavaCodeReferenceElement)qualifier2).resolve();
            if (!(target instanceof PsiClass)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    OurGenericsResolver.$$$reportNull$$$0(2);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            StaticImportResolveProcessor processor = new StaticImportResolveProcessor(referenceElement);
            target.processDeclarations(processor, ResolveState.initial(), referenceElement, referenceElement);
            JavaResolveResult[] javaResolveResultArray = processor.getResults();
            if (javaResolveResultArray == null) {
                OurGenericsResolver.$$$reportNull$$$0(3);
            }
            return javaResolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

