/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.ClassExtension;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.ElementManipulator;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

public final class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "ksp.com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance(ElementManipulators.class);

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element2) {
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(0);
        }
        return (ElementManipulator)INSTANCE.forClass(element2.getClass());
    }

    public static int getOffsetInElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(1);
        }
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getNotNullManipulator(element2);
        return ElementManipulators.getManipulatorRange(manipulator, element2).getStartOffset();
    }

    @NotNull
    public static <T extends PsiElement> ElementManipulator<T> getNotNullManipulator(@NotNull T element2) {
        ElementManipulator<T> manipulator;
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((manipulator = ElementManipulators.getManipulator(element2)) != null, element2.getClass().getName());
        ElementManipulator<T> elementManipulator = manipulator;
        if (elementManipulator == null) {
            ElementManipulators.$$$reportNull$$$0(3);
        }
        return elementManipulator;
    }

    @NotNull
    public static TextRange getValueTextRange(@NotNull PsiElement element2) {
        ElementManipulator<PsiElement> manipulator;
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(4);
        }
        return (manipulator = ElementManipulators.getManipulator(element2)) == null ? TextRange.from(0, element2.getTextLength()) : ElementManipulators.getManipulatorRange(manipulator, element2);
    }

    @NotNull
    public static String getValueText(@NotNull PsiElement element2) {
        TextRange valueTextRange;
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(5);
        }
        if ((valueTextRange = ElementManipulators.getValueTextRange(element2)).isEmpty()) {
            return "";
        }
        String text = element2.getText();
        if (valueTextRange.getEndOffset() > text.length()) {
            LOG.error("Wrong range for " + element2 + " text: " + text + " range " + valueTextRange);
        }
        String string2 = valueTextRange.substring(text);
        if (string2 == null) {
            ElementManipulators.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public static <T extends PsiElement> T handleContentChange(@NotNull T element2, String text) {
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(7);
        }
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element2);
        return manipulator.handleContentChange(element2, text);
    }

    public static <T extends PsiElement> T handleContentChange(@NotNull T element2, @NotNull TextRange range, String text) {
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(8);
        }
        if (range == null) {
            ElementManipulators.$$$reportNull$$$0(9);
        }
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element2);
        return manipulator.handleContentChange(element2, range, text);
    }

    @NotNull
    private static TextRange getManipulatorRange(@NotNull ElementManipulator<? super PsiElement> manipulator, @NotNull PsiElement element2) {
        if (manipulator == null) {
            ElementManipulators.$$$reportNull$$$0(10);
        }
        if (element2 == null) {
            ElementManipulators.$$$reportNull$$$0(11);
        }
        TextRange rangeInElement = manipulator.getRangeInElement(element2);
        TextRange elementRange = TextRange.from(0, element2.getTextLength());
        if (!elementRange.contains(rangeInElement)) {
            LOG.error("Element range: " + elementRange + ";\nmanipulator range: " + rangeInElement + ";\nelement: " + element2.getClass() + ";\nmanipulator: " + manipulator.getClass() + ".");
        }
        TextRange textRange = rangeInElement;
        if (textRange == null) {
            ElementManipulators.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/ElementManipulators";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manipulator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/ElementManipulators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullManipulator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulatorRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManipulator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullManipulator";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getManipulatorRange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

