/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen.optimization.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.codegen.optimization.common.BackwardAnalysisInterpreter;
import ksp.org.jetbrains.kotlin.codegen.optimization.common.BackwardAnalysisKt;
import ksp.org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import ksp.org.jetbrains.kotlin.codegen.optimization.common.VariableLivenessFrame;
import ksp.org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.MethodNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"analyzeLiveness", "", "Lksp/org/jetbrains/kotlin/codegen/optimization/common/VariableLivenessFrame;", "method", "Lksp/org/jetbrains/org/objectweb/asm/tree/MethodNode;", "defVar", "", "frame", "insn", "Lksp/org/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "useVar", "backend"})
public final class VariableLivenessKt {
    @NotNull
    public static final List<VariableLivenessFrame> analyzeLiveness(@NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return BackwardAnalysisKt.analyze(method, new BackwardAnalysisInterpreter<VariableLivenessFrame>(){

            public VariableLivenessFrame newFrame(int maxLocals) {
                return new VariableLivenessFrame(maxLocals);
            }

            public void def(VariableLivenessFrame frame, AbstractInsnNode insn) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                VariableLivenessKt.access$defVar(frame, insn);
            }

            public void use(VariableLivenessFrame frame, AbstractInsnNode insn) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                VariableLivenessKt.access$useVar(frame, insn);
            }
        });
    }

    private static final void defVar(VariableLivenessFrame frame, AbstractInsnNode insn) {
        if (insn instanceof VarInsnNode && UtilKt.isStoreOperation(insn)) {
            frame.markDead(((VarInsnNode)insn).var);
        }
    }

    private static final void useVar(VariableLivenessFrame frame, AbstractInsnNode insn) {
        if (insn instanceof VarInsnNode && UtilKt.isLoadOperation(insn)) {
            frame.markAlive(((VarInsnNode)insn).var);
        } else if (insn instanceof IincInsnNode) {
            frame.markAlive(((IincInsnNode)insn).var);
        }
    }

    public static final /* synthetic */ void access$defVar(VariableLivenessFrame frame, AbstractInsnNode insn) {
        VariableLivenessKt.defVar(frame, insn);
    }

    public static final /* synthetic */ void access$useVar(VariableLivenessFrame frame, AbstractInsnNode insn) {
        VariableLivenessKt.useVar(frame, insn);
    }
}

