/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source;

import java.util.Collection;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiCompiledElement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiElementResolveResult;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.PsiJavaModule;
import ksp.com.intellij.psi.PsiJavaModuleReference;
import ksp.com.intellij.psi.PsiJavaModuleReferenceElement;
import ksp.com.intellij.psi.PsiPackageAccessibilityStatement;
import ksp.com.intellij.psi.PsiReferenceBase;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.psi.impl.source.resolve.ResolveCache;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiJavaModuleReferenceImpl
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement>
implements PsiJavaModuleReference {
    public PsiJavaModuleReferenceImpl(@NotNull PsiJavaModuleReferenceElement element2) {
        if (element2 == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(0);
        }
        super(element2, new TextRange(0, element2.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public PsiJavaModule resolve() {
        return (PsiJavaModule)super.resolve();
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element2;
        if (newName == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(3);
        }
        if ((element2 = (PsiJavaModuleReferenceElement)this.getElement()) instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaPsiBundle.message("psi.error.attempt.to.edit.class.file", element2.getContainingFile()));
        }
        PsiJavaModuleReferenceElement newElement = PsiElementFactory.getInstance(element2.getProject()).createModuleReferenceFromText(newName, null);
        return element2.replace(newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        public ResolveResult @NotNull [] resolve(@NotNull PsiJavaModuleReferenceImpl reference2, boolean incompleteCode) {
            PsiJavaModule module2;
            if (reference2 == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            PsiJavaModuleReferenceElement refElement = (PsiJavaModuleReferenceElement)reference2.getElement();
            PsiFile file = refElement.getContainingFile();
            String moduleName = reference2.getCanonicalText();
            if (file instanceof PsiJavaFile && (module2 = ((PsiJavaFile)file).getModuleDeclaration()) != null && module2.getName().equals(moduleName)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(module2)};
                if (resolveResultArray == null) {
                    Resolver.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            boolean global = incompleteCode || refElement.getParent() instanceof PsiPackageAccessibilityStatement;
            Project project = file.getProject();
            GlobalSearchScope scope = global ? GlobalSearchScope.allScope(project) : file.getResolveScope();
            Collection<PsiJavaModule> modules = JavaPsiFacade.getInstance(project).findModules(moduleName, scope);
            if (!modules.isEmpty()) {
                ResolveResult[] result2 = new ResolveResult[modules.size()];
                int i2 = 0;
                for (PsiJavaModule module3 : modules) {
                    result2[i2++] = new PsiElementResolveResult(module3);
                }
                if (result2 == null) {
                    Resolver.$$$reportNull$$$0(2);
                }
                return result2;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl$Resolver";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl$Resolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

