/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.jvm.util;

import java.util.Comparator;
import ksp.com.intellij.lang.jvm.JvmClass;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JvmClassUtil {
    private JvmClassUtil() {
    }

    @Nullable
    public static String getJvmClassName(@NotNull JvmClass aClass) {
        String qualifiedName2;
        if (aClass == null) {
            JvmClassUtil.$$$reportNull$$$0(0);
        }
        SmartList<String> parts = new SmartList<String>();
        JvmClass current = aClass;
        while (true) {
            JvmClass containingClass;
            if ((containingClass = current.getContainingClass()) == null) {
                qualifiedName2 = current.getQualifiedName();
                if (qualifiedName2 == null) {
                    return null;
                }
                break;
            }
            String name2 = current.getName();
            if (name2 == null) {
                return null;
            }
            parts.add(name2);
            current = containingClass;
        }
        parts.add(qualifiedName2);
        return StringUtil.join(ContainerUtil.reverse(parts), "$");
    }

    @Contract(pure=true)
    @NotNull
    public static Comparator<JvmClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JvmClassUtil.$$$reportNull$$$0(1);
        }
        Comparator comparator = (c1, c2) -> {
            VirtualFile file1 = PsiUtilCore.getVirtualFile(c1.getSourceElement());
            VirtualFile file2 = PsiUtilCore.getVirtualFile(c2.getSourceElement());
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope.compare(file2, file1);
        };
        if (comparator == null) {
            JvmClassUtil.$$$reportNull$$$0(2);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/jvm/util/JvmClassUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/jvm/util/JvmClassUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeComparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJvmClassName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScopeComparator";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

