/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.util;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.util.PerformanceMeasurement;
import ksp.org.jetbrains.kotlin.util.PhaseType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0005\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/util/PhasePerformanceMeasurement;", "Lksp/org/jetbrains/kotlin/util/PerformanceMeasurement;", "milliseconds", "", "<init>", "(J)V", "getMilliseconds", "()J", "phase", "Lksp/org/jetbrains/kotlin/util/PhaseType;", "getPhase", "()Lorg/jetbrains/kotlin/util/PhaseType;", "name", "", "getName", "()Ljava/lang/String;", "render", "lines", "", "Lksp/org/jetbrains/kotlin/util/BackendMeasurement;", "Lksp/org/jetbrains/kotlin/util/CodeAnalysisMeasurement;", "Lksp/org/jetbrains/kotlin/util/CompilerInitializationMeasurement;", "Lksp/org/jetbrains/kotlin/util/IrLoweringMeasurement;", "Lksp/org/jetbrains/kotlin/util/TranslationToIrMeasurement;", "compiler.common"})
public abstract class PhasePerformanceMeasurement
implements PerformanceMeasurement {
    private final long milliseconds;

    private PhasePerformanceMeasurement(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public final long getMilliseconds() {
        return this.milliseconds;
    }

    @NotNull
    public abstract PhaseType getPhase();

    @NotNull
    public abstract String getName();

    @Override
    @NotNull
    public String render(int lines) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "%20s%8s ms";
        Object[] objectArray = new Object[]{this.getName(), this.milliseconds};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        if (this.getPhase() != PhaseType.Initialization && lines != 0) {
            double lps = (double)lines * (double)1000 / (double)this.milliseconds;
            String string5 = "%12.3f loc/s";
            Object[] objectArray2 = new Object[]{lps};
            String string6 = String.format(string5, Arrays.copyOf(objectArray2, objectArray2.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        } else {
            string2 = "";
        }
        return stringBuilder2.append(string2).toString();
    }

    public /* synthetic */ PhasePerformanceMeasurement(long milliseconds, DefaultConstructorMarker $constructor_marker) {
        this(milliseconds);
    }
}

