/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.util;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.platform.JsPlatformKt;
import ksp.org.jetbrains.kotlin.platform.TargetPlatform;
import ksp.org.jetbrains.kotlin.util.BackendMeasurement;
import ksp.org.jetbrains.kotlin.util.BinaryClassFromKotlinFileMeasurement;
import ksp.org.jetbrains.kotlin.util.CodeAnalysisMeasurement;
import ksp.org.jetbrains.kotlin.util.CompilerInitializationMeasurement;
import ksp.org.jetbrains.kotlin.util.CounterMeasurement;
import ksp.org.jetbrains.kotlin.util.FindJavaClassMeasurement;
import ksp.org.jetbrains.kotlin.util.GarbageCollectionMeasurement;
import ksp.org.jetbrains.kotlin.util.IrLoweringMeasurement;
import ksp.org.jetbrains.kotlin.util.JitCompilationMeasurement;
import ksp.org.jetbrains.kotlin.util.PerformanceCounter;
import ksp.org.jetbrains.kotlin.util.PerformanceCounterMeasurement;
import ksp.org.jetbrains.kotlin.util.PerformanceMeasurement;
import ksp.org.jetbrains.kotlin.util.PhasePerformanceMeasurement;
import ksp.org.jetbrains.kotlin.util.PhaseType;
import ksp.org.jetbrains.kotlin.util.PotentiallyIncorrectPhaseTimeMeasurement;
import ksp.org.jetbrains.kotlin.util.TranslationToIrMeasurement;
import ksp.org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001[B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u00108\u001a\u00020\u0005J\u0006\u00109\u001a\u00020\u000eJ\u0010\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010\u0000J\u000e\u0010C\u001a\u00020A2\u0006\u0010&\u001a\u00020!J\u0018\u0010D\u001a\u00020A2\u0006\u0010.\u001a\u00020-2\u0006\u00103\u001a\u00020-H\u0016J\u000e\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0010J\u000e\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020\u0010J\b\u0010I\u001a\u00020AH\u0016J\b\u0010J\u001a\u00020AH\u0007J\u0010\u0010K\u001a\u00020A2\u0006\u0010H\u001a\u00020\u0010H\u0002J\b\u0010L\u001a\u00020AH\u0002J\b\u0010M\u001a\u00020AH\u0002J\b\u0010N\u001a\u00020AH\u0002J/\u0010O\u001a\u0002HP\"\u0004\b\u0000\u0010P2\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HP0SH\u0000\u00a2\u0006\u0004\bT\u0010UJ\u000e\u0010V\u001a\u00020A2\u0006\u0010W\u001a\u00020XJ\u0006\u0010Y\u001a\u00020\u0005J\b\u0010Z\u001a\u00020AH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020(0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u000b\"\u0004\b+\u0010,R$\u0010.\u001a\u00020-2\u0006\u0010 \u001a\u00020-@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00103\u001a\u00020-2\u0006\u0010 \u001a\u00020-@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00100\"\u0004\b5\u00102R\u001e\u00106\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010#R\u0011\u00107\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010#R!\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b<\u0010=\u00a8\u0006\\"}, d2={"Lksp/org/jetbrains/kotlin/util/PerformanceManager;", "", "targetPlatform", "Lksp/org/jetbrains/kotlin/platform/TargetPlatform;", "presentableName", "", "<init>", "(Lorg/jetbrains/kotlin/platform/TargetPlatform;Ljava/lang/String;)V", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPresentableName", "()Ljava/lang/String;", "counterMeasurementsLock", "currentTime", "", "currentPhaseType", "Lksp/org/jetbrains/kotlin/util/PhaseType;", "phaseStartNanos", "Ljava/lang/Long;", "phaseMeasurementsMs", "Ljava/util/SortedMap;", "counterMeasurements", "", "Lkotlin/reflect/KClass;", "Lksp/org/jetbrains/kotlin/util/CounterMeasurement;", "gcMeasurements", "Lksp/org/jetbrains/kotlin/util/GarbageCollectionMeasurement;", "jitMeasurement", "Lksp/org/jetbrains/kotlin/util/JitCompilationMeasurement;", "extraMeasurements", "", "Lksp/org/jetbrains/kotlin/util/PerformanceMeasurement;", "value", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "isK2", "startGCData", "Lksp/org/jetbrains/kotlin/util/PerformanceManager$GCData;", "targetDescription", "getTargetDescription", "setTargetDescription", "(Ljava/lang/String;)V", "", "files", "getFiles", "()I", "setFiles", "(I)V", "lines", "getLines", "setLines", "isFinalized", "isMeasuring", "getTargetInfo", "getLoweringAndBackendTimeMs", "measurements", "", "getMeasurements", "()Ljava/util/List;", "measurements$delegate", "Lkotlin/Lazy;", "addMeasurementResults", "", "otherPerformanceManager", "enableCollectingPerformanceStatistics", "addSourcesStats", "notifyPhaseStarted", "newPhaseType", "notifyPhaseFinished", "phaseType", "notifyCompilationFinished", "notifyCurrentPhaseFinishedIfNeeded", "finishPhase", "recordGcTime", "recordJitCompilationTime", "recordPerfCountersMeasurements", "measureTime", "T", "measurementClass", "block", "Lkotlin/Function0;", "measureTime$compiler_common", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dumpPerformanceReport", "destination", "Ljava/io/File;", "createPerformanceReport", "ensureNotFinalized", "GCData", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nPerformanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceManager.kt\norg/jetbrains/kotlin/util/PerformanceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n808#2,11:323\n808#2,11:335\n1267#2,4:346\n1869#2,2:350\n1563#2:352\n1634#2,3:353\n1869#2,2:356\n1869#2,2:358\n1#3:334\n*S KotlinDebug\n*F\n+ 1 PerformanceManager.kt\norg/jetbrains/kotlin/util/PerformanceManager\n*L\n65#1:323,11\n66#1:335,11\n139#1:346,4\n219#1:350,2\n275#1:352\n275#1:353,3\n275#1:356,2\n84#1:358,2\n*E\n"})
public abstract class PerformanceManager {
    @NotNull
    private final TargetPlatform targetPlatform;
    @NotNull
    private final String presentableName;
    @NotNull
    private final Object counterMeasurementsLock;
    @NotNull
    private PhaseType currentPhaseType;
    @Nullable
    private Long phaseStartNanos;
    @NotNull
    private final SortedMap<PhaseType, Long> phaseMeasurementsMs;
    @NotNull
    private final Map<KClass<?>, CounterMeasurement> counterMeasurements;
    @NotNull
    private SortedMap<String, GarbageCollectionMeasurement> gcMeasurements;
    @Nullable
    private JitCompilationMeasurement jitMeasurement;
    @NotNull
    private final List<PerformanceMeasurement> extraMeasurements;
    private boolean isEnabled;
    private boolean isK2;
    @NotNull
    private Map<String, GCData> startGCData;
    @Nullable
    private String targetDescription;
    private int files;
    private int lines;
    private boolean isFinalized;
    @NotNull
    private final Lazy measurements$delegate;

    public PerformanceManager(@NotNull TargetPlatform targetPlatform, @NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)presentableName2, (String)"presentableName");
        this.targetPlatform = targetPlatform;
        this.presentableName = presentableName2;
        this.counterMeasurementsLock = new Object();
        this.currentPhaseType = PhaseType.Initialization;
        this.phaseStartNanos = this.currentTime();
        this.phaseMeasurementsMs = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class), (Object)new FindJavaClassMeasurement(0, 0L)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class), (Object)new BinaryClassFromKotlinFileMeasurement(0, 0L))};
        this.counterMeasurements = MapsKt.mutableMapOf((Pair[])pairArray);
        this.gcMeasurements = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.extraMeasurements = new ArrayList();
        this.isK2 = true;
        this.startGCData = new LinkedHashMap();
        this.measurements$delegate = LazyKt.lazy(() -> PerformanceManager.measurements_delegate$lambda$4(this));
    }

    @NotNull
    public final TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public final String getPresentableName() {
        return this.presentableName;
    }

    private final long currentTime() {
        return System.nanoTime();
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl2) {
        this.isEnabled = bl2;
    }

    public final boolean isK2() {
        return this.isK2;
    }

    @Nullable
    public final String getTargetDescription() {
        return this.targetDescription;
    }

    public final void setTargetDescription(@Nullable String string2) {
        this.targetDescription = string2;
    }

    public final int getFiles() {
        return this.files;
    }

    protected final void setFiles(int n2) {
        this.files = n2;
    }

    public final int getLines() {
        return this.lines;
    }

    protected final void setLines(int n2) {
        this.lines = n2;
    }

    public final boolean isFinalized() {
        return this.isFinalized;
    }

    public final boolean isMeasuring() {
        return this.phaseStartNanos != null;
    }

    @NotNull
    public final String getTargetInfo() {
        return this.targetDescription + ", " + this.files + " files (" + this.lines + " lines)";
    }

    public final long getLoweringAndBackendTimeMs() {
        BackendMeasurement it;
        long l2;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getMeasurements();
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrLoweringMeasurement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        long $i$f$filterIsInstance22 = 0L;
        for (Object $i$f$filterIsInstanceTo2 : $this$filterIsInstance$iv) {
            IrLoweringMeasurement irLoweringMeasurement = (IrLoweringMeasurement)$i$f$filterIsInstanceTo2;
            l2 = $i$f$filterIsInstance22;
            boolean bl2 = false;
            long l3 = it.getMilliseconds();
            $i$f$filterIsInstance22 = l2 + l3;
        }
        $this$filterIsInstance$iv = this.getMeasurements();
        l2 = $i$f$filterIsInstance22;
        boolean $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BackendMeasurement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Iterable iterable2 = list;
        long l4 = 0L;
        for (Object t2 : iterable2) {
            it = (BackendMeasurement)t2;
            long l5 = l4;
            boolean bl3 = false;
            long l6 = it.getMilliseconds();
            l4 = l5 + l6;
        }
        long l7 = l4;
        return l2 + l7;
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurements() {
        Lazy lazy = this.measurements$delegate;
        return (List)lazy.getValue();
    }

    public final void addMeasurementResults(@Nullable PerformanceManager otherPerformanceManager) {
        this.ensureNotFinalized();
        if (otherPerformanceManager == null) {
            return;
        }
        this.files += otherPerformanceManager.files;
        this.lines += otherPerformanceManager.lines;
        for (Map.Entry entry : ((Map)otherPerformanceManager.phaseMeasurementsMs).entrySet()) {
            PhaseType phase = (PhaseType)((Object)entry.getKey());
            Long otherPhaseMeasurementMs = (Long)entry.getValue();
            Map map = this.phaseMeasurementsMs;
            Long l2 = (Long)this.phaseMeasurementsMs.get((Object)phase);
            long l3 = l2 != null ? l2 : 0L;
            Intrinsics.checkNotNull((Object)otherPhaseMeasurementMs);
            Long l4 = l3 + otherPhaseMeasurementMs;
            map.put(phase, l4);
        }
        for (Map.Entry<Object, Object> entry : otherPerformanceManager.counterMeasurements.entrySet()) {
            CounterMeasurement counterMeasurement;
            CounterMeasurement existingMeasurement;
            KClass counterMeasurementClass = (KClass)entry.getKey();
            CounterMeasurement otherCounterMeasurement = (CounterMeasurement)entry.getValue();
            CounterMeasurement counterMeasurement2 = existingMeasurement = this.counterMeasurements.get(counterMeasurementClass);
            int newCount = (counterMeasurement2 != null ? counterMeasurement2.getCount() : 0) + otherCounterMeasurement.getCount();
            CounterMeasurement counterMeasurement3 = existingMeasurement;
            long newMillis = (counterMeasurement3 != null ? counterMeasurement3.getMilliseconds() : 0L) + otherCounterMeasurement.getMilliseconds();
            Map<KClass<?>, CounterMeasurement> map = this.counterMeasurements;
            CounterMeasurement counterMeasurement4 = otherCounterMeasurement;
            if (counterMeasurement4 instanceof FindJavaClassMeasurement) {
                counterMeasurement = new FindJavaClassMeasurement(newCount, newMillis);
            } else if (counterMeasurement4 instanceof BinaryClassFromKotlinFileMeasurement) {
                counterMeasurement = new BinaryClassFromKotlinFileMeasurement(newCount, newMillis);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            counterMeasurement4 = counterMeasurement;
            map.put(counterMeasurementClass, counterMeasurement4);
        }
        for (Map.Entry<Object, Object> entry : ((Map)otherPerformanceManager.gcMeasurements).entrySet()) {
            String garbageCollectionKind = (String)entry.getKey();
            GarbageCollectionMeasurement otherGcMeasurement = (GarbageCollectionMeasurement)entry.getValue();
            GarbageCollectionMeasurement existingGcMeasurement = (GarbageCollectionMeasurement)this.gcMeasurements.get(garbageCollectionKind);
            Map map = this.gcMeasurements;
            Intrinsics.checkNotNull((Object)garbageCollectionKind);
            GarbageCollectionMeasurement garbageCollectionMeasurement = existingGcMeasurement;
            GarbageCollectionMeasurement garbageCollectionMeasurement2 = existingGcMeasurement;
            GarbageCollectionMeasurement garbageCollectionMeasurement3 = new GarbageCollectionMeasurement(garbageCollectionKind, (garbageCollectionMeasurement != null ? garbageCollectionMeasurement.getMilliseconds() : 0L) + otherGcMeasurement.getMilliseconds(), (garbageCollectionMeasurement2 != null ? garbageCollectionMeasurement2.getCount() : 0L) + otherGcMeasurement.getCount());
            map.put(garbageCollectionKind, garbageCollectionMeasurement3);
        }
        if (this.jitMeasurement != null || otherPerformanceManager.jitMeasurement != null) {
            JitCompilationMeasurement jitCompilationMeasurement = this.jitMeasurement;
            JitCompilationMeasurement jitCompilationMeasurement2 = otherPerformanceManager.jitMeasurement;
            this.jitMeasurement = new JitCompilationMeasurement((jitCompilationMeasurement != null ? jitCompilationMeasurement.getMilliseconds() : 0L) + (jitCompilationMeasurement2 != null ? jitCompilationMeasurement2.getMilliseconds() : 0L));
        }
        this.extraMeasurements.addAll((Collection<PerformanceMeasurement>)otherPerformanceManager.extraMeasurements);
    }

    /*
     * WARNING - void declaration
     */
    public final void enableCollectingPerformanceStatistics(boolean isK2) {
        void $this$associateTo$iv;
        this.isEnabled = true;
        this.isK2 = isK2;
        if (!isK2) {
            PerformanceCounter.Companion.setTimeCounterEnabled(true);
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable iterable = list;
        Map<String, GCData> destination$iv = this.startGCData;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<String, GCData> map = destination$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl2 = false;
            String string2 = it.getName();
            Intrinsics.checkNotNull((Object)it);
            Pair pair = TuplesKt.to((Object)string2, (Object)new GCData(it));
            map.put((String)pair.getFirst(), (GCData)pair.getSecond());
        }
    }

    public void addSourcesStats(int files2, int lines) {
        if (!this.isEnabled) {
            return;
        }
        this.ensureNotFinalized();
        this.files += files2;
        this.lines += lines;
    }

    public final void notifyPhaseStarted(@NotNull PhaseType newPhaseType) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)((Object)newPhaseType), (String)"newPhaseType");
        boolean bl3 = bl2 = this.phaseStartNanos == null;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-PerformanceManager$notifyPhaseStarted$32 = false;
            String $i$a$-assert-PerformanceManager$notifyPhaseStarted$32 = "The measurement for phase " + (Object)((Object)this.currentPhaseType) + " must have been finished before starting " + (Object)((Object)newPhaseType);
            throw new AssertionError((Object)$i$a$-assert-PerformanceManager$notifyPhaseStarted$32);
        }
        if (!JsPlatformKt.isJs(this.targetPlatform)) {
            boolean bl4 = bl2 = newPhaseType.compareTo((Enum)this.currentPhaseType) >= 0;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string2 = "The measurement for phase " + (Object)((Object)newPhaseType) + " must be performed before " + (Object)((Object)this.currentPhaseType);
                throw new AssertionError((Object)string2);
            }
        }
        this.phaseStartNanos = this.currentTime();
        this.currentPhaseType = newPhaseType;
    }

    public final void notifyPhaseFinished(@NotNull PhaseType phaseType) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
        this.ensureNotFinalized();
        boolean bl3 = bl2 = this.phaseStartNanos != null;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = "The measurement for phase " + (Object)((Object)phaseType) + " hasn't been started or already finished";
            throw new AssertionError((Object)string2);
        }
        this.finishPhase(phaseType);
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.ensureNotFinalized();
        this.isFinalized = true;
        this.notifyCurrentPhaseFinishedIfNeeded();
        this.recordGcTime();
        this.recordJitCompilationTime();
        if (!this.isK2) {
            this.recordPerfCountersMeasurements();
        }
    }

    @PotentiallyIncorrectPhaseTimeMeasurement
    public final void notifyCurrentPhaseFinishedIfNeeded() {
        if (this.phaseStartNanos != null) {
            this.finishPhase(this.currentPhaseType);
        }
    }

    private final void finishPhase(PhaseType phaseType) {
        if (phaseType != this.currentPhaseType) {
            boolean bl2;
            boolean bl3 = bl2 = !this.phaseMeasurementsMs.containsKey((Object)phaseType);
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = "The measurement for phase " + (Object)((Object)phaseType) + " is already performed";
                throw new AssertionError((Object)string2);
            }
        }
        Map map = this.phaseMeasurementsMs;
        Long l2 = (Long)this.phaseMeasurementsMs.get((Object)phaseType);
        long l3 = l2 != null ? l2 : 0L;
        long l4 = this.currentTime();
        Long l5 = this.phaseStartNanos;
        Intrinsics.checkNotNull((Object)l5);
        Long l6 = l3 + TimeUnit.NANOSECONDS.toMillis(l4 - l5);
        map.put(phaseType, l6);
        this.phaseStartNanos = null;
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GCData startCounts;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl2 = false;
            GCData gCData = startCounts = this.startGCData.get(it.getName());
            long startCollectionTime = gCData != null ? gCData.getCollectionTime() : 0L;
            GCData gCData2 = startCounts;
            long startCollectionCount = gCData2 != null ? gCData2.getCollectionCount() : 0L;
            GarbageCollectionMeasurement existingGcMeasurement = (GarbageCollectionMeasurement)this.gcMeasurements.get(it.getName());
            Map map = this.gcMeasurements;
            String string2 = it.getName();
            String string3 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            GarbageCollectionMeasurement garbageCollectionMeasurement = existingGcMeasurement;
            GarbageCollectionMeasurement garbageCollectionMeasurement2 = existingGcMeasurement;
            GarbageCollectionMeasurement garbageCollectionMeasurement3 = new GarbageCollectionMeasurement(string3, (garbageCollectionMeasurement != null ? garbageCollectionMeasurement.getMilliseconds() : 0L) + it.getCollectionTime() - startCollectionTime, (garbageCollectionMeasurement2 != null ? garbageCollectionMeasurement2.getCount() : 0L) + it.getCollectionCount() - startCollectionCount);
            map.put(string2, garbageCollectionMeasurement3);
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            return;
        }
        CompilationMXBean bean = compilationMXBean;
        this.jitMeasurement = new JitCompilationMeasurement(bean.getTotalCompilationTime());
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report((Function1<? super String, Unit>)((Function1)arg_0 -> PerformanceManager.recordPerfCountersMeasurements$lambda$11(this, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T measureTime$compiler_common(@NotNull KClass<?> measurementClass, @NotNull Function0<? extends T> block) {
        Object object;
        long elapsedMillis;
        Object object2;
        Intrinsics.checkNotNullParameter(measurementClass, (String)"measurementClass");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.isEnabled) {
            block.invoke();
        }
        this.ensureNotFinalized();
        long startTime = this.currentTime();
        try {
            object2 = block.invoke();
            elapsedMillis = TimeUnit.NANOSECONDS.toMillis(this.currentTime() - startTime);
            object = this.counterMeasurementsLock;
        }
        catch (Throwable throwable) {
            long elapsedMillis2 = TimeUnit.NANOSECONDS.toMillis(this.currentTime() - startTime);
            Object object3 = this.counterMeasurementsLock;
            synchronized (object3) {
                CounterMeasurement counterMeasurement;
                boolean bl2 = false;
                CounterMeasurement counterMeasurement2 = this.counterMeasurements.get(measurementClass);
                if (counterMeasurement2 == null) {
                    throw new IllegalStateException(("No counter measurement initialized for " + measurementClass).toString());
                }
                CounterMeasurement currentMeasurement = counterMeasurement2;
                int newCount = currentMeasurement.getCount() + 1;
                long newElapsed = currentMeasurement.getMilliseconds() + elapsedMillis2;
                KClass<?> kClass = measurementClass;
                if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class))) {
                    counterMeasurement = new FindJavaClassMeasurement(newCount, newElapsed);
                } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class))) {
                    counterMeasurement = new BinaryClassFromKotlinFileMeasurement(newCount, newElapsed);
                } else {
                    throw new IllegalStateException(("The measurement for " + measurementClass + " is not supported").toString());
                }
                CounterMeasurement newMeasurement = counterMeasurement;
                this.counterMeasurements.put(measurementClass, newMeasurement);
                Unit unit = Unit.INSTANCE;
            }
            throw throwable;
        }
        synchronized (object) {
            CounterMeasurement counterMeasurement;
            boolean bl3 = false;
            CounterMeasurement counterMeasurement3 = this.counterMeasurements.get(measurementClass);
            if (counterMeasurement3 == null) {
                throw new IllegalStateException(("No counter measurement initialized for " + measurementClass).toString());
            }
            CounterMeasurement currentMeasurement = counterMeasurement3;
            int newCount = currentMeasurement.getCount() + 1;
            long newElapsed = currentMeasurement.getMilliseconds() + elapsedMillis;
            KClass<?> kClass = measurementClass;
            if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class))) {
                counterMeasurement = new FindJavaClassMeasurement(newCount, newElapsed);
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class))) {
                counterMeasurement = new BinaryClassFromKotlinFileMeasurement(newCount, newElapsed);
            } else {
                throw new IllegalStateException(("The measurement for " + measurementClass + " is not supported").toString());
            }
            CounterMeasurement newMeasurement = counterMeasurement;
            this.counterMeasurements.put(measurementClass, newMeasurement);
            Unit unit = Unit.INSTANCE;
        }
        return (T)object2;
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        String string2 = this.createPerformanceReport();
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FilesKt.writeBytes((File)destination, (byte[])byArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createPerformanceReport() {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$createPerformanceReport_u24lambda_u2415 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        $this$createPerformanceReport_u24lambda_u2415.append(this.presentableName + " performance report\n");
        Iterable $this$map$iv = this.getMeasurements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.render(this.lines));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            $this$createPerformanceReport_u24lambda_u2415.append(it + '\n');
        }
        return stringBuilder.toString();
    }

    private final void ensureNotFinalized() {
        boolean bl2;
        boolean bl3 = bl2 = !this.isFinalized;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = "Cannot add performance measurements because it's already finalized";
            throw new AssertionError((Object)string2);
        }
    }

    private static final List measurements_delegate$lambda$4(PerformanceManager this$0) {
        List list;
        this$0.isFinalized = true;
        List $this$measurements_delegate_u24lambda_u244_u24lambda_u243 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl2 = false;
        for (Map.Entry entry : ((Map)this$0.phaseMeasurementsMs).entrySet()) {
            PhasePerformanceMeasurement phasePerformanceMeasurement;
            PhaseType phaseType = (PhaseType)((Object)entry.getKey());
            Long measurement = (Long)entry.getValue();
            PhaseType phaseType2 = phaseType;
            switch (phaseType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[phaseType2.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)measurement);
                    phasePerformanceMeasurement = new CompilerInitializationMeasurement(measurement);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)measurement);
                    phasePerformanceMeasurement = new CodeAnalysisMeasurement(measurement);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)measurement);
                    phasePerformanceMeasurement = new TranslationToIrMeasurement(measurement);
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)measurement);
                    phasePerformanceMeasurement = new IrLoweringMeasurement(measurement);
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)measurement);
                    phasePerformanceMeasurement = new BackendMeasurement(measurement);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            $this$measurements_delegate_u24lambda_u244_u24lambda_u243.add(phasePerformanceMeasurement);
        }
        $this$measurements_delegate_u24lambda_u244_u24lambda_u243.add(MapsKt.getValue(this$0.counterMeasurements, (Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class)));
        $this$measurements_delegate_u24lambda_u244_u24lambda_u243.add(MapsKt.getValue(this$0.counterMeasurements, (Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class)));
        Collection<GarbageCollectionMeasurement> collection = this$0.gcMeasurements.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GarbageCollectionMeasurement it = (GarbageCollectionMeasurement)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$measurements_delegate_u24lambda_u244_u24lambda_u243.add(it);
        }
        CollectionsKt.addIfNotNull($this$measurements_delegate_u24lambda_u244_u24lambda_u243, this$0.jitMeasurement);
        $this$measurements_delegate_u24lambda_u244_u24lambda_u243.addAll((Collection)this$0.extraMeasurements);
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    private static final Unit recordPerfCountersMeasurements$lambda$11(PerformanceManager this$0, String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        ((Collection)this$0.extraMeasurements).add(new PerformanceCounterMeasurement(s2));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/util/PerformanceManager$GCData;", "", "name", "", "collectionTime", "", "collectionCount", "<init>", "(Ljava/lang/String;JJ)V", "bean", "Ljava/lang/management/GarbageCollectorMXBean;", "(Ljava/lang/management/GarbageCollectorMXBean;)V", "getName", "()Ljava/lang/String;", "getCollectionTime", "()J", "getCollectionCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "compiler.common"})
    private static final class GCData {
        @NotNull
        private final String name;
        private final long collectionTime;
        private final long collectionCount;

        public GCData(@NotNull String name2, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.collectionTime = collectionTime;
            this.collectionCount = collectionCount;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getCollectionTime() {
            return this.collectionTime;
        }

        public final long getCollectionCount() {
            return this.collectionCount;
        }

        public GCData(@NotNull GarbageCollectorMXBean bean) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            String string2 = bean.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            this(string2, bean.getCollectionTime(), bean.getCollectionCount());
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.collectionTime;
        }

        public final long component3() {
            return this.collectionCount;
        }

        @NotNull
        public final GCData copy(@NotNull String name2, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new GCData(name2, collectionTime, collectionCount);
        }

        public static /* synthetic */ GCData copy$default(GCData gCData, String string2, long l2, long l3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = gCData.name;
            }
            if ((n2 & 2) != 0) {
                l2 = gCData.collectionTime;
            }
            if ((n2 & 4) != 0) {
                l3 = gCData.collectionCount;
            }
            return gCData.copy(string2, l2, l3);
        }

        @NotNull
        public String toString() {
            return "GCData(name=" + this.name + ", collectionTime=" + this.collectionTime + ", collectionCount=" + this.collectionCount + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.collectionTime);
            result2 = result2 * 31 + Long.hashCode(this.collectionCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCData)) {
                return false;
            }
            GCData gCData = (GCData)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)gCData.name)) {
                return false;
            }
            if (this.collectionTime != gCData.collectionTime) {
                return false;
            }
            return this.collectionCount == gCData.collectionCount;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PhaseType.values().length];
            try {
                nArray[PhaseType.Initialization.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Analysis.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.TranslationToIr.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrLowering.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Backend.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

