/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirArrayOfNullableNothingExpressionCheckerKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirArrayOfNullableNothingExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeAndTypeArguments", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkers.jvm"})
public final class FirArrayOfNullableNothingExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirArrayOfNullableNothingExpressionChecker INSTANCE = new FirArrayOfNullableNothingExpressionChecker();

    private FirArrayOfNullableNothingExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NullableNothingInReifiedPosition)) {
            return;
        }
        ConeKotlinType resolvedType = FirTypeUtilsKt.getResolvedType(expression2);
        this.checkTypeAndTypeArguments(resolvedType, expression2.getCalleeReference().getSource(), context2, reporter);
    }

    private final void checkTypeAndTypeArguments(ConeKotlinType type2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null);
        if (FirArrayOfNullableNothingExpressionCheckerKt.isArrayOfNullableNothing(fullyExpandedType2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"'Array<Nothing?>' is not supported on the JVM.", (DiagnosticContext)context2, null, 16, null);
        } else {
            for (ConeTypeProjection typeArg : fullyExpandedType2.getTypeArguments()) {
                ConeKotlinType typeArgType;
                if (ConeTypeProjectionKt.getType(typeArg) == null) continue;
                this.checkTypeAndTypeArguments(typeArgType, source, context2, reporter);
            }
        }
    }
}

