/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmIrInliner;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.MavenComparableVersion;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="ApiVersionIsAtLeastEvaluationLowering", prerequisite={JvmIrInliner.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\u00020\u001d*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lksp/org/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "apiVersion", "Lksp/org/jetbrains/kotlin/config/MavenComparableVersion;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitInlinedFunctionBlock", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "inlinedBlock", "Lksp/org/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "data", "visitFunction", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "visitCall", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "isInInlineFunInKotlinRuntime", "", "currentFunction", "isApiVersionIsAtLeast", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "Data", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nApiVersionIsAtLeastEvaluationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVersionIsAtLeastEvaluationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class ApiVersionIsAtLeastEvaluationLowering
extends IrTransformer<Data>
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final MavenComparableVersion apiVersion;

    public ApiVersionIsAtLeastEvaluationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.apiVersion = this.context.getConfig().getLanguageVersionSettings().getApiVersion().getVersion();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getEnableIrInliner()) {
            irFile.accept(this, new Data(null, false));
        }
    }

    @Override
    @NotNull
    public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return super.visitInlinedFunctionBlock(inlinedBlock, Data.copy$default(data, null, true, 1, null));
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return super.visitFunction(declaration2, Data.copy$default(data, declaration2, false, 2, null));
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!data.isInsideInlinedBlock() || !this.isApiVersionIsAtLeast(expression2.getSymbol().getOwner()) || this.isInInlineFunInKotlinRuntime(data.getCurrentFunction())) {
            Object object = super.visitCall(expression2, data);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)object;
        }
        Integer n2 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 0);
        if (n2 == null) {
            Object object = super.visitCall(expression2, data);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)object;
        }
        int epic = n2;
        Integer n3 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 1);
        if (n3 == null) {
            Object object = super.visitCall(expression2, data);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)object;
        }
        int major = n3;
        Integer n4 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 2);
        if (n4 == null) {
            Object object = super.visitCall(expression2, data);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)object;
        }
        int minor = n4;
        IrFunction currentFunction = data.getCurrentFunction();
        if (!(currentFunction != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        JvmIrBuilder builder2 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, currentFunction.getSymbol(), 0, 0, 6, null);
        MavenComparableVersion versionArgument = new MavenComparableVersion("" + epic + '.' + major + '.' + minor);
        return this.apiVersion.compareTo(versionArgument) >= 0 ? (IrExpression)ExpressionHelpersKt.irTrue(builder2) : (IrExpression)ExpressionHelpersKt.irFalse(builder2);
    }

    private final boolean isInInlineFunInKotlinRuntime(IrFunction currentFunction) {
        return currentFunction != null && currentFunction.isInline() && IrUtilsKt.getPackageFragment(currentFunction).getPackageFqName().startsWith(StandardNames.BUILT_INS_PACKAGE_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApiVersionIsAtLeast(IrFunction $this$isApiVersionIsAtLeast) {
        ArrayList<IrType> arrayList;
        if (!IrUtilsKt.isTopLevelInPackage($this$isApiVersionIsAtLeast, "apiVersionIsAtLeast", StandardNames.KOTLIN_INTERNAL_FQ_NAME)) return false;
        int n2 = 3;
        int n3 = 3;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        IrFunction irFunction = $this$isApiVersionIsAtLeast;
        ArrayList<IrType> arrayList2 = new ArrayList<IrType>(n2);
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            int n7 = n6 = n5++;
            arrayList = arrayList2;
            boolean bl4 = false;
            arrayList.add(this.context.getIrBuiltIns().getIntType());
        }
        arrayList = arrayList2;
        if (!IrUtilsKt.hasShape$default(irFunction, bl3, bl2, n4, n3, arrayList, 7, null)) return false;
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "", "currentFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "isInsideInlinedBlock", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Z)V", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.jvm.lower"})
    public static final class Data {
        @Nullable
        private final IrFunction currentFunction;
        private final boolean isInsideInlinedBlock;

        public Data(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            this.currentFunction = currentFunction;
            this.isInsideInlinedBlock = isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction getCurrentFunction() {
            return this.currentFunction;
        }

        public final boolean isInsideInlinedBlock() {
            return this.isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction component1() {
            return this.currentFunction;
        }

        public final boolean component2() {
            return this.isInsideInlinedBlock;
        }

        @NotNull
        public final Data copy(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            return new Data(currentFunction, isInsideInlinedBlock);
        }

        public static /* synthetic */ Data copy$default(Data data, IrFunction irFunction, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irFunction = data.currentFunction;
            }
            if ((n2 & 2) != 0) {
                bl2 = data.isInsideInlinedBlock;
            }
            return data.copy(irFunction, bl2);
        }

        @NotNull
        public String toString() {
            return "Data(currentFunction=" + this.currentFunction + ", isInsideInlinedBlock=" + this.isInsideInlinedBlock + ')';
        }

        public int hashCode() {
            int result2 = this.currentFunction == null ? 0 : this.currentFunction.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInsideInlinedBlock);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual((Object)this.currentFunction, (Object)data.currentFunction)) {
                return false;
            }
            return this.isInsideInlinedBlock == data.isInsideInlinedBlock;
        }
    }
}

