/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.lower.Closure;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeArgument;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeProjection;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\n*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0014\u001a\u00020\n*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\n*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "irElement", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "closureBuilders", "", "Lksp/org/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "getFunctionClosure", "Lksp/org/jetbrains/kotlin/backend/common/lower/Closure;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "getClassClosure", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "getClosure", "includeInParent", "", "builder", "closureBuilder", "getClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "collectPotentiallyCapturedTypeParameters", "parentClosureBuilder", "getParentClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilderOrNull", "getClosureBuilderOrNull", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,352:1\n1#2:353\n384#3,3:354\n387#3,4:361\n384#3,3:365\n387#3,4:370\n295#4,2:357\n1869#4,2:359\n1869#4,2:368\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n*L\n174#1:354,3\n174#1:361,4\n199#1:365,3\n199#1:370,4\n190#1:357,2\n192#1:359,2\n204#1:368,2\n*E\n"})
public final class ClosureAnnotator {
    @NotNull
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.closureBuilders = new LinkedHashMap();
        IrVisitor irVisitor = new ClosureCollectorVisitor();
        ClosureBuilder closureBuilder = this.getClosureBuilderOrNull(declaration2);
        if (closureBuilder == null) {
            closureBuilder = this.getParentClosureBuilder(declaration2);
        }
        irElement.accept(irVisitor, closureBuilder);
    }

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.getClosure(declaration2);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.getClosure(declaration2);
    }

    private final Closure getClosure(IrDeclaration declaration2) {
        ClosureBuilder closureBuilder = this.closureBuilders.get(declaration2);
        if (closureBuilder == null) {
            boolean bl2 = false;
            throw new AssertionError((Object)("No closure builder for passed declaration " + IrUtilsKt.ir2string(declaration2) + '.'));
        }
        return closureBuilder.buildClosure();
    }

    private final void includeInParent(ClosureBuilder builder2) {
        ClosureBuilder parentBuilder = this.getParentClosureBuilder(builder2.getOwner());
        if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
            parentBuilder.include(builder2);
        }
    }

    private final ClosureBuilder getClosureBuilder(IrClass $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            Object v1;
            ClosureBuilder closureBuilder2;
            block10: {
                boolean bl2 = false;
                closureBuilder2 = new ClosureBuilder($this$closureBuilder);
                this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
                closureBuilder2.declareVariable($this$closureBuilder.getThisReceiver());
                if ($this$closureBuilder.isInner()) {
                    IrValueParameter irValueParameter;
                    IrDeclarationParent parent2 = $this$closureBuilder.getParent();
                    if (parent2 instanceof IrClass) {
                        irValueParameter = ((IrClass)parent2).getThisReceiver();
                    } else if (parent2 instanceof IrScript) {
                        irValueParameter = ((IrScript)parent2).getThisReceiver();
                    } else {
                        throw new IllegalStateException(("unexpected parent " + parent2).toString());
                    }
                    IrValueParameter receiver = irValueParameter;
                    closureBuilder2.declareVariable(receiver);
                    this.includeInParent(closureBuilder2);
                }
                Iterable $this$firstOrNull$iv = $this$closureBuilder.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            IrDeclaration irDeclaration2 = v1;
            if (irDeclaration2 != null) {
                IrDeclaration it = irDeclaration2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                IrConstructor constructor = (IrConstructor)it;
                Iterable $this$forEach$iv = IrUtilsKt.getNonDispatchParameters(constructor);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter v2 = (IrValueParameter)element$iv;
                    boolean bl5 = false;
                    closureBuilder2.declareVariable(v2);
                }
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final ClosureBuilder getClosureBuilder(IrFunction $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            boolean bl2 = false;
            ClosureBuilder closureBuilder2 = new ClosureBuilder($this$closureBuilder);
            this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
            Iterable $this$forEach$iv = $this$closureBuilder.getParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl3 = false;
                closureBuilder2.declareVariable(it);
            }
            closureBuilder2.seeType($this$closureBuilder.getReturnType());
            if ($this$closureBuilder instanceof IrConstructor) {
                IrDeclarationParent irDeclarationParent = $this$closureBuilder.getParent();
                Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                IrClass constructedClass = (IrClass)irDeclarationParent;
                closureBuilder2.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder classBuilder = this.getClosureBuilder(constructedClass);
                closureBuilder2.include(classBuilder);
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final void collectPotentiallyCapturedTypeParameters(ClosureBuilder closureBuilder) {
        ClosureBuilder current = this.getParentClosureBuilder(closureBuilder.getOwner());
        while (current != null) {
            IrDeclaration container = current.getOwner();
            if (container instanceof IrTypeParametersContainer) {
                for (IrTypeParameter typeParameter : ((IrTypeParametersContainer)container).getTypeParameters()) {
                    closureBuilder.addPotentiallyCapturedTypeParameter(typeParameter);
                }
            }
            current = this.getParentClosureBuilder(container);
        }
    }

    private final ClosureBuilder getParentClosureBuilder(IrDeclaration $this$parentClosureBuilder) {
        IrDeclarationParent p = $this$parentClosureBuilder.getParent();
        return p instanceof IrClass ? this.getClosureBuilder((IrClass)p) : (p instanceof IrFunction ? this.getClosureBuilder((IrFunction)p) : (p instanceof IrDeclaration ? this.getParentClosureBuilder((IrDeclaration)((Object)p)) : null));
    }

    private final ClosureBuilder getClosureBuilderOrNull(IrDeclaration $this$closureBuilderOrNull) {
        IrDeclaration irDeclaration2 = $this$closureBuilderOrNull;
        return irDeclaration2 instanceof IrClass ? this.getClosureBuilder((IrClass)$this$closureBuilderOrNull) : (irDeclaration2 instanceof IrFunction ? this.getClosureBuilder((IrFunction)$this$closureBuilderOrNull) : null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "capturedValues", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "declaredValues", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "potentiallyCapturedTypeParameters", "Lksp/org/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "capturedTypeParameters", "closure", "Lksp/org/jetbrains/kotlin/backend/common/lower/Closure;", "buildClosure", "collectConnectedClosures", "", "updateFromIncluded", "", "include", "", "includingBuilder", "declareVariable", "valueDeclaration", "seeVariable", "value", "isExternal", "typeParameter", "addPotentiallyCapturedTypeParameter", "param", "seeType", "type", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,352:1\n1#2:353\n865#3,2:354\n865#3,2:356\n1869#3,2:358\n1869#3,2:360\n1869#3,2:362\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n*L\n112#1:354,2\n113#1:356,2\n154#1:358,2\n155#1:360,2\n158#1:362,2\n*E\n"})
    private static final class ClosureBuilder {
        @NotNull
        private final IrDeclaration owner;
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        @NotNull
        private final Set<IrValueDeclaration> declaredValues;
        @NotNull
        private final Set<ClosureBuilder> includes;
        @NotNull
        private final Set<IrTypeParameter> potentiallyCapturedTypeParameters;
        @NotNull
        private final Set<IrTypeParameter> capturedTypeParameters;
        @Nullable
        private Closure closure;

        public ClosureBuilder(@NotNull IrDeclaration owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
            this.capturedValues = new LinkedHashSet();
            this.declaredValues = new LinkedHashSet();
            this.includes = new LinkedHashSet();
            this.potentiallyCapturedTypeParameters = new LinkedHashSet();
            this.capturedTypeParameters = new LinkedHashSet();
        }

        @NotNull
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        @NotNull
        public final Closure buildClosure() {
            boolean changes;
            Closure closure = this.closure;
            if (closure != null) {
                Closure it = closure;
                boolean bl2 = false;
                return it;
            }
            List<ClosureBuilder> work = this.collectConnectedClosures();
            do {
                changes = false;
                for (ClosureBuilder c2 : work) {
                    if (!c2.updateFromIncluded()) continue;
                    changes = true;
                }
            } while (changes);
            for (ClosureBuilder c3 : work) {
                c3.closure = new Closure(CollectionsKt.toList((Iterable)c3.capturedValues), CollectionsKt.toList((Iterable)c3.capturedTypeParameters));
            }
            Closure closure2 = this.closure;
            if (closure2 == null) {
                throw new AssertionError((Object)("Closure should have been built for " + RenderIrElementKt.render$default(this.owner, null, 1, null)));
            }
            return closure2;
        }

        private final List<ClosureBuilder> collectConnectedClosures() {
            LinkedHashSet<ClosureBuilder> connected = new LinkedHashSet<ClosureBuilder>();
            connected.add(this);
            ClosureBuilder.collectConnectedClosures$collectRec(connected, this);
            return CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)connected));
        }

        private final boolean updateFromIncluded() {
            if (this.closure != null) {
                throw new AssertionError((Object)("Closure has already been built for " + RenderIrElementKt.render$default(this.owner, null, 1, null)));
            }
            int capturedValuesBefore = this.capturedValues.size();
            int capturedTypeParametersBefore = this.capturedTypeParameters.size();
            for (ClosureBuilder subClosure : this.includes) {
                Object it;
                Iterable $this$filterTo$iv;
                Iterable iterable = subClosure.capturedValues;
                Collection destination$iv = this.capturedValues;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrValueSymbol)element$iv;
                    boolean bl2 = false;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterTo$iv = subClosure.capturedTypeParameters;
                destination$iv = this.capturedTypeParameters;
                $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrTypeParameter)element$iv;
                    boolean bl3 = false;
                    if (!this.isExternal((IrTypeParameter)it)) continue;
                    destination$iv.add(element$iv);
                }
            }
            return this.capturedValues.size() != capturedValuesBefore || this.capturedTypeParameters.size() != capturedTypeParametersBefore;
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkNotNullParameter((Object)includingBuilder, (String)"includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
                this.seeType(valueDeclaration.getType());
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (this.isExternal(value2.getOwner())) {
                this.capturedValues.add(value2);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        public final boolean isExternal(@NotNull IrTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            return this.potentiallyCapturedTypeParameters.contains(typeParameter);
        }

        public final void addPotentiallyCapturedTypeParameter(@NotNull IrTypeParameter param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.potentiallyCapturedTypeParameters.add(param);
        }

        public final void seeType(@NotNull IrType type2) {
            block5: {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                if (!(type2 instanceof IrSimpleType)) {
                    return;
                }
                IrClassifierSymbol classifier = ((IrSimpleType)type2).getClassifier();
                if (classifier instanceof IrTypeParameterSymbol && this.isExternal((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()) && this.capturedTypeParameters.add((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner())) {
                    $this$forEach$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrType p0 = (IrType)element$iv;
                        boolean bl2 = false;
                        this.seeType(p0);
                    }
                }
                $this$forEach$iv = ((IrSimpleType)type2).getArguments();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl3 = false;
                    IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (irTypeProjection == null || (irTypeProjection = irTypeProjection.getType()) == null) continue;
                    IrTypeProjection p0 = irTypeProjection;
                    boolean bl4 = false;
                    this.seeType((IrType)p0);
                }
                Object object = ((IrSimpleType)type2).getAbbreviation();
                if (object == null || (object = object.getArguments()) == null) break block5;
                Iterable $this$forEach$iv2 = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl5 = false;
                    IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (irTypeProjection == null || (irTypeProjection = irTypeProjection.getType()) == null) continue;
                    IrTypeProjection p0 = irTypeProjection;
                    boolean bl6 = false;
                    this.seeType((IrType)p0);
                }
            }
        }

        private static final void collectConnectedClosures$collectRec(LinkedHashSet<ClosureBuilder> connected, ClosureBuilder current) {
            for (ClosureBuilder included : current.includes) {
                if (included.closure != null || !connected.add(included)) continue;
                ClosureBuilder.collectConnectedClosures$collectRec(connected, included);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00192\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001f2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020!2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\"\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020#2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010$\u001a\u00020\u00022\b\u0010%\u001a\u0004\u0018\u00010#2\u0006\u0010\u000b\u001a\u00020&2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010'\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lksp/org/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "visitElement", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "data", "visitClass", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "visitTypeParameter", "Lksp/org/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "visitValueAccess", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "visitVariable", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "visitFunctionAccess", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitFunctionExpression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitRichFunctionReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "visitRichPropertyReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "visitPropertyReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitExpression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "processScriptCapturing", "receiverExpression", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "processMemberAccess", "parentClosure", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1#2:353\n*E\n"})
    private final class ClosureCollectorVisitor
    extends IrVisitor<Unit, ClosureBuilder> {
        @Override
        public void visitElement(@NotNull IrElement element2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            element2.acceptChildren(this, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            declaration2.acceptChildren(this, ClosureAnnotator.this.getClosureBuilder(declaration2));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            ClosureBuilder closureBuilder = ClosureAnnotator.this.getClosureBuilder(declaration2);
            declaration2.acceptChildren(this, closureBuilder);
            ClosureAnnotator.this.includeInParent(closureBuilder);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            for (IrType superType : declaration2.getSuperTypes()) {
                ClosureBuilder closureBuilder = data;
                if (closureBuilder == null) continue;
                closureBuilder.seeType(superType);
            }
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.seeVariable(expression2.getSymbol());
            }
            super.visitValueAccess(expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.declareVariable(declaration2);
            }
            super.visitVariable(declaration2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super.visitFunctionAccess(expression2, data);
            this.processScriptCapturing(expression2.getDispatchReceiver(), ((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super.visitFunctionReference(expression2, data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super.visitFunctionExpression(expression2, data);
            this.processMemberAccess(expression2.getFunction(), data);
        }

        @Override
        public void visitRichFunctionReference(@NotNull IrRichFunctionReference expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super.visitRichFunctionReference(expression2, data);
            this.processMemberAccess(expression2.getInvokeFunction(), data);
        }

        @Override
        public void visitRichPropertyReference(@NotNull IrRichPropertyReference expression2, @Nullable ClosureBuilder data) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitRichPropertyReference(expression2, data);
                this.processMemberAccess(expression2.getGetterFunction(), data);
                IrSimpleFunction irSimpleFunction = expression2.getSetterFunction();
                if (irSimpleFunction == null) break block0;
                IrSimpleFunction it = irSimpleFunction;
                boolean bl2 = false;
                this.processMemberAccess(it, data);
            }
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable ClosureBuilder data) {
            block1: {
                IrSimpleFunctionSymbol it;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitPropertyReference(expression2, data);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
                if (irSimpleFunctionSymbol != null) {
                    it = irSimpleFunctionSymbol;
                    boolean bl2 = false;
                    this.processMemberAccess(it.getOwner(), data);
                }
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
                if (irSimpleFunctionSymbol2 == null) break block1;
                it = irSimpleFunctionSymbol2;
                boolean bl3 = false;
                this.processMemberAccess(it.getOwner(), data);
            }
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable ClosureBuilder data) {
            block3: {
                ClosureBuilder typeParameterContainerScopeBuilder;
                Object object;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2, data);
                ClosureBuilder closureBuilder = data;
                if (closureBuilder != null) {
                    ClosureBuilder closureBuilder2 = closureBuilder;
                    ClosureAnnotator closureAnnotator = ClosureAnnotator.this;
                    ClosureBuilder it = closureBuilder2;
                    boolean bl2 = false;
                    IrDeclaration irDeclaration2 = it.getOwner();
                    object = irDeclaration2 instanceof IrConstructor ? (IrConstructor)irDeclaration2 : null;
                    if (object == null || (object = closureAnnotator.getClosureBuilder((IrFunction)object)) == null) {
                        object = it;
                    }
                } else {
                    object = null;
                }
                ClosureBuilder closureBuilder3 = typeParameterContainerScopeBuilder = object;
                if (closureBuilder3 == null) break block3;
                closureBuilder3.seeType(expression2.getType());
            }
        }

        private final void processScriptCapturing(IrExpression receiverExpression, IrDeclaration declaration2, ClosureBuilder data) {
            block1: {
                IrDeclarationParent irDeclarationParent;
                IrDeclarationParent parent2;
                block2: {
                    if (receiverExpression != null) break block1;
                    parent2 = declaration2.getParent();
                    irDeclarationParent = parent2;
                    if (!(irDeclarationParent instanceof IrScript)) break block2;
                    ClosureBuilder closureBuilder = data;
                    if (closureBuilder == null) break block1;
                    IrValueParameter irValueParameter = ((IrScript)parent2).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    closureBuilder.seeVariable(irValueParameter.getSymbol());
                    break block1;
                }
                if (!(irDeclarationParent instanceof IrClass) || !Intrinsics.areEqual((Object)((IrClass)parent2).getOrigin(), (Object)IrDeclarationOrigin.Companion.getSCRIPT_CLASS()) && !Intrinsics.areEqual((Object)((IrClass)parent2).getOrigin(), (Object)IrDeclarationOrigin.Companion.getREPL_FROM_OTHER_SNIPPET())) break block1;
                ClosureBuilder closureBuilder = data;
                if (closureBuilder != null) {
                    IrValueParameter irValueParameter = ((IrClass)parent2).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    closureBuilder.seeVariable(irValueParameter.getSymbol());
                }
            }
        }

        private final void processMemberAccess(IrDeclaration declaration2, ClosureBuilder parentClosure) {
            block3: {
                ClosureBuilder builder2;
                if (!AdditionalIrUtilsKt.isLocal(declaration2)) break block3;
                if (declaration2 instanceof IrSimpleFunction && !Intrinsics.areEqual((Object)((IrSimpleFunction)declaration2).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                    return;
                }
                ClosureBuilder closureBuilder = builder2 = ClosureAnnotator.this.getClosureBuilderOrNull(declaration2);
                if (closureBuilder != null) {
                    ClosureBuilder it = closureBuilder;
                    boolean bl2 = false;
                    ClosureBuilder closureBuilder2 = parentClosure;
                    if (closureBuilder2 != null) {
                        closureBuilder2.include(builder2);
                    }
                }
            }
        }
    }
}

