/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.indexing;

import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.UserDataHolderBase;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.util.indexing.IndexedFile;
import ksp.com.intellij.util.indexing.SubstitutedFileType;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IndexedFileImpl
extends UserDataHolderBase
implements IndexedFile {
    protected final VirtualFile myFile;
    private volatile Project myProject;
    private String myFileName;
    private FileType mySubstituteFileType;
    @Nullable
    private final FileType myType;

    public IndexedFileImpl(@NotNull VirtualFile file2, Project project) {
        if (file2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(0);
        }
        this(file2, null, project);
    }

    public IndexedFileImpl(@NotNull VirtualFile file2, @Nullable FileType type2, Project project) {
        if (file2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(1);
        }
        this.myFile = file2;
        this.myProject = project;
        this.myType = type2;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        if (this.mySubstituteFileType == null) {
            this.mySubstituteFileType = SubstitutedFileType.substituteFileType(this.myFile, this.myType != null ? this.myType : this.myFile.getFileType(), this.getProject());
        }
        FileType fileType = this.mySubstituteFileType;
        if (fileType == null) {
            IndexedFileImpl.$$$reportNull$$$0(2);
        }
        return fileType;
    }

    public void setSubstituteFileType(@NotNull FileType substituteFileType) {
        if (substituteFileType == null) {
            IndexedFileImpl.$$$reportNull$$$0(3);
        }
        this.mySubstituteFileType = substituteFileType;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            IndexedFileImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getFileName() {
        if (this.myFileName == null) {
            this.myFileName = this.myFile.getName();
        }
        String string2 = this.myFileName;
        if (string2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    @Override
    public String toString() {
        return "IndexedFileImpl(" + this.getFileName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/indexing/IndexedFileImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituteFileType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/indexing/IndexedFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituteFileType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

