/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.expression.FirJsDynamicCallCheckerKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J%\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00070\u0019H\u0082\bJ \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0018\u0010\u0012\u001a\u00020\u000e*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u000e*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsDynamicCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isArrayAccessWithMultipleIndices", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirCall;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isInOperator", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "isRangeOperator", "checkSpreadOperator", "forAllSpreadArgumentsOf", "callback", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "checkIdentifier", "namedReference", "Lksp/org/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsDynamicCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsDynamicCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsDynamicCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,124:1\n100#1,13:125\n100#1,13:139\n43#2:138\n*S KotlinDebug\n*F\n+ 1 FirJsDynamicCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsDynamicCallChecker\n*L\n61#1:125,13\n92#1:139,13\n74#1:138\n*E\n"})
public final class FirJsDynamicCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsDynamicCallChecker INSTANCE = new FirJsDynamicCallChecker();

    private FirJsDynamicCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference callee = firResolvedNamedReference;
        if (!(callee.getResolvedSymbol().getOrigin() instanceof FirDeclarationOrigin.DynamicScope)) {
            this.checkSpreadOperator(expression2, context2, reporter);
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(callee, false, 1, null);
        if (firCallableSymbol == null) {
            throw new IllegalStateException("Resolved call callee without a callable symbol".toString());
        }
        FirCallableSymbol symbol = firCallableSymbol;
        if (expression2 instanceof FirCall && this.isArrayAccessWithMultipleIndices((FirCall)((Object)expression2), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCall)((Object)expression2)).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"indexed access with more than one index", (DiagnosticContext)context2, null, 16, null);
        } else if (expression2 instanceof FirFunctionCall && this.isInOperator((FirFunctionCall)expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunctionCall)expression2).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`in` operation", (DiagnosticContext)context2, null, 16, null);
        } else if (expression2 instanceof FirFunctionCall && this.isRangeOperator((FirFunctionCall)expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunctionCall)expression2).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)('`' + (String)FirJsDynamicCallCheckerKt.access$getNameToOperator$p().get(symbol.getName()) + "` operation"), (DiagnosticContext)context2, null, 16, null);
        } else if (expression2 instanceof FirComponentCall) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirComponentCall)expression2).getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`destructuring declaration", (DiagnosticContext)context2, null, 16, null);
        } else {
            this.checkIdentifier(callee, reporter, context2);
        }
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression2 instanceof FirCall ? (FirCall)((Object)expression2) : null;
        if (firCall != null) {
            FirCall call$iv = firCall;
            for (FirExpression argument$iv : call$iv.getArgumentList().getArguments()) {
                if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
                for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                    if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                    FirExpression it = it$iv;
                    boolean bl2 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getSPREAD_OPERATOR_IN_DYNAMIC_CALL(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    private final boolean isArrayAccessWithMultipleIndices(FirCall $this$isArrayAccessWithMultipleIndices, FirSession session) {
        FirReference firReference = ReferenceUtilsKt.toReference($this$isArrayAccessWithMultipleIndices, session);
        FirNamedReference firNamedReference = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (firNamedReference == null) {
            return false;
        }
        FirNamedReference callee = firNamedReference;
        KtSourceElement ktSourceElement = callee.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            return false;
        }
        FirCall $this$arguments$iv = $this$isArrayAccessWithMultipleIndices;
        boolean $i$f$getArguments = false;
        Object object = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        Object object2 = object instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)object : null;
        if (object2 == null || (object2 = ((FirVarargArgumentsExpression)object2).getArguments()) == null) {
            return false;
        }
        Object arguments2 = object2;
        return Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.GET) && arguments2.size() >= 2 || Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.SET) && arguments2.size() >= 3;
    }

    private final boolean isInOperator(FirFunctionCall $this$isInOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isInOperator.getCalleeReference());
        return Intrinsics.areEqual((Object)(firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null), (Object)OperatorNameConventions.CONTAINS) && $this$isInOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final boolean isRangeOperator(FirFunctionCall $this$isRangeOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isRangeOperator.getCalleeReference());
        Name name2 = firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null;
        return (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.RANGE_TO) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.RANGE_UNTIL)) && $this$isRangeOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final void checkSpreadOperator(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression2 instanceof FirCall ? (FirCall)((Object)expression2) : null;
        if (firCall != null) {
            FirCall call$iv = firCall;
            for (FirExpression argument$iv : call$iv.getArgumentList().getArguments()) {
                if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
                for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                    if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                    FirExpression it = it$iv;
                    boolean bl2 = false;
                    if (!(FirTypeUtilsKt.getResolvedType(it) instanceof ConeDynamicType)) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"spread operator", (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }

    private final void forAllSpreadArgumentsOf(FirQualifiedAccessExpression expression2, Function1<? super FirExpression, Unit> callback) {
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression2 instanceof FirCall ? (FirCall)((Object)expression2) : null;
        if (firCall == null) {
            return;
        }
        FirCall call2 = firCall;
        for (FirExpression argument : call2.getArgumentList().getArguments()) {
            if (!(argument instanceof FirVarargArgumentsExpression)) continue;
            for (FirExpression it : ((FirVarargArgumentsExpression)argument).getArguments()) {
                if (!(it instanceof FirSpreadArgumentExpression)) continue;
                callback.invoke((Object)it);
            }
        }
    }

    private final void checkIdentifier(FirResolvedNamedReference namedReference, DiagnosticReporter reporter, CheckerContext context2) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        String string2 = namedReference.getName().getIdentifierOrNullIfSpecial();
        if (string2 == null) {
            return;
        }
        String name2 = string2;
        if (!Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)namedReference.getSource(), FirJsErrors.INSTANCE.getNAME_CONTAINS_ILLEGAL_CHARS(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

