/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private final int myReadLimit;
    private int myBytesRead;

    public LimitedInputStream(InputStream in, int readLimit) {
        super(in);
        this.myReadLimit = readLimit;
        this.myBytesRead = 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingLimit() <= 0) {
            return -1;
        }
        int r2 = super.read();
        if (r2 >= 0) {
            ++this.myBytesRead;
        }
        return r2;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.remainingLimit() <= 0) {
            return -1;
        }
        if ((len = Math.min(len, this.remainingLimit())) <= 0) {
            return -1;
        }
        int actuallyRead = super.read(b2, off, len);
        if (actuallyRead >= 0) {
            this.myBytesRead += actuallyRead;
        }
        return actuallyRead;
    }

    @Override
    public long skip(long n2) throws IOException {
        if ((n2 = Math.min(n2, (long)this.remainingLimit())) <= 0L) {
            return 0L;
        }
        long skipped = super.skip(n2);
        this.myBytesRead = (int)((long)this.myBytesRead + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.remainingLimit());
    }

    protected int remainingLimit() {
        return this.myReadLimit - this.myBytesRead;
    }

    public int getBytesRead() {
        return this.myBytesRead;
    }

    @Override
    public synchronized void mark(int readLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

