/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.command.CommandProcessor;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    public static void executeInBulk(@NotNull Document document, boolean executeInBulk, @NotNull Runnable task) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(0);
        }
        if (task == null) {
            DocumentUtil.$$$reportNull$$$0(1);
        }
        if (executeInBulk == document.isInBulkUpdate()) {
            task.run();
            return;
        }
        document.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            document.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            document.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void executeInBulk(@NotNull Document document, @NotNull Runnable task) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(2);
        }
        if (task == null) {
            DocumentUtil.$$$reportNull$$$0(3);
        }
        DocumentUtil.executeInBulk(document, true, task);
    }

    public static void writeInRunUndoTransparentAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            DocumentUtil.$$$reportNull$$$0(4);
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(runnable));
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(5);
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(6);
        }
        CharSequence text = document.getImmutableCharSequence();
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == ' ' || c2 == '\t') continue;
            return i2;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(7);
        }
        return offset >= 0 && offset <= document.getTextLength();
    }

    public static boolean isValidLine(int line, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(8);
        }
        if (line < 0) {
            return false;
        }
        int lineCount = document.getLineCount();
        return lineCount == 0 ? line == 0 : line < lineCount;
    }

    public static int getLineStartOffset(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(9);
        }
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(10);
        }
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(11);
        }
        TextRange textRange = TextRange.create(document.getLineStartOffset(line), document.getLineEndOffset(line));
        if (textRange == null) {
            DocumentUtil.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(13);
        }
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineStartOffset(document.getLineNumber(offset));
    }

    public static boolean isAtLineEnd(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(14);
        }
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineEndOffset(document.getLineNumber(offset));
    }

    public static int alignToCodePointBoundary(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(15);
        }
        return DocumentUtil.isInsideSurrogatePair(document, offset) ? offset - 1 : offset;
    }

    public static boolean isSurrogatePair(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(16);
        }
        CharSequence text = document.getImmutableCharSequence();
        return offset >= 0 && offset + 1 < text.length() && Character.isHighSurrogate(text.charAt(offset)) && Character.isLowSurrogate(text.charAt(offset + 1));
    }

    public static boolean isInsideSurrogatePair(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(17);
        }
        return DocumentUtil.isSurrogatePair(document, offset - 1);
    }

    public static int getPreviousCodePointOffset(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(18);
        }
        return offset - (DocumentUtil.isSurrogatePair(document, offset - 2) ? 2 : 1);
    }

    public static int getNextCodePointOffset(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(19);
        }
        return offset + (DocumentUtil.isSurrogatePair(document, offset) ? 2 : 1);
    }

    public static boolean isInsideCharacterPair(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(20);
        }
        if (offset <= 0 || offset >= document.getTextLength()) {
            return false;
        }
        CharSequence text = document.getImmutableCharSequence();
        char prev = text.charAt(offset - 1);
        return prev == '\r' ? text.charAt(offset) == '\n' : Character.isHighSurrogate(prev) && Character.isLowSurrogate(text.charAt(offset));
    }

    public static boolean isLineEmpty(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(21);
        }
        CharSequence chars = document.getCharsSequence();
        int start = document.getLineStartOffset(line);
        int end = Math.min(document.getLineEndOffset(line), document.getTextLength() - 1);
        for (int i2 = start; i2 <= end; ++i2) {
            if (Character.isWhitespace(chars.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static int getIndentLengthAtLineStart(@NotNull Document document, int lineOffset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(22);
        }
        int result2 = 0;
        while (lineOffset + result2 < document.getTextLength() && Character.isWhitespace(document.getCharsSequence().charAt(lineOffset + result2))) {
            ++result2;
        }
        if (result2 + lineOffset > document.getTextLength()) {
            --result2;
        }
        return Math.max(result2, 0);
    }

    public static int getIndentLength(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(23);
        }
        return DocumentUtil.getIndentLengthAtLineStart(document, DocumentUtil.getLineStartOffset(offset, document));
    }

    public static CharSequence getIndent(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(24);
        }
        int lineOffset = DocumentUtil.getLineStartOffset(offset, document);
        return document.getCharsSequence().subSequence(lineOffset, lineOffset + DocumentUtil.getIndentLengthAtLineStart(document, lineOffset));
    }

    public static int getLineStartIndentedOffset(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(25);
        }
        int lineStartOffset = document.getLineStartOffset(line);
        return lineStartOffset + DocumentUtil.getIndentLengthAtLineStart(document, lineStartOffset);
    }

    public static int calculateOffset(@NotNull Document document, int line, int column, int tabSize) {
        int offset;
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(26);
        }
        if (0 <= line && line < document.getLineCount()) {
            int lineStart = document.getLineStartOffset(line);
            int lineEnd = document.getLineEndOffset(line);
            CharSequence docText = document.getCharsSequence();
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document.getTextLength();
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/DocumentUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/DocumentUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineTextRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeInBulk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeInRunUndoTransparentAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNonSpaceCharOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidOffset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLineStartOffset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLineEndOffset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLineTextRange";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineStart";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "alignToCodePointBoundary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogatePair";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSurrogatePair";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousCodePointOffset";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNextCodePointOffset";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInsideCharacterPair";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isLineEmpty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIndentLengthAtLineStart";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getIndentLength";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLineStartIndentedOffset";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

