/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import ksp.com.intellij.core.CoreBundle;
import ksp.com.intellij.notebook.editor.BackedVirtualFile;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.FileTypeRegistry;
import ksp.com.intellij.openapi.module.Module;
import ksp.com.intellij.openapi.module.UnloadedModuleDescription;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.roots.FileIndexFacade;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileSet;
import ksp.com.intellij.openapi.vfs.VirtualFileSetEx;
import ksp.com.intellij.openapi.vfs.VirtualFileWithId;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.search.DelegatingGlobalSearchScope;
import ksp.com.intellij.psi.search.IntersectionFileEnumeration;
import ksp.com.intellij.psi.search.LocalSearchScope;
import ksp.com.intellij.psi.search.ProjectAwareFileFilter;
import ksp.com.intellij.psi.search.ProjectScope;
import ksp.com.intellij.psi.search.PsiSearchScopeUtil;
import ksp.com.intellij.psi.search.SearchScope;
import ksp.com.intellij.psi.search.UnionFileEnumeration;
import ksp.com.intellij.psi.search.impl.VirtualFileEnumeration;
import ksp.com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    public static final GlobalSearchScope[] EMPTY_ARRAY = new GlobalSearchScope[0];
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @ApiStatus.NonExtendable
    public Project getProject() {
        return this.myProject;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            GlobalSearchScope.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(1);
        }
        return 0;
    }

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            GlobalSearchScope.$$$reportNull$$$0(2);
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(3);
        }
        return this.contains(file2);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Set<UnloadedModuleDescription> set = Collections.emptySet();
        if (set == null) {
            GlobalSearchScope.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(5);
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        return new IntersectionScope(this, scope);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(8);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope = this.intersectWith((LocalSearchScope)scope2);
            if (localSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(9);
            }
            return localSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(11);
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result2.add(element2);
        }
        return result2.isEmpty() ? LocalSearchScope.EMPTY : new LocalSearchScope(result2.toArray(PsiElement.EMPTY_ARRAY), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(12);
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = this.uniteWith((GlobalSearchScope)scope);
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.union((LocalSearchScope)scope);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        PsiElement[] localScopeElements;
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(15);
        }
        if ((localScopeElements = scope.getScope()).length == 0) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(16);
            }
            return globalSearchScope;
        }
        return new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GlobalSearchScope.this.contains(file2) || scope.isInScope(file2);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(3);
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            @NotNull
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                Collection<UnloadedModuleDescription> collection = GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
                if (collection == null) {
                    1.$$$reportNull$$$0(4);
                }
                return collection;
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string2;
                switch (n2) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 4: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedModulesBelongingToScope";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isSearchInModuleContent";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(17);
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(new GlobalSearchScope[]{this, scope});
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope union(@NotNull Collection<? extends GlobalSearchScope> scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(19);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("Empty scope collection");
        }
        if (scopes.size() == 1) {
            GlobalSearchScope globalSearchScope = scopes.iterator().next();
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(20);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes.toArray(EMPTY_ARRAY));
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope union(GlobalSearchScope @NotNull [] scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(22);
        }
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            GlobalSearchScope globalSearchScope = scopes[0];
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(23);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(24);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(25);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(26);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(27);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(28);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(29);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getEverythingScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(30);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(31);
        }
        return new NotScope(scope);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(32);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(33);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(34);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(35);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(36);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(37);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(38);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(39);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(40);
        }
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module2, true);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(41);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(42);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(43);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(44);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(45);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(46);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GlobalSearchScope.$$$reportNull$$$0(47);
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return new FileScope(psiFile.getProject(), virtualFile != null ? BackedVirtualFile.getOriginFileIfBacked(virtualFile) : null, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(48);
        }
        return GlobalSearchScope.fileScope(project, virtualFile, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable @Nls String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(49);
        }
        return new FileScope(project, virtualFile, displayName);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(50);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(51);
        }
        return GlobalSearchScope.filesScope(project, files2, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Supplier<? extends Collection<? extends VirtualFile>> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(52);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(53);
        }
        return new LazyFilesScope(project, files2);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(54);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(55);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(56);
            }
            return globalSearchScope;
        }
        return new FilesScope(project, files2, false);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(57);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(58);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(59);
            }
            return globalSearchScope;
        }
        return new FilesScope(project, files2, true);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2, final @Nullable @Nls String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(60);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(61);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(62);
            }
            return globalSearchScope;
        }
        return files2.size() == 1 ? GlobalSearchScope.fileScope(project, files2.iterator().next(), displayName) : new FilesScope(project, files2){

            @Override
            @NotNull
            public String getDisplayName() {
                String string2 = displayName == null ? super.getDisplayName() : displayName;
                if (string2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/psi/search/GlobalSearchScope$2", "getDisplayName"));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(63);
        }
        if (fileTypes == null) {
            GlobalSearchScope.$$$reportNull$$$0(64);
        }
        if (scope == EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(65);
            }
            return globalSearchScope;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 56: 
            case 59: 
            case 62: 
            case 65: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 56: 
            case 59: 
            case 62: 
            case 65: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 56: 
            case 59: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 17: 
            case 31: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope2";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 51: 
            case 53: 
            case 55: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "projectScope";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "everythingScope";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScope";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithLibrariesScope";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesScope";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleRuntimeScope";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependentsScope";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleTestsWithDependentsScope";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithoutLibrariesScope";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithLibrariesScope";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "filesScope";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 56: 
            case 59: 
            case 62: 
            case 65: {
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "allScope";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "projectScope";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "everythingScope";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "moduleScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithLibrariesScope";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesScope";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "moduleRuntimeScope";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependentsScope";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "moduleTestsWithDependentsScope";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "fileScope";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "filesScope";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "filesWithoutLibrariesScope";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "filesWithLibrariesScope";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 56: 
            case 59: 
            case 62: 
            case 65: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IntersectionScope
    extends GlobalSearchScope
    implements VirtualFileEnumerationAware {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
            if (scope1 == null) {
                IntersectionScope.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                IntersectionScope.$$$reportNull$$$0(1);
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                IntersectionScope.$$$reportNull$$$0(2);
            }
            return this.containsScope(scope) ? this : new IntersectionScope(this, scope);
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                IntersectionScope.$$$reportNull$$$0(3);
            }
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = CoreBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            if (string2 == null) {
                IntersectionScope.$$$reportNull$$$0(4);
            }
            return string2;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(5);
            }
            return this.myScope1.contains(file2) && this.myScope2.contains(file2);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                IntersectionScope.$$$reportNull$$$0(6);
            }
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(7);
            }
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if (res1 > 0 == res2 > 0) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(8);
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(9);
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection<UnloadedModuleDescription> collection = ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
            if (collection == null) {
                IntersectionScope.$$$reportNull$$$0(10);
            }
            return collection;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o2;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int calcHashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }

        @Override
        @Nullable
        public VirtualFileEnumeration extractFileEnumeration() {
            VirtualFileEnumeration fileEnumeration1 = VirtualFileEnumeration.extract(this.myScope1);
            VirtualFileEnumeration fileEnumeration2 = VirtualFileEnumeration.extract(this.myScope2);
            if (fileEnumeration1 == null) {
                return null;
            }
            if (fileEnumeration2 == null) {
                return null;
            }
            return new IntersectionFileEnumeration(Arrays.asList(fileEnumeration1, fileEnumeration2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 10: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 10: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "containsScope";
                    break;
                }
                case 4: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 10: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UnionScope
    extends GlobalSearchScope
    implements VirtualFileEnumerationAware {
        private final GlobalSearchScope @NotNull [] myScopes;

        @Override
        @Nullable
        public VirtualFileEnumeration extractFileEnumeration() {
            SmartList<VirtualFileEnumeration> fileEnumerations = new SmartList<VirtualFileEnumeration>();
            for (GlobalSearchScope scope : this.myScopes) {
                VirtualFileEnumeration fileEnumeration = VirtualFileEnumeration.extract(scope);
                if (fileEnumeration == null) {
                    return null;
                }
                fileEnumerations.add(fileEnumeration);
            }
            return new UnionFileEnumeration(fileEnumerations);
        }

        @NotNull
        static GlobalSearchScope create(GlobalSearchScope @NotNull [] scopes) {
            GlobalSearchScope unionScope;
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(0);
            }
            if (scopes.length == 2 && (unionScope = UnionScope.tryCreateUnionFor2Scopes(scopes)) != null) {
                GlobalSearchScope globalSearchScope = unionScope;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(1);
                }
                return globalSearchScope;
            }
            HashSet<GlobalSearchScope> result2 = new HashSet<GlobalSearchScope>(scopes.length);
            Project project = null;
            for (GlobalSearchScope scope : scopes) {
                if (scope == EMPTY_SCOPE) continue;
                Project scopeProject = scope.getProject();
                if (scopeProject != null) {
                    project = scopeProject;
                }
                if (scope instanceof UnionScope) {
                    ContainerUtil.addAll(result2, ((UnionScope)scope).myScopes);
                    continue;
                }
                result2.add(scope);
            }
            if (result2.isEmpty()) {
                GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }
            if (result2.size() == 1) {
                GlobalSearchScope globalSearchScope = (GlobalSearchScope)result2.iterator().next();
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(3);
                }
                return globalSearchScope;
            }
            return new UnionScope(project, result2.toArray(EMPTY_ARRAY));
        }

        @Nullable
        private static GlobalSearchScope tryCreateUnionFor2Scopes(GlobalSearchScope @NotNull [] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(4);
            }
            assert (scopes.length == 2);
            GlobalSearchScope scope0 = scopes[0];
            GlobalSearchScope scope1 = scopes[1];
            if (scope0 == EMPTY_SCOPE) {
                return scope1;
            }
            if (scope1 == EMPTY_SCOPE) {
                return scope0;
            }
            if (scope0 instanceof UnionScope && scope1 instanceof UnionScope) {
                return null;
            }
            Project project = ObjectUtils.chooseNotNull(scope0.getProject(), scope1.getProject());
            if (scope0 instanceof UnionScope) {
                return UnionScope.unionWithUnionScope(scope0, scope1, project);
            }
            if (scope1 instanceof UnionScope) {
                return UnionScope.unionWithUnionScope(scope1, scope0, project);
            }
            return new UnionScope(project, scopes);
        }

        @NotNull
        private static GlobalSearchScope unionWithUnionScope(GlobalSearchScope scope0, GlobalSearchScope scope1, Project project) {
            GlobalSearchScope[] scopes0 = ((UnionScope)scope0).myScopes;
            if (ArrayUtil.contains(scope1, scopes0)) {
                GlobalSearchScope globalSearchScope = scope0;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(5);
                }
                return globalSearchScope;
            }
            return new UnionScope(project, ArrayUtil.append(scopes0, scope1));
        }

        private UnionScope(Project project, GlobalSearchScope @NotNull [] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(6);
            }
            super(project);
            this.myScopes = scopes;
            if (scopes.length < 2) {
                throw new IllegalArgumentException("expected >= 2 scopes but got: " + Arrays.toString(scopes));
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = CoreBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
            if (string2 == null) {
                UnionScope.$$$reportNull$$$0(7);
            }
            return string2;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(8);
            }
            return ContainerUtil.find(this.myScopes, scope -> scope.contains(file2)) != null;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<UnloadedModuleDescription> result2 = new LinkedHashSet<UnloadedModuleDescription>();
            for (GlobalSearchScope scope : this.myScopes) {
                result2.addAll(scope.getUnloadedModulesBelongingToScope());
            }
            LinkedHashSet<UnloadedModuleDescription> linkedHashSet = result2;
            if (linkedHashSet == null) {
                UnionScope.$$$reportNull$$$0(9);
            }
            return linkedHashSet;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                UnionScope.$$$reportNull$$$0(10);
            }
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(11);
            }
            int[] result2 = new int[]{0};
            ContainerUtil.process(this.myScopes, scope -> {
                if (!scope.contains(file1) || !scope.contains(file2)) {
                    return true;
                }
                int cmp = scope.compare(file1, file2);
                if (result2[0] == 0) {
                    result2[0] = cmp;
                    return true;
                }
                if (cmp == 0) {
                    return true;
                }
                if (result2[0] > 0 == cmp > 0) {
                    return true;
                }
                result2[0] = 0;
                return false;
            });
            return result2[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2) {
            if (module2 == null) {
                UnionScope.$$$reportNull$$$0(12);
            }
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInModuleContent(module2)) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2, boolean testSources) {
            if (module2 == null) {
                UnionScope.$$$reportNull$$$0(13);
            }
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInModuleContent(module2, testSources)) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o2;
            return ContainerUtil.newHashSet(this.myScopes).equals(ContainerUtil.newHashSet(that.myScopes));
        }

        @Override
        public int calcHashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                UnionScope.$$$reportNull$$$0(14);
            }
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope).myScopes);
                return UnionScope.create(newScopes);
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 15: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 15: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unionWithUnionScope";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 15: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "tryCreateUnionFor2Scopes";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 15: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                NotScope.$$$reportNull$$$0(0);
            }
            super(scope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                NotScope.$$$reportNull$$$0(1);
            }
            return !this.myBaseScope.contains(file2);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public String toString() {
            return "NOT: (" + this.myBaseScope + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$NotScope";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FileScope
    extends GlobalSearchScope
    implements VirtualFileEnumeration {
        private final VirtualFile myVirtualFile;
        @Nullable
        @Nls
        private final String myDisplayName;
        private final Module myModule;

        private FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable @Nls String displayName) {
            if (project == null) {
                FileScope.$$$reportNull$$$0(0);
            }
            super(project);
            this.myVirtualFile = virtualFile;
            this.myDisplayName = displayName;
            FileIndexFacade facade = project.isDefault() ? null : FileIndexFacade.getInstance(project);
            this.myModule = virtualFile == null || facade == null ? null : facade.getModuleForFile(virtualFile);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getFilesIfCollection() {
            Set<VirtualFile> set = Collections.singleton(this.myVirtualFile);
            if (set == null) {
                FileScope.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileScope.$$$reportNull$$$0(2);
            }
            return Comparing.equal(this.myVirtualFile, file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileScope.$$$reportNull$$$0(3);
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File: " + this.myVirtualFile;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
            if (string2 == null) {
                FileScope.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || o2.getClass() != this.getClass()) {
                return false;
            }
            FileScope files2 = (FileScope)o2;
            return Objects.equals(this.myVirtualFile, files2.myVirtualFile) && Objects.equals(this.myDisplayName, files2.myDisplayName) && Objects.equals(this.myModule, files2.myModule);
        }

        @Override
        protected int calcHashCode() {
            return Objects.hash(this.myVirtualFile, this.myModule, this.myDisplayName);
        }

        @Override
        public boolean contains(int fileId) {
            return this.myVirtualFile instanceof VirtualFileWithId && ((VirtualFileWithId)((Object)this.myVirtualFile)).getId() == fileId;
        }

        @Override
        public int @NotNull [] asArray() {
            int[] nArray;
            if (this.myVirtualFile instanceof VirtualFileWithId) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = ((VirtualFileWithId)((Object)this.myVirtualFile)).getId();
            } else {
                nArray = ArrayUtil.EMPTY_INT_ARRAY;
            }
            if (nArray == null) {
                FileScope.$$$reportNull$$$0(5);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesIfCollection";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asArray";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LazyFilesScope
    extends AbstractFilesScope {
        private volatile VirtualFileSet myFiles;
        @NotNull
        private Supplier<? extends Collection<? extends VirtualFile>> myFilesSupplier;

        private LazyFilesScope(@Nullable Project project, @NotNull Supplier<? extends Collection<? extends VirtualFile>> files2) {
            if (files2 == null) {
                LazyFilesScope.$$$reportNull$$$0(0);
            }
            super(project, null);
            this.myFilesSupplier = files2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public VirtualFileSet getFiles() {
            if (this.myFiles == null) {
                LazyFilesScope lazyFilesScope = this;
                synchronized (lazyFilesScope) {
                    if (this.myFiles == null) {
                        VirtualFileSet fileSet = VfsUtilCore.createCompactVirtualFileSet(this.myFilesSupplier.get());
                        fileSet.freeze();
                        this.myFilesSupplier = null;
                        this.myFiles = fileSet;
                    }
                }
            }
            VirtualFileSet virtualFileSet = this.myFiles;
            if (virtualFileSet == null) {
                LazyFilesScope.$$$reportNull$$$0(1);
            }
            return virtualFileSet;
        }

        public String toString() {
            return "Files: [" + (this.myFiles == null ? "(not loaded yet)" : StringUtil.join(this.myFiles, ", ")) + "]; search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$LazyFilesScope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$LazyFilesScope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FilesScope
    extends AbstractFilesScope {
        private final VirtualFileSet myFiles;

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files2) {
            if (files2 == null) {
                FilesScope.$$$reportNull$$$0(0);
            }
            this(project, files2, null);
        }

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files2, @Nullable Boolean hasFilesOutOfProjectRoots) {
            if (files2 == null) {
                FilesScope.$$$reportNull$$$0(1);
            }
            super(project, hasFilesOutOfProjectRoots);
            this.myFiles = VfsUtilCore.createCompactVirtualFileSet(files2);
            this.myFiles.freeze();
        }

        @Override
        @NotNull
        public VirtualFileSet getFiles() {
            VirtualFileSet virtualFileSet = this.myFiles;
            if (virtualFileSet == null) {
                FilesScope.$$$reportNull$$$0(2);
            }
            return virtualFileSet;
        }

        public String toString() {
            return "Files: [" + StringUtil.join(this.myFiles, ", ") + "]; search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope
    implements VirtualFileEnumerationAware {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, FileType @NotNull [] fileTypes) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(0);
            }
            if (fileTypes == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(1);
            }
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(2);
            }
            if (!super.contains(file2)) {
                return false;
            }
            for (FileType otherFileType : this.myFileTypes) {
                if (!FileTypeRegistry.getInstance().isFileOfType(file2, otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(3);
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(FileType.EMPTY_ARRAY));
                }
            }
            GlobalSearchScope globalSearchScope = super.intersectWith(scope);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(5);
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    return new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                }
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o2)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o2;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int calcHashCode() {
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
            return result2;
        }

        @Override
        public String toString() {
            return "Restricted by file types: " + Arrays.asList(this.myFileTypes) + " in (" + this.myBaseScope + ")";
        }

        @Override
        @Nullable
        public VirtualFileEnumeration extractFileEnumeration() {
            return VirtualFileEnumeration.extract(this.myBaseScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                EmptyScope.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                EmptyScope.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(2);
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                EmptyScope.$$$reportNull$$$0(3);
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(4);
            }
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                EmptyScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        public String toString() {
            return "EMPTY";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AbstractFilesScope
    extends GlobalSearchScope
    implements VirtualFileEnumeration {
        volatile Boolean myHasFilesOutOfProjectRoots;

        AbstractFilesScope(@Nullable Project project, @Nullable Boolean hasFilesOutOfProjectRoots) {
            super(project);
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @Override
        @Nullable
        public Collection<VirtualFile> getFilesIfCollection() {
            return this.getFiles();
        }

        @NotNull
        abstract VirtualFileSet getFiles();

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                AbstractFilesScope.$$$reportNull$$$0(0);
            }
            return this.getFiles().contains(file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                AbstractFilesScope.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof AbstractFilesScope && this.getFiles().equals(((AbstractFilesScope)o2).getFiles());
        }

        @Override
        public int calcHashCode() {
            return this.getFiles().hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result2 = this.myHasFilesOutOfProjectRoots;
            if (result2 == null) {
                Project project = this.getProject();
                this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project != null && !project.isDefault() && ContainerUtil.find(this.getFiles(), file2 -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file2) != null) == null);
            }
            return result2;
        }

        @Override
        public boolean contains(int fileId) {
            return ((VirtualFileSetEx)this.getFiles()).containsId(fileId);
        }

        @Override
        public int @NotNull [] asArray() {
            int[] nArray = ((VirtualFileSetEx)this.getFiles()).onlyInternalFileIds();
            if (nArray == null) {
                AbstractFilesScope.$$$reportNull$$$0(2);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/GlobalSearchScope$AbstractFilesScope";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/GlobalSearchScope$AbstractFilesScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asArray";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

