/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.scope;

import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiEnumConstant;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.psi.scope.ElementClassHint;

public final class ElementClassFilter
implements ElementFilter {
    public static final ElementClassFilter PACKAGE = new ElementClassFilter(ElementClassHint.DeclarationKind.PACKAGE);
    public static final ElementClassFilter VARIABLE = new ElementClassFilter(ElementClassHint.DeclarationKind.VARIABLE);
    public static final ElementClassFilter METHOD = new ElementClassFilter(ElementClassHint.DeclarationKind.METHOD);
    public static final ElementClassFilter CLASS = new ElementClassFilter(ElementClassHint.DeclarationKind.CLASS);
    public static final ElementClassFilter FIELD = new ElementClassFilter(ElementClassHint.DeclarationKind.FIELD);
    public static final ElementClassFilter ENUM_CONST = new ElementClassFilter(ElementClassHint.DeclarationKind.ENUM_CONST);
    private final ElementClassHint.DeclarationKind myKind;

    private ElementClassFilter(ElementClassHint.DeclarationKind kind) {
        this.myKind = kind;
    }

    @Override
    public boolean isAcceptable(Object element2, PsiElement context2) {
        switch (this.myKind) {
            case CLASS: {
                return element2 instanceof PsiClass;
            }
            case ENUM_CONST: {
                return element2 instanceof PsiEnumConstant;
            }
            case FIELD: {
                return element2 instanceof PsiField;
            }
            case METHOD: {
                return element2 instanceof PsiMethod;
            }
            case PACKAGE: {
                return element2 instanceof PsiPackage;
            }
            case VARIABLE: {
                return element2 instanceof PsiVariable;
            }
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

