/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.java.parser.ExpressionParser;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiPolyadicExpression;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;

public final class ReplaceExpressionUtil {
    private static final Logger LOG = Logger.getInstance(ReplaceExpressionUtil.class);

    public static boolean isNeedParenthesis(@NotNull ASTNode oldExpr, ASTNode newExpr) {
        ASTNode oldParent;
        if (oldExpr == null) {
            ReplaceExpressionUtil.$$$reportNull$$$0(0);
        }
        if (!ElementType.EXPRESSION_BIT_SET.contains((oldParent = oldExpr.getTreeParent()).getElementType())) {
            return false;
        }
        int priority = ReplaceExpressionUtil.getExpressionPriority(newExpr);
        int parentPriority = ReplaceExpressionUtil.getExpressionPriority(oldParent);
        if (priority == -1 || parentPriority == -1) {
            return true;
        }
        if (priority > parentPriority) {
            return false;
        }
        IElementType i2 = oldParent.getElementType();
        if (i2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            return priority < parentPriority || ((CompositeElement)oldParent).getChildRole(oldExpr) == 61;
        }
        if (i2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            int role = ((CompositeElement)oldParent).getChildRole(oldExpr);
            if (role == 112) {
                return false;
            }
            return priority < parentPriority || role != 113;
        }
        if (i2 == JavaElementType.BINARY_EXPRESSION || i2 == JavaElementType.POLYADIC_EXPRESSION) {
            IElementType newType;
            if (priority < parentPriority) {
                return true;
            }
            PsiElement element2 = SourceTreeToPsiMap.treeElementToPsi(oldParent);
            assert (element2 != null);
            IElementType opType = ((PsiPolyadicExpression)element2).getOperationTokenType();
            IElementType newI = newExpr.getElementType();
            if (((CompositeElement)oldParent).getChildRole(oldExpr) == 61) {
                return false;
            }
            if (!(newI != JavaElementType.BINARY_EXPRESSION && newI != JavaElementType.POLYADIC_EXPRESSION || (newType = ((PsiPolyadicExpression)((Object)newExpr)).getOperationTokenType()) != JavaTokenType.DIV && newType != JavaTokenType.PERC)) {
                return true;
            }
            return opType != JavaTokenType.PLUS && opType != JavaTokenType.ASTERISK && opType != JavaTokenType.ANDAND && opType != JavaTokenType.OROR;
        }
        if (i2 == JavaElementType.POSTFIX_EXPRESSION) {
            return true;
        }
        if (i2 == JavaElementType.INSTANCE_OF_EXPRESSION || i2 == JavaElementType.PREFIX_EXPRESSION || i2 == JavaElementType.TYPE_CAST_EXPRESSION || i2 == JavaElementType.REFERENCE_EXPRESSION || i2 == JavaElementType.METHOD_REF_EXPRESSION) {
            return priority < parentPriority;
        }
        if (i2 == JavaElementType.ARRAY_ACCESS_EXPRESSION) {
            int role = ((CompositeElement)oldParent).getChildRole(oldExpr);
            return role != 76 && role != 89 && priority < parentPriority;
        }
        if (i2 == JavaElementType.METHOD_CALL_EXPRESSION || i2 == JavaElementType.NEW_EXPRESSION || i2 == JavaElementType.ARRAY_INITIALIZER_EXPRESSION || i2 == JavaElementType.PARENTH_EXPRESSION || i2 == JavaElementType.LITERAL_EXPRESSION || i2 == JavaElementType.THIS_EXPRESSION || i2 == JavaElementType.SUPER_EXPRESSION || i2 == JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION || i2 == JavaElementType.LAMBDA_EXPRESSION || i2 == JavaElementType.SWITCH_EXPRESSION || i2 == JavaElementType.TEMPLATE_EXPRESSION) {
            return false;
        }
        LOG.assertTrue(false);
        return false;
    }

    private static int getExpressionPriority(ASTNode expr) {
        IElementType i2 = expr.getElementType();
        if (i2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            return 0;
        }
        if (i2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            return 1;
        }
        if (i2 == JavaElementType.BINARY_EXPRESSION || i2 == JavaElementType.POLYADIC_EXPRESSION) {
            PsiElement element2 = SourceTreeToPsiMap.treeElementToPsi(expr);
            IElementType opType = ((PsiPolyadicExpression)element2).getOperationTokenType();
            if (opType == JavaTokenType.OROR) {
                return 2;
            }
            if (opType == JavaTokenType.ANDAND) {
                return 3;
            }
            if (opType == JavaTokenType.OR) {
                return 4;
            }
            if (opType == JavaTokenType.XOR) {
                return 5;
            }
            if (opType == JavaTokenType.AND) {
                return 6;
            }
            if (opType == JavaTokenType.EQEQ || opType == JavaTokenType.NE) {
                return 7;
            }
            if (opType == JavaTokenType.LT || opType == JavaTokenType.GT || opType == JavaTokenType.LE || opType == JavaTokenType.GE) {
                return 8;
            }
            if (ExpressionParser.SHIFT_OPS.contains(opType)) {
                return 9;
            }
            if (ExpressionParser.ADDITIVE_OPS.contains(opType)) {
                return 10;
            }
            if (ExpressionParser.MULTIPLICATIVE_OPS.contains(opType)) {
                return 11;
            }
            return 8;
        }
        if (i2 == JavaElementType.INSTANCE_OF_EXPRESSION) {
            return 8;
        }
        if (i2 == JavaElementType.PREFIX_EXPRESSION || i2 == JavaElementType.TYPE_CAST_EXPRESSION) {
            return 12;
        }
        if (i2 == JavaElementType.POSTFIX_EXPRESSION || i2 == JavaElementType.SWITCH_EXPRESSION) {
            return 13;
        }
        if (i2 == JavaElementType.LITERAL_EXPRESSION || i2 == JavaElementType.REFERENCE_EXPRESSION || i2 == JavaElementType.THIS_EXPRESSION || i2 == JavaElementType.SUPER_EXPRESSION || i2 == JavaElementType.PARENTH_EXPRESSION || i2 == JavaElementType.METHOD_CALL_EXPRESSION || i2 == JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION || i2 == JavaElementType.NEW_EXPRESSION || i2 == JavaElementType.ARRAY_ACCESS_EXPRESSION || i2 == JavaElementType.ARRAY_INITIALIZER_EXPRESSION || i2 == JavaElementType.JAVA_CODE_REFERENCE || i2 == JavaElementType.METHOD_REF_EXPRESSION || i2 == JavaElementType.LAMBDA_EXPRESSION || i2 == JavaElementType.EMPTY_EXPRESSION || i2 == JavaElementType.TEMPLATE_EXPRESSION) {
            return 14;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpr", "ksp/com/intellij/psi/impl/source/tree/java/ReplaceExpressionUtil", "isNeedParenthesis"));
    }
}

