/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiContinueStatement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiLabeledStatement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiStatement;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.source.PsiLabelReference;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiContinueStatementImpl
extends CompositePsiElement
implements PsiContinueStatement {
    private static final Logger LOG = Logger.getInstance(PsiContinueStatementImpl.class);

    public PsiContinueStatementImpl() {
        super(JavaElementType.CONTINUE_STATEMENT);
    }

    @Override
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findPsiChildByType(JavaTokenType.IDENTIFIER);
    }

    @Override
    public PsiStatement findContinuedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label != null) {
            PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement(this, label.getText());
            return labeled != null ? labeled.getStatement() : null;
        }
        return PsiImplUtil.findEnclosingLoop(this);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 82: {
                return this.findChildByType(JavaTokenType.CONTINUE_KEYWORD);
            }
            case 83: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 22: {
                return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiContinueStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaTokenType.CONTINUE_KEYWORD) {
            return 82;
        }
        if (i2 == JavaTokenType.IDENTIFIER) {
            return 83;
        }
        if (i2 == JavaTokenType.SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiContinueStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitContinueStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiIdentifier label = this.getLabelIdentifier();
        return label != null ? new PsiLabelReference(this, label) : null;
    }

    @Override
    public String toString() {
        return "PsiContinueStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiContinueStatementImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

