/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util.text;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.text.HtmlBuilder;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.containers.UnmodifiableHashMap;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class HtmlChunk {
    @Contract(pure=true)
    @Nullable
    public Icon findIcon(@NotNull @NonNls String id) {
        if (id == null) {
            HtmlChunk.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(1);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.singletonList(this));
    }

    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull Element element2) {
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(2);
        }
        Element element3 = element2.child(this);
        if (element3 == null) {
            HtmlChunk.$$$reportNull$$$0(3);
        }
        return element3;
    }

    @Contract(pure=true)
    @NotNull
    public Element code() {
        Element element2 = this.wrapWith("code");
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(4);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public Element bold() {
        Element element2 = this.wrapWith("b");
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(5);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public Element italic() {
        Element element2 = this.wrapWith("i");
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(6);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public Element strikethrough() {
        Element element2 = this.wrapWith("s");
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(7);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element tag(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(8);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public static Element icon(@NotNull @NonNls String id, @NotNull Icon icon) {
        if (id == null) {
            HtmlChunk.$$$reportNull$$$0(9);
        }
        if (icon == null) {
            HtmlChunk.$$$reportNull$$$0(10);
        }
        return new IconElement(id, icon);
    }

    @Contract(pure=true)
    @NotNull
    public static Element div() {
        Element element2 = Element.DIV;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(11);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element div(@NotNull @NonNls String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(12);
        }
        Element element2 = Element.DIV.style(style);
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(13);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span() {
        Element element2 = Element.SPAN;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(14);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span(@NonNls @NotNull String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(15);
        }
        Element element2 = Element.SPAN.style(style);
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(16);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element br() {
        Element element2 = Element.BR;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(17);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element li() {
        Element element2 = Element.LI;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(18);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element ul() {
        Element element2 = Element.UL;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(19);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element hr() {
        Element element2 = Element.HR;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(20);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element p() {
        Element element2 = Element.P;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(21);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element head() {
        Element element2 = Element.HEAD;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(22);
        }
        return element2;
    }

    @NotNull
    public static Element styleTag(@NonNls @NotNull String style) {
        if (style == null) {
            HtmlChunk.$$$reportNull$$$0(23);
        }
        Element element2 = HtmlChunk.tag("style").addRaw(style);
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(24);
        }
        return element2;
    }

    @NotNull
    public static Element font(@NonNls @NotNull String color) {
        if (color == null) {
            HtmlChunk.$$$reportNull$$$0(25);
        }
        Element element2 = HtmlChunk.tag("font").attr("color", color);
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(26);
        }
        return element2;
    }

    @NotNull
    public static Element font(int size) {
        Element element2 = HtmlChunk.tag("font").attr("size", String.valueOf(size));
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(27);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element body() {
        Element element2 = Element.BODY;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(28);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static Element html() {
        Element element2 = Element.HTML;
        if (element2 == null) {
            HtmlChunk.$$$reportNull$$$0(29);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp() {
        HtmlChunk htmlChunk = Nbsp.ONE;
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(30);
        }
        return htmlChunk;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        return new Nbsp(count);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk text(@NotNull @Nls String text) {
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(31);
        }
        return text.isEmpty() ? HtmlChunk.empty() : new Text(text);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk empty() {
        Empty empty = Empty.INSTANCE;
        if (empty == null) {
            HtmlChunk.$$$reportNull$$$0(32);
        }
        return empty;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static HtmlChunk template(@NotNull @Nls String template, Map.Entry<String, HtmlChunk> ... substitutions) {
        String[] parts;
        if (template == null) {
            HtmlChunk.$$$reportNull$$$0(33);
        }
        if ((parts = template.split("\\$", -1)).length % 2 != 1) {
            throw new IllegalArgumentException("Invalid template (must have even number of '$' characters): " + template);
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        Map<String, HtmlChunk> chunkMap = Stream.of(substitutions).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            if (i2 % 2 == 0) {
                builder2.append(part);
                continue;
            }
            if (part.isEmpty()) {
                builder2.append("$");
                continue;
            }
            builder2.append(Objects.requireNonNull(chunkMap.get(part), part));
        }
        HtmlChunk htmlChunk = builder2.toFragment();
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(34);
        }
        return htmlChunk;
    }

    @NotNull
    public static HtmlChunk template(@NotNull @Nls String template, @NotNull @NonNls String variable, @NotNull HtmlChunk substitution) {
        if (template == null) {
            HtmlChunk.$$$reportNull$$$0(35);
        }
        if (variable == null) {
            HtmlChunk.$$$reportNull$$$0(36);
        }
        if (substitution == null) {
            HtmlChunk.$$$reportNull$$$0(37);
        }
        return HtmlChunk.template(template, new AbstractMap.SimpleImmutableEntry<String, HtmlChunk>(variable, substitution));
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk raw(@NotNull @Nls String rawHtml) {
        if (rawHtml == null) {
            HtmlChunk.$$$reportNull$$$0(38);
        }
        return rawHtml.isEmpty() ? HtmlChunk.empty() : new Raw(rawHtml);
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull @Nls String text) {
        if (target == null) {
            HtmlChunk.$$$reportNull$$$0(39);
        }
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(40);
        }
        return HtmlChunk.link(target, HtmlChunk.text(text));
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull HtmlChunk text) {
        if (target == null) {
            HtmlChunk.$$$reportNull$$$0(41);
        }
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(42);
        }
        return new Element("a", UnmodifiableHashMap.empty().with("href", target), Collections.singletonList(text));
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk htmlEntity(@NotNull @NlsSafe String htmlEntity) {
        if (htmlEntity == null) {
            HtmlChunk.$$$reportNull$$$0(43);
        }
        if (!htmlEntity.startsWith("&") && !htmlEntity.endsWith(";")) {
            throw new IllegalArgumentException("Not an entity: " + htmlEntity);
        }
        return HtmlChunk.raw(htmlEntity);
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return false;
    }

    public abstract void appendTo(@NotNull StringBuilder var1);

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        this.appendTo(builder2);
        String string2 = builder2.toString();
        if (string2 == null) {
            HtmlChunk.$$$reportNull$$$0(44);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk fragment(HtmlChunk ... chunks) {
        if (chunks == null) {
            HtmlChunk.$$$reportNull$$$0(45);
        }
        if (chunks.length == 0) {
            return HtmlChunk.empty();
        }
        HtmlChunk htmlChunk = Arrays.stream(chunks).collect(HtmlChunk.toFragment());
        if (htmlChunk == null) {
            HtmlChunk.$$$reportNull$$$0(46);
        }
        return htmlChunk;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment() {
        Collector<HtmlChunk, HtmlBuilder, HtmlChunk> collector = Collector.of(HtmlBuilder::new, HtmlBuilder::append, HtmlBuilder::append, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
        if (collector == null) {
            HtmlChunk.$$$reportNull$$$0(47);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment(HtmlChunk separator) {
        Collector<HtmlChunk, HtmlBuilder, HtmlChunk> collector = Collector.of(HtmlBuilder::new, (hb, c2) -> {
            if (!hb.isEmpty()) {
                hb.append(separator);
            }
            hb.append((HtmlChunk)c2);
        }, (hb1, hb2) -> {
            if (!hb1.isEmpty()) {
                hb1.append(separator);
            }
            return hb1.append((HtmlBuilder)hb2);
        }, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
        if (collector == null) {
            HtmlChunk.$$$reportNull$$$0(48);
        }
        return collector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 12: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 31: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawHtml";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlEntity";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWith";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "code";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "bold";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "italic";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "strikethrough";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "span";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "br";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "li";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "ul";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "hr";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "p";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "head";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "styleTag";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "font";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "body";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "nbsp";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "template";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "fragment";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "toFragment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapWith";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "icon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "span";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "styleTag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "font";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "template";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "raw";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "link";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "htmlEntity";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fragment";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Element
    extends HtmlChunk {
        private static final Element HEAD = Element.tag("head");
        private static final Element BODY = Element.tag("body");
        private static final Element HTML = Element.tag("html");
        private static final Element BR = Element.tag("br");
        private static final Element UL = Element.tag("ul");
        private static final Element LI = Element.tag("li");
        private static final Element HR = Element.tag("hr");
        private static final Element P = Element.tag("p");
        private static final Element DIV = Element.tag("div");
        private static final Element SPAN = Element.tag("span");
        private final String myTagName;
        private final UnmodifiableHashMap<String, String> myAttributes;
        private final List<HtmlChunk> myChildren;

        private Element(String name2, UnmodifiableHashMap<String, String> attributes, List<HtmlChunk> children2) {
            this.myTagName = name2;
            this.myAttributes = attributes;
            this.myChildren = children2;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder2) {
            if (builder2 == null) {
                Element.$$$reportNull$$$0(0);
            }
            builder2.append('<').append(this.myTagName);
            this.myAttributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                builder2.append(' ').append((String)entry.getKey());
                if (entry.getValue() != null) {
                    builder2.append("=\"").append(StringUtil.escapeXmlEntities((String)entry.getValue())).append('\"');
                }
            });
            if (this.myChildren.isEmpty()) {
                builder2.append("/>");
            } else {
                builder2.append(">");
                for (HtmlChunk child : this.myChildren) {
                    child.appendTo(builder2);
                }
                builder2.append("</").append(this.myTagName).append(">");
            }
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name2, @NotNull String value2) {
            if (value2 == null) {
                Element.$$$reportNull$$$0(1);
            }
            return new Element(this.myTagName, this.myAttributes.with(name2, value2), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name2, int value2) {
            return new Element(this.myTagName, this.myAttributes.with(name2, Integer.toString(value2)), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name2) {
            return new Element(this.myTagName, this.myAttributes.with(name2, null), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element style(@NonNls String style) {
            Element element2 = this.attr("style", style);
            if (element2 == null) {
                Element.$$$reportNull$$$0(2);
            }
            return element2;
        }

        @Contract(pure=true)
        @NotNull
        public Element setClass(@NonNls String className) {
            Element element2 = this.attr("class", className);
            if (element2 == null) {
                Element.$$$reportNull$$$0(3);
            }
            return element2;
        }

        @Contract(pure=true)
        @NotNull
        public Element addText(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(4);
            }
            Element element2 = this.child(Element.text(text));
            if (element2 == null) {
                Element.$$$reportNull$$$0(5);
            }
            return element2;
        }

        @Contract(pure=true)
        @NotNull
        public Element addRaw(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(6);
            }
            Element element2 = this.child(Element.raw(text));
            if (element2 == null) {
                Element.$$$reportNull$$$0(7);
            }
            return element2;
        }

        @Contract(pure=true)
        @NotNull
        public Element children(HtmlChunk ... chunks) {
            if (chunks == null) {
                Element.$$$reportNull$$$0(8);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Arrays.asList(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.length);
            newChildren.addAll(this.myChildren);
            Collections.addAll(newChildren, chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element children(@NotNull List<? extends HtmlChunk> chunks) {
            if (chunks == null) {
                Element.$$$reportNull$$$0(9);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, new ArrayList<HtmlChunk>(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.size());
            newChildren.addAll(this.myChildren);
            newChildren.addAll(chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element child(@NotNull HtmlChunk chunk) {
            if (chunk == null) {
                Element.$$$reportNull$$$0(10);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Collections.singletonList(chunk));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + 1);
            newChildren.addAll(this.myChildren);
            newChildren.add(chunk);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Override
        @Nullable
        public Icon findIcon(@NotNull String id) {
            if (id == null) {
                Element.$$$reportNull$$$0(11);
            }
            for (HtmlChunk child : this.myChildren) {
                Icon icon = child.findIcon(id);
                if (icon == null) continue;
                return icon;
            }
            return null;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Element element2 = (Element)o2;
            return Objects.equals(this.myTagName, element2.myTagName) && Objects.equals(this.myAttributes, element2.myAttributes) && Objects.equals(this.myChildren, element2.myChildren);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.myTagName);
            result2 = 31 * result2 + Objects.hashCode(this.myAttributes);
            result2 = 31 * result2 + Objects.hashCode(this.myChildren);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "style";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addRaw";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "attr";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addRaw";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "child";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findIcon";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class IconElement
    extends Element {
        @NotNull
        private final String myId;
        @NotNull
        private final Icon myIcon;

        private IconElement(@NotNull String id, @NotNull Icon icon) {
            if (id == null) {
                IconElement.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                IconElement.$$$reportNull$$$0(1);
            }
            super("icon", UnmodifiableHashMap.empty().with("src", id), Collections.emptyList());
            this.myId = id;
            this.myIcon = icon;
        }

        @Override
        @Nullable
        public Icon findIcon(@NotNull String id) {
            if (id == null) {
                IconElement.$$$reportNull$$$0(2);
            }
            if (id.equals(this.myId)) {
                return this.myIcon;
            }
            return null;
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            if (!super.equals(o2)) {
                return false;
            }
            IconElement element2 = (IconElement)o2;
            return this.myId.equals(element2.myId) && this.myIcon.equals(element2.myIcon);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.myId.hashCode();
            result2 = 31 * result2 + this.myIcon.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/openapi/util/text/HtmlChunk$IconElement";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Nbsp
    extends HtmlChunk {
        private static final HtmlChunk ONE = new Nbsp(1);
        private final int myCount;

        private Nbsp(int count) {
            this.myCount = count;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder2) {
            if (builder2 == null) {
                Nbsp.$$$reportNull$$$0(0);
            }
            builder2.append(StringUtil.repeat("&nbsp;", this.myCount));
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Nbsp && this.myCount == ((Nbsp)o2).myCount;
        }

        public int hashCode() {
            return this.myCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/openapi/util/text/HtmlChunk$Nbsp", "appendTo"));
        }
    }

    private static final class Text
    extends HtmlChunk {
        private final String myContent;

        private Text(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder2) {
            if (builder2 == null) {
                Text.$$$reportNull$$$0(0);
            }
            builder2.append(StringUtil.escapeXmlEntities(this.myContent).replaceAll("\n", "<br/>"));
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Text && Objects.equals(this.myContent, ((Text)o2).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/openapi/util/text/HtmlChunk$Text", "appendTo"));
        }
    }

    private static final class Empty
    extends HtmlChunk {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder2) {
            if (builder2 == null) {
                Empty.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/openapi/util/text/HtmlChunk$Empty", "appendTo"));
        }
    }

    private static final class Raw
    extends HtmlChunk {
        private final String myContent;

        private Raw(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder2) {
            if (builder2 == null) {
                Raw.$$$reportNull$$$0(0);
            }
            builder2.append(this.myContent);
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Raw && Objects.equals(this.myContent, ((Raw)o2).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/openapi/util/text/HtmlChunk$Raw", "appendTo"));
        }
    }

    static final class Fragment
    extends HtmlChunk {
        private final List<? extends HtmlChunk> myContent;

        Fragment(List<? extends HtmlChunk> content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder2) {
            if (builder2 == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            for (HtmlChunk htmlChunk : this.myContent) {
                htmlChunk.appendTo(builder2);
            }
        }

        @Override
        @Nullable
        public Icon findIcon(@NotNull String id) {
            if (id == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            for (HtmlChunk htmlChunk : this.myContent) {
                Icon icon = htmlChunk.findIcon(id);
                if (icon == null) continue;
                return icon;
            }
            return null;
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Fragment && Objects.equals(this.myContent, ((Fragment)o2).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/openapi/util/text/HtmlChunk$Fragment";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

