/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import ksp.one.util.streamex.ConstSpliterator;
import ksp.one.util.streamex.Internals;
import ksp.one.util.streamex.StreamContext;

abstract class TreeSpliterator<T, U>
extends Internals.CloneableSpliterator<U, TreeSpliterator<T, U>>
implements Consumer<T>,
AutoCloseable,
Runnable {
    private static final int MAX_RECURSION_DEPTH = Integer.getInteger("ksp.one.util.streamex.tree.recursiondepth", 128);
    T cur;
    List<Internals.PairBox<Spliterator<T>, Stream<T>>> spliterators;
    private Runnable closeHandler = null;
    long size = Long.MAX_VALUE;

    TreeSpliterator(T root) {
        this.cur = root;
    }

    boolean advance() {
        List<Internals.PairBox<Spliterator<T>, Stream<T>>> spltrs = this.spliterators;
        if (spltrs == null) {
            this.spliterators = new ArrayList<Internals.PairBox<Spliterator<T>, Stream<T>>>();
            return true;
        }
        for (int lastIdx = spltrs.size() - 1; lastIdx >= 0; --lastIdx) {
            Internals.PairBox<Spliterator<T>, Stream<T>> pair = spltrs.get(lastIdx);
            Spliterator spltr = (Spliterator)pair.a;
            if (spltr.tryAdvance(this)) {
                return true;
            }
            if (pair.b != null) {
                ((Stream)pair.b).close();
            }
            spltrs.remove(lastIdx);
        }
        return false;
    }

    boolean append(Stream<T> stream) {
        if (stream != null) {
            this.spliterators.add(new Internals.PairBox(stream.spliterator(), stream));
        }
        return true;
    }

    abstract Stream<T> getStart();

    abstract U getStartElement();

    @Override
    public Spliterator<U> trySplit() {
        if (this.spliterators == null) {
            this.spliterators = new ArrayList<Internals.PairBox<Spliterator<T>, Stream<T>>>();
            Stream<T> stream = this.getStart();
            if (stream != null) {
                this.spliterators.add(new Internals.PairBox(((Stream)stream.parallel()).spliterator(), null));
                this.closeHandler = stream::close;
            }
            return new ConstSpliterator.OfRef<U>(this.getStartElement(), 1L, true);
        }
        int size = this.spliterators.size();
        if (size != 1) {
            return null;
        }
        Spliterator prefix = ((Spliterator)this.spliterators.get((int)0).a).trySplit();
        if (prefix == null) {
            return null;
        }
        TreeSpliterator clone = (TreeSpliterator)this.doClone();
        clone.size /= 2L;
        this.size -= clone.size;
        clone.spliterators = new ArrayList<Internals.PairBox<Spliterator<T>, Stream<T>>>();
        clone.spliterators.add(new Internals.PairBox(prefix, null));
        this.closeHandler = StreamContext.compose(this.closeHandler, clone);
        return clone;
    }

    @Override
    public long estimateSize() {
        return this.size;
    }

    @Override
    public int characteristics() {
        return 16;
    }

    @Override
    public void accept(T t2) {
        this.cur = t2;
    }

    @Override
    public void run() {
        this.close();
    }

    @Override
    public void close() {
        if (this.spliterators != null) {
            Throwable t2 = null;
            for (int i = this.spliterators.size() - 1; i >= 0; --i) {
                try {
                    Stream stream = (Stream)this.spliterators.get((int)i).b;
                    if (stream == null) continue;
                    stream.close();
                    continue;
                }
                catch (Error | RuntimeException e) {
                    if (t2 == null) {
                        t2 = e;
                        continue;
                    }
                    t2.addSuppressed(e);
                }
            }
            if (this.closeHandler != null) {
                try {
                    this.closeHandler.run();
                }
                catch (Error | RuntimeException e) {
                    if (t2 == null) {
                        t2 = e;
                    }
                    t2.addSuppressed(e);
                }
            }
            if (t2 instanceof RuntimeException) {
                throw (RuntimeException)t2;
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
        }
    }

    static class Depth<T>
    extends TreeSpliterator<T, Map.Entry<Integer, T>> {
        private final BiFunction<Integer, T, Stream<T>> mapper;
        private final int initialDepth;

        Depth(T root, BiFunction<Integer, T, Stream<T>> mapper, int depth) {
            super(root);
            this.mapper = mapper;
            this.initialDepth = depth;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<Integer, T>> action) {
            if (!this.advance()) {
                return false;
            }
            Object e = this.cur;
            int depth = this.initialDepth + this.spliterators.size();
            action.accept(new Internals.ObjIntBox<Object>(e, depth));
            return this.append(this.mapper.apply(depth, (Integer)e));
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<Integer, T>> action) {
            DepthAcceptor<Object> acceptor = new DepthAcceptor<Object>(action, this.mapper, this.initialDepth);
            if (this.spliterators != null) {
                for (int i = this.spliterators.size() - 1; i >= 0; --i) {
                    Internals.PairBox pair = (Internals.PairBox)this.spliterators.get(i);
                    ((DepthAcceptor)acceptor).depth = i + 1;
                    ((Spliterator)pair.a).forEachRemaining(acceptor);
                    if (pair.b == null) continue;
                    ((Stream)pair.b).close();
                }
            } else {
                this.spliterators = Collections.emptyList();
                acceptor.accept(this.cur);
            }
        }

        @Override
        Stream<T> getStart() {
            return this.mapper.apply(0, (Integer)this.cur);
        }

        @Override
        Map.Entry<Integer, T> getStartElement() {
            return new Internals.ObjIntBox<Object>(this.cur, 0);
        }
    }

    static class DepthAcceptor<T>
    implements Consumer<T> {
        private final Consumer<? super Map.Entry<Integer, T>> action;
        private final BiFunction<Integer, T, Stream<T>> mapper;
        private Integer depth;

        public DepthAcceptor(Consumer<? super Map.Entry<Integer, T>> action, BiFunction<Integer, T, Stream<T>> mapper, Integer depth) {
            this.action = action;
            this.mapper = mapper;
            this.depth = depth;
        }

        @Override
        public void accept(T t2) {
            if (this.depth > MAX_RECURSION_DEPTH) {
                try (Depth<? super Map.Entry<Integer, T>> spliterator = new Depth<Map.Entry<Integer, T>>(t2, this.mapper, this.depth);){
                    while (spliterator.tryAdvance(this.action)) {
                    }
                }
                return;
            }
            this.action.accept(new AbstractMap.SimpleImmutableEntry<Integer, T>(this.depth, t2));
            try (Stream<T> stream = this.mapper.apply(this.depth, (Integer)t2);){
                if (stream != null) {
                    Integer n = this.depth;
                    Integer n2 = this.depth = Integer.valueOf(this.depth + 1);
                    stream.spliterator().forEachRemaining(this);
                    n = this.depth;
                    n2 = this.depth = Integer.valueOf(this.depth - 1);
                }
            }
        }
    }

    static class Plain<T>
    extends TreeSpliterator<T, T> {
        private final Function<T, Stream<T>> mapper;

        Plain(T root, Function<T, Stream<T>> mapper) {
            super(root);
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.advance()) {
                return false;
            }
            Object e = this.cur;
            action.accept(e);
            return this.append(this.mapper.apply(e));
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Acceptor<Object> acceptor = new Acceptor<Object>(action, this.mapper);
            if (this.spliterators != null) {
                for (int i = this.spliterators.size() - 1; i >= 0; --i) {
                    Internals.PairBox pair = (Internals.PairBox)this.spliterators.get(i);
                    ((Spliterator)pair.a).forEachRemaining(acceptor);
                    if (pair.b == null) continue;
                    ((Stream)pair.b).close();
                }
            } else {
                this.spliterators = Collections.emptyList();
                acceptor.accept(this.cur);
            }
        }

        @Override
        Stream<T> getStart() {
            return this.mapper.apply(this.cur);
        }

        @Override
        T getStartElement() {
            return (T)this.cur;
        }
    }

    static class Acceptor<T>
    implements Consumer<T> {
        private final Consumer<? super T> action;
        private final Function<T, Stream<T>> mapper;
        private int depth;

        public Acceptor(Consumer<? super T> action, Function<T, Stream<T>> mapper) {
            this.action = action;
            this.mapper = mapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T t2) {
            if (this.depth > MAX_RECURSION_DEPTH) {
                try (Plain<? super T> spliterator = new Plain<T>(t2, this.mapper);){
                    while (spliterator.tryAdvance(this.action)) {
                    }
                }
                return;
            }
            this.action.accept(t2);
            ++this.depth;
            try (Stream<T> stream = this.mapper.apply(t2);){
                if (stream != null) {
                    stream.spliterator().forEachRemaining(this);
                }
            }
            finally {
                --this.depth;
            }
        }
    }
}

