/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.java.lexer;

import java.io.IOException;
import ksp.com.intellij.lang.java.lexer._JavaLexer;
import ksp.com.intellij.lexer.LexerBase;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.TokenType;
import ksp.com.intellij.psi.impl.source.AbstractBasicJavaDocElementTypeFactory;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.util.text.CharArrayUtil;
import ksp.it.unimi.dsi.fastutil.ints.IntArrayList;
import ksp.it.unimi.dsi.fastutil.ints.IntStack;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class BasicJavaLexer
extends LexerBase {
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_TEXT_BLOCK_TEMPLATE = 1;
    private final _JavaLexer myFlexLexer;
    private final IntStack myStateStack;
    private CharSequence myBuffer;
    private char @Nullable [] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private IElementType myTokenType;
    private int mySymbolLength;
    private final AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer myJavaDocElementTypeContainer;

    public BasicJavaLexer(@NotNull LanguageLevel level, @NotNull AbstractBasicJavaDocElementTypeFactory javaDocElementTypeFactory) {
        if (level == null) {
            BasicJavaLexer.$$$reportNull$$$0(0);
        }
        if (javaDocElementTypeFactory == null) {
            BasicJavaLexer.$$$reportNull$$$0(1);
        }
        this.myStateStack = new IntArrayList(1);
        this.mySymbolLength = 1;
        this.myFlexLexer = new _JavaLexer(level);
        this.myJavaDocElementTypeContainer = javaDocElementTypeFactory.getContainer();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BasicJavaLexer.$$$reportNull$$$0(2);
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.mySymbolLength = 1;
        this.myStateStack.push(initialState);
        this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    @Override
    public int getState() {
        return this.myStateStack.topInt();
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        this.locateToken();
        return this.myBufferIndex;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEndOffset;
    }

    @Override
    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.locateCharAt(this.myBufferIndex);
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + this.mySymbolLength);
                break;
            }
            case '{': {
                int count1 = this.myStateStack.topInt() >> 16;
                if (count1 > 0) {
                    this.myStateStack.push(this.myStateStack.popInt() & 1 | count1 + 1 << 16);
                }
                this.myTokenType = JavaTokenType.LBRACE;
                this.myTokenEndOffset = this.myBufferIndex + this.mySymbolLength;
                break;
            }
            case '}': {
                int count2 = this.myStateStack.topInt() >> 16;
                if (count2 > 0) {
                    if (count2 != 1) {
                        this.myStateStack.push(this.myStateStack.popInt() & 1 | count2 - 1 << 16);
                    } else {
                        int state = this.myStateStack.popInt();
                        if (this.myStateStack.isEmpty()) {
                            this.myStateStack.push(0);
                        }
                        if ((state & 1) != 0) {
                            boolean fragment = this.locateLiteralEnd(this.myBufferIndex + this.mySymbolLength, LiteralType.TEXT_BLOCK);
                            this.myTokenType = fragment ? JavaTokenType.TEXT_BLOCK_TEMPLATE_MID : JavaTokenType.TEXT_BLOCK_TEMPLATE_END;
                            break;
                        }
                        boolean fragment = this.locateLiteralEnd(this.myBufferIndex + this.mySymbolLength, LiteralType.STRING);
                        this.myTokenType = fragment ? JavaTokenType.STRING_TEMPLATE_MID : JavaTokenType.STRING_TEMPLATE_END;
                        break;
                    }
                }
                this.myTokenType = JavaTokenType.RBRACE;
                this.myTokenEndOffset = this.myBufferIndex + this.mySymbolLength;
                break;
            }
            case '/': {
                if (this.myBufferIndex + this.mySymbolLength >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                int l1 = this.mySymbolLength;
                char nextChar = this.locateCharAt(this.myBufferIndex + l1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + l1 + this.mySymbolLength);
                    break;
                }
                if (nextChar == '*') {
                    int l2 = this.mySymbolLength;
                    if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '*') {
                        int l3 = this.mySymbolLength;
                        if (this.myBufferIndex + l1 + l2 + l3 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2 + l3) == '/') {
                            this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                            this.myTokenEndOffset = this.myBufferIndex + l1 + l2 + l3 + this.mySymbolLength;
                            break;
                        }
                        this.myTokenType = this.myJavaDocElementTypeContainer.DOC_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + l1 + l2 + l3);
                        break;
                    }
                    this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                    this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + l1 + l2 + this.mySymbolLength);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '#': {
                if (this.myBufferIndex == 0 && this.mySymbolLength == 1 && this.myBufferEndOffset > 1 && this.charAt(1) == '!' && this.mySymbolLength == 1) {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(2);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\'': {
                this.myTokenType = JavaTokenType.CHARACTER_LITERAL;
                this.locateLiteralEnd(this.myBufferIndex + this.mySymbolLength, LiteralType.CHAR);
                break;
            }
            case '\"': {
                int l1 = this.mySymbolLength;
                if (this.myBufferIndex + l1 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1) == '\"') {
                    int l2 = this.mySymbolLength;
                    if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '\"') {
                        boolean fragment = this.locateLiteralEnd(this.myBufferIndex + l1 + l2 + this.mySymbolLength, LiteralType.TEXT_BLOCK);
                        this.myTokenType = fragment ? JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN : JavaTokenType.TEXT_BLOCK_LITERAL;
                        break;
                    }
                    this.myTokenType = JavaTokenType.STRING_LITERAL;
                    this.myTokenEndOffset = this.myBufferIndex + l1 + l2;
                    break;
                }
                boolean fragment = this.locateLiteralEnd(this.myBufferIndex + l1, LiteralType.STRING);
                this.myTokenType = fragment ? JavaTokenType.STRING_TEMPLATE_BEGIN : JavaTokenType.STRING_LITERAL;
                break;
            }
            default: {
                this.flexLocateToken();
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int offset) {
        char c;
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset && ((c = this.locateCharAt(pos)) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f'); pos += this.mySymbolLength) {
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexLexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexLexer.advance();
            this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean locateLiteralEnd(int offset, LiteralType literalType) {
        int pos = offset;
        while (pos < this.myBufferEndOffset) {
            char c = this.locateCharAt(pos);
            if (c == '\\') {
                if ((pos += this.mySymbolLength) < this.myBufferEndOffset && this.locateCharAt(pos) == '{' && literalType != LiteralType.CHAR) {
                    this.myTokenEndOffset = pos += this.mySymbolLength;
                    if (this.myStateStack.topInt() == 0) {
                        this.myStateStack.popInt();
                    }
                    if (literalType == LiteralType.TEXT_BLOCK) {
                        this.myStateStack.push(65537);
                    } else {
                        this.myStateStack.push(65536);
                    }
                    return true;
                }
            } else {
                if (c == literalType.c) {
                    if (literalType == LiteralType.TEXT_BLOCK) {
                        if ((pos += this.mySymbolLength) >= this.myBufferEndOffset || this.locateCharAt(pos) != '\"' || (pos += this.mySymbolLength) >= this.myBufferEndOffset || this.locateCharAt(pos) != '\"') continue;
                        this.myTokenEndOffset = pos + this.mySymbolLength;
                        return false;
                    }
                    this.myTokenEndOffset = pos + this.mySymbolLength;
                    return false;
                }
                if ((c == '\n' || c == '\r') && this.mySymbolLength == 1 && literalType != LiteralType.TEXT_BLOCK) {
                    this.myTokenEndOffset = pos;
                    return false;
                }
            }
            pos += this.mySymbolLength;
        }
        this.myTokenEndOffset = pos;
        return false;
    }

    private int getClosingComment(int offset) {
        char c;
        int pos = offset;
        while (pos < this.myBufferEndOffset && ((c = this.locateCharAt(pos)) != '*' || (pos += this.mySymbolLength) >= this.myBufferEndOffset || this.locateCharAt(pos) != '/')) {
        }
        return pos + this.mySymbolLength;
    }

    private int getLineTerminator(int offset) {
        char c;
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset && (c = this.locateCharAt(pos)) != '\r' && c != '\n'; pos += this.mySymbolLength) {
        }
        return pos;
    }

    private char charAt(int offset) {
        return this.myBufferArray != null ? this.myBufferArray[offset] : this.myBuffer.charAt(offset);
    }

    private char locateCharAt(int offset) {
        this.mySymbolLength = 1;
        char first = this.charAt(offset);
        if (first != '\\') {
            return first;
        }
        int pos = offset + 1;
        if (pos < this.myBufferEndOffset && this.charAt(pos) == '\\') {
            return first;
        }
        boolean escaped = true;
        int i = offset;
        while (--i >= 0 && this.charAt(i) == '\\') {
            escaped = !escaped;
        }
        if (!escaped) {
            return first;
        }
        if (pos < this.myBufferEndOffset && this.charAt(pos) != 'u') {
            return first;
        }
        while (++pos < this.myBufferEndOffset && this.charAt(pos) == 'u') {
        }
        if (pos + 3 >= this.myBufferEndOffset) {
            return first;
        }
        int result2 = 0;
        int max = pos + 4;
        while (pos < max) {
            result2 <<= 4;
            char c = this.charAt(pos);
            if ('0' <= c && c <= '9') {
                result2 += c - 48;
            } else if ('a' <= c && c <= 'f') {
                result2 += c - 97 + 10;
            } else if ('A' <= c && c <= 'F') {
                result2 += c - 65 + 10;
            } else {
                return first;
            }
            ++pos;
        }
        this.mySymbolLength = pos - offset;
        return (char)result2;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            BasicJavaLexer.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocElementTypeFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/java/lexer/BasicJavaLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/java/lexer/BasicJavaLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static enum LiteralType {
        STRING('\"'),
        CHAR('\''),
        TEXT_BLOCK('\"');

        final char c;

        private LiteralType(char c) {
            this.c = c;
        }
    }
}

