/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertyAccessorSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirSyntheticPropertyWithoutJavaOriginChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirSyntheticPropertyWithoutJavaOriginChecker
extends FirExpressionChecker<FirPropertyAccessExpression> {
    @NotNull
    public static final FirSyntheticPropertyWithoutJavaOriginChecker INSTANCE = new FirSyntheticPropertyWithoutJavaOriginChecker();

    private FirSyntheticPropertyWithoutJavaOriginChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirPropertyAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirNamedFunctionSymbol firNamedFunctionSymbol;
        FirVariableAssignment containingAssignment;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidSyntheticPropertiesWithoutBaseJavaGetter)) {
            return;
        }
        Object object = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
        FirSimpleSyntheticPropertySymbol firSimpleSyntheticPropertySymbol = object instanceof FirSimpleSyntheticPropertySymbol ? (FirSimpleSyntheticPropertySymbol)object : null;
        if (firSimpleSyntheticPropertySymbol == null) {
            return;
        }
        FirSimpleSyntheticPropertySymbol syntheticProperty = firSimpleSyntheticPropertySymbol;
        object = CollectionsKt.getOrNull(context2.getCallsOrAssignments(), (int)(context2.getCallsOrAssignments().size() - 2));
        FirVariableAssignment firVariableAssignment = containingAssignment = object instanceof FirVariableAssignment ? (FirVariableAssignment)object : null;
        boolean isAssignment = (firVariableAssignment != null ? firVariableAssignment.getLValue() : null) == expression2;
        boolean bl = isAssignment;
        if (!bl) {
            FirSyntheticPropertyAccessorSymbol firSyntheticPropertyAccessorSymbol = syntheticProperty.getGetterSymbol();
            firNamedFunctionSymbol = firSyntheticPropertyAccessorSymbol != null ? firSyntheticPropertyAccessorSymbol.getDelegateFunctionSymbol() : null;
        } else if (bl) {
            FirSyntheticPropertyAccessorSymbol firSyntheticPropertyAccessorSymbol = syntheticProperty.getSetterSymbol();
            firNamedFunctionSymbol = firSyntheticPropertyAccessorSymbol != null ? firSyntheticPropertyAccessorSymbol.getDelegateFunctionSymbol() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol originalFunction = firNamedFunctionSymbol;
        if (SyntheticsKt.getNoJavaOrigin(syntheticProperty)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getSYNTHETIC_PROPERTY_WITHOUT_JAVA_ORIGIN(), (Object)originalFunction, (Object)originalFunction.getName(), (DiagnosticContext)context2, null, 32, null);
        }
    }
}

