/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import ksp.com.intellij.BundleBase;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.com.intellij.util.DefaultBundleService;
import ksp.com.intellij.util.lang.UrlClassLoader;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private Reference<ResourceBundle> myBundle;
    private Reference<ResourceBundle> myDefaultBundle;
    @NotNull
    private final ClassLoader myBundleClassLoader;
    @NonNls
    private final String myPathToBundle;

    public AbstractBundle(@NotNull Class<?> bundleClass, @NonNls @NotNull String pathToBundle) {
        if (bundleClass == null) {
            AbstractBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(1);
        }
        this.myPathToBundle = pathToBundle;
        this.myBundleClassLoader = bundleClass.getClassLoader();
    }

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(2);
        }
        this.myPathToBundle = pathToBundle;
        this.myBundleClassLoader = this.getClass().getClassLoader();
    }

    @ApiStatus.Internal
    @NotNull
    protected final ClassLoader getBundleClassLoader() {
        ClassLoader classLoader = this.myBundleClassLoader;
        if (classLoader == null) {
            AbstractBundle.$$$reportNull$$$0(3);
        }
        return classLoader;
    }

    @ApiStatus.Internal
    @NotNull
    public static ResourceBundle.Control getControl() {
        MyResourceControl myResourceControl = MyResourceControl.INSTANCE;
        if (myResourceControl == null) {
            AbstractBundle.$$$reportNull$$$0(4);
        }
        return myResourceControl;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getMessage(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(5);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(6);
        }
        String string2 = BundleBase.messageOrDefault(this.getResourceBundle(), key, null, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getPartialMessage(@NotNull @NonNls String key, int unassignedParams, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(8);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(9);
        }
        String string2 = BundleBase.partialMessage(this.getResourceBundle(), key, unassignedParams, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(10);
        }
        return string2;
    }

    public @NotNull Supplier<@Nls String> getLazyMessage(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(11);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(12);
        }
        Object[] actualParams = params.length == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : params;
        Supplier<String> supplier = () -> this.getMessage(key, actualParams);
        if (supplier == null) {
            AbstractBundle.$$$reportNull$$$0(13);
        }
        return supplier;
    }

    @Nullable
    @Nls
    public String messageOrNull(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(14);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(15);
        }
        return AbstractBundle.messageOrNull(this.getResourceBundle(), key, params);
    }

    @Nls
    public String messageOrDefault(@NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(16);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(17);
        }
        return AbstractBundle.messageOrDefault(this.getResourceBundle(), key, defaultValue, params);
    }

    @Contract(value="null, _, _, _ -> param3")
    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(18);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(19);
        }
        if (bundle == null) {
            return defaultValue;
        }
        if (!bundle.containsKey(key)) {
            return BundleBase.postprocessValue(bundle, BundleBase.useDefaultValue(bundle, key, defaultValue), params);
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(20);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(21);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(22);
        }
        String string2 = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(23);
        }
        return string2;
    }

    @Nullable
    @Nls
    public static String messageOrNull(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        String value2;
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(24);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(25);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(26);
        }
        return key.equals(value2 = AbstractBundle.messageOrDefault(bundle, key, key, params)) ? null : value2;
    }

    public boolean containsKey(@NotNull @NonNls String key) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(27);
        }
        return this.getResourceBundle().containsKey(key);
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.myBundleClassLoader);
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader) {
        boolean isDefault;
        ResourceBundle bundle;
        if (classLoader == null) {
            AbstractBundle.$$$reportNull$$$0(28);
        }
        if ((bundle = SoftReference.dereference((isDefault = DefaultBundleService.isDefaultBundle()) ? this.myDefaultBundle : this.myBundle)) == null) {
            bundle = this.resolveResourceBundle(this.myPathToBundle, classLoader);
            java.lang.ref.SoftReference<ResourceBundle> ref = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.myDefaultBundle = ref;
            } else {
                this.myBundle = ref;
            }
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(29);
        }
        return resourceBundle;
    }

    @NotNull
    private ResourceBundle resolveResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(30);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(31);
        }
        return AbstractBundle.resolveResourceBundleWithFallback(() -> this.findBundle(pathToBundle, loader, MyResourceControl.INSTANCE), loader, pathToBundle);
    }

    @ApiStatus.Internal
    @NotNull
    protected static ResourceBundle resolveResourceBundleWithFallback(@NotNull @NotNull Supplier<? extends @NotNull ResourceBundle> firstTry, @NotNull ClassLoader loader, @NotNull String pathToBundle) {
        ResourceBundle resourceBundle;
        if (firstTry == null) {
            AbstractBundle.$$$reportNull$$$0(32);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(33);
        }
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(34);
        }
        try {
            resourceBundle = firstTry.get();
        }
        catch (MissingResourceException e) {
            LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
            ResourceBundle.clearCache(loader);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            if (resourceBundle2 == null) {
                AbstractBundle.$$$reportNull$$$0(36);
            }
            return resourceBundle2;
        }
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(35);
        }
        return resourceBundle;
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(37);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(38);
        }
        if (control == null) {
            AbstractBundle.$$$reportNull$$$0(39);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(40);
        }
        return resourceBundle;
    }

    public void clearLocaleCache() {
        if (this.myBundle != null) {
            this.myBundle.clear();
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected static ResourceBundle resolveBundle(@NotNull ClassLoader loader, @NonNls @NotNull String pathToBundle) {
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(41);
        }
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(42);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, MyResourceControl.INSTANCE);
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(43);
        }
        return resourceBundle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 34: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/AbstractBundle";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 31: 
            case 33: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTry";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/AbstractBundle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleClassLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyMessage";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundleWithFallback";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findBundle";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPartialMessage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLazyMessage";
                break;
            }
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "messageOrNull";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundleWithFallback";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 43: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyResourceControl
    extends ResourceBundle.Control {
        static final MyResourceControl INSTANCE = new MyResourceControl();

        private MyResourceControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String resourceName;
            String bundleName = this.toBundleName(baseName, locale);
            String string2 = resourceName = bundleName.contains("://") ? null : this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return null;
            }
            if (loader instanceof UrlClassLoader) {
                byte[] data = ((UrlClassLoader)loader).getResourceAsBytes(resourceName, true);
                if (data == null) {
                    return null;
                }
                return new PropertyResourceBundle(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
            }
            InputStream stream = loader.getResourceAsStream(resourceName);
            if (stream == null) {
                return null;
            }
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                return propertyResourceBundle;
            }
            finally {
                stream.close();
            }
        }
    }
}

