/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.github.benmanes.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import ksp.com.github.benmanes.caffeine.cache.Caffeine;
import ksp.com.github.benmanes.caffeine.cache.Node;
import ksp.com.github.benmanes.caffeine.cache.References;
import ksp.com.github.benmanes.caffeine.cache.Weigher;

interface NodeFactory<K, V> {
    public static final Object RETIRED_STRONG_KEY = new Object();
    public static final Object DEAD_STRONG_KEY = new Object();
    public static final References.WeakKeyReference<Object> RETIRED_WEAK_KEY = new References.WeakKeyReference<Object>(null, null);
    public static final References.WeakKeyReference<Object> DEAD_WEAK_KEY = new References.WeakKeyReference<Object>(null, null);

    public Node<K, V> newNode(K var1, ReferenceQueue<K> var2, V var3, ReferenceQueue<V> var4, int var5, long var6);

    public Node<K, V> newNode(Object var1, V var2, ReferenceQueue<V> var3, int var4, long var5);

    default public Object newReferenceKey(K key, ReferenceQueue<K> referenceQueue) {
        return key;
    }

    default public Object newLookupKey(Object key) {
        return key;
    }

    public static <K, V> NodeFactory<K, V> newFactory(Caffeine<K, V> builder2, boolean isAsync) {
        StringBuilder sb = new StringBuilder("ksp.com.github.benmanes.caffeine.cache.");
        if (builder2.isStrongKeys()) {
            sb.append('P');
        } else {
            sb.append('F');
        }
        if (builder2.isStrongValues()) {
            sb.append('S');
        } else if (builder2.isWeakValues()) {
            sb.append('W');
        } else {
            sb.append('D');
        }
        if (builder2.expiresVariable()) {
            if (builder2.refreshAfterWrite()) {
                sb.append('A');
                if (builder2.evicts()) {
                    sb.append('W');
                }
            } else {
                sb.append('W');
            }
        } else {
            if (builder2.expiresAfterAccess()) {
                sb.append('A');
            }
            if (builder2.expiresAfterWrite()) {
                sb.append('W');
            }
        }
        if (builder2.refreshAfterWrite()) {
            sb.append('R');
        }
        if (builder2.evicts()) {
            sb.append('M');
            if (isAsync || builder2.isWeighted() && builder2.weigher != Weigher.singletonWeigher()) {
                sb.append('W');
            } else {
                sb.append('S');
            }
        }
        try {
            Class<?> clazz = Class.forName(sb.toString());
            NodeFactory factory2 = (NodeFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return factory2;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(sb.toString(), e);
        }
    }

    default public boolean weakValues() {
        return false;
    }

    default public boolean softValues() {
        return false;
    }
}

