/*
 * Decompiled with CFR 0.152.
 */
package ksp.kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.kotlinx.serialization.DeserializationStrategy;
import ksp.kotlinx.serialization.PolymorphicSerializerKt;
import ksp.kotlinx.serialization.SealedClassSerializer;
import ksp.kotlinx.serialization.SerializationException;
import ksp.kotlinx.serialization.SerializationStrategy;
import ksp.kotlinx.serialization.descriptors.PolymorphicKind;
import ksp.kotlinx.serialization.descriptors.PrimitiveKind;
import ksp.kotlinx.serialization.descriptors.SerialDescriptor;
import ksp.kotlinx.serialization.descriptors.SerialKind;
import ksp.kotlinx.serialization.descriptors.StructureKind;
import ksp.kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import ksp.kotlinx.serialization.internal.JsonInternalDependenciesKt;
import ksp.kotlinx.serialization.json.ClassDiscriminatorMode;
import ksp.kotlinx.serialization.json.Json;
import ksp.kotlinx.serialization.json.JsonClassDiscriminator;
import ksp.kotlinx.serialization.json.JsonDecoder;
import ksp.kotlinx.serialization.json.JsonElement;
import ksp.kotlinx.serialization.json.JsonElementKt;
import ksp.kotlinx.serialization.json.JsonEncoder;
import ksp.kotlinx.serialization.json.JsonObject;
import ksp.kotlinx.serialization.json.JsonPrimitive;
import ksp.kotlinx.serialization.json.internal.JsonExceptionsKt;
import ksp.kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a(\u0010\u0004\u001a\u00020\u00012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a%\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0000\u00a2\u0006\u0002\u0010\u0012\u001aE\u0010\u0013\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000e*\u00020\u00142\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00062\u0006\u0010\u0015\u001a\u0002H\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0017H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"checkKind", "", "kind", "Lksp/kotlinx/serialization/descriptors/SerialKind;", "validateIfSealed", "serializer", "Lksp/kotlinx/serialization/SerializationStrategy;", "actualSerializer", "classDiscriminator", "", "Lksp/kotlinx/serialization/descriptors/SerialDescriptor;", "json", "Lksp/kotlinx/serialization/json/Json;", "decodeSerializableValuePolymorphic", "T", "Lksp/kotlinx/serialization/json/JsonDecoder;", "deserializer", "Lksp/kotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Lksp/kotlinx/serialization/json/JsonEncoder;", "value", "ifPolymorphic", "Lkotlin/Function1;", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nPolymorphic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,103:1\n1#2:104\n252#3,7:105\n*S KotlinDebug\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n*L\n81#1:105,7\n*E\n"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value2, @NotNull Function1<? super String, Unit> ifPolymorphic) {
        SerializationStrategy<T> actualSerializer;
        SerializationStrategy<T> serializationStrategy;
        String baseClassDiscriminator;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$encodePolymorphically, (String)"<this>");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, (String)"ifPolymorphic");
        boolean $i$f$encodePolymorphically = false;
        if ($this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer2.serialize($this$encodePolymorphically, value2);
            return;
        }
        boolean isPolymorphicSerializer = serializer2 instanceof AbstractPolymorphicSerializer;
        if (isPolymorphicSerializer) {
            bl2 = $this$encodePolymorphically.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$encodePolymorphically.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                case 1: 
                case 2: {
                    bl2 = false;
                    break;
                }
                case 3: {
                    SerialKind it = serializer2.getDescriptor().getKind();
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)StructureKind.OBJECT.INSTANCE)) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean needDiscriminator = bl2;
        String string2 = baseClassDiscriminator = needDiscriminator ? PolymorphicKt.classDiscriminator(serializer2.getDescriptor(), $this$encodePolymorphically.getJson()) : null;
        if (isPolymorphicSerializer) {
            AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer2;
            if (value2 == null) {
                boolean $i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$22 = false;
                String $i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$22 = "Value for serializer " + serializer2.getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                throw new IllegalArgumentException($i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$22.toString());
            }
            SerializationStrategy<T> actual = PolymorphicSerializerKt.findPolymorphicSerializer(casted, $this$encodePolymorphically, value2);
            if (baseClassDiscriminator != null) {
                PolymorphicKt.validateIfSealed(serializer2, actual, baseClassDiscriminator);
            }
            PolymorphicKt.checkKind(actual.getDescriptor().getKind());
            Intrinsics.checkNotNull(actual, (String)"null cannot be cast to non-null type kotlinx.serialization.SerializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.encodePolymorphically>");
            serializationStrategy = actual;
        } else {
            serializationStrategy = actualSerializer = serializer2;
        }
        if (baseClassDiscriminator != null) {
            ifPolymorphic.invoke((Object)baseClassDiscriminator);
        }
        actualSerializer.serialize($this$encodePolymorphically, value2);
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer2, SerializationStrategy<?> actualSerializer, String classDiscriminator) {
        if (!(serializer2 instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer2.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (kind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<? extends T> deserializer) {
        DeserializationStrategy deserializationStrategy;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeSerializableValuePolymorphic, (String)"<this>");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), $this$decodeSerializableValuePolymorphic.getJson());
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast = false;
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        String type2 = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        try {
            deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer, $this$decodeSerializableValuePolymorphic, type2);
        }
        catch (SerializationException it) {
            String string2 = it.getMessage();
            Intrinsics.checkNotNull((Object)string2);
            throw JsonExceptionsKt.JsonDecodingException(-1, string2, jsonTree.toString());
        }
        DeserializationStrategy deserializationStrategy2 = deserializationStrategy;
        Intrinsics.checkNotNull(deserializationStrategy2, (String)"null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.decodeSerializableValuePolymorphic>");
        DeserializationStrategy actualSerializer = deserializationStrategy2;
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, actualSerializer);
    }

    @NotNull
    public static final String classDiscriminator(@NotNull SerialDescriptor $this$classDiscriminator, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)$this$classDiscriminator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        for (Annotation annotation : $this$classDiscriminator.getAnnotations()) {
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)annotation).discriminator();
        }
        return json.getConfiguration().getClassDiscriminator();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassDiscriminatorMode.values().length];
            try {
                nArray[ClassDiscriminatorMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassDiscriminatorMode.POLYMORPHIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassDiscriminatorMode.ALL_JSON_OBJECTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

