/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/ReifiedTypeParameterAnnotationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkTypeParameterDescriptorsAreNotReified", "typeParameterDescriptors", "", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
@SourceDebugExtension(value={"SMAP\nReifiedTypeParameterAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReifiedTypeParameterAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ReifiedTypeParameterAnnotationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n774#2:61\n865#2,2:62\n*S KotlinDebug\n*F\n+ 1 ReifiedTypeParameterAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ReifiedTypeParameterAnnotationChecker\n*L\n48#1:61\n48#1:62,2\n*E\n"})
public final class ReifiedTypeParameterAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (descriptor2 instanceof CallableDescriptor && !InlineUtil.isInline(descriptor2) && !InlineUtil.isPropertyWithAllAccessorsAreInline(descriptor2)) {
            List<TypeParameterDescriptor> list = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
            this.checkTypeParameterDescriptorsAreNotReified(list, context2.getTrace());
        }
        if (descriptor2 instanceof ClassDescriptor) {
            List<TypeParameterDescriptor> list = ((ClassDescriptor)descriptor2).getDeclaredTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclaredTypeParameters(...)");
            this.checkTypeParameterDescriptorsAreNotReified(list, context2.getTrace());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameterDescriptorsAreNotReified(List<? extends TypeParameterDescriptor> typeParameterDescriptors2, DiagnosticSink diagnosticHolder) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = typeParameterDescriptors2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TypeParameterDescriptor reifiedTypeParameterDescriptor : (List)destination$iv$iv) {
            PsiElement typeParameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(reifiedTypeParameterDescriptor);
            if (!(typeParameterDeclaration instanceof KtTypeParameter)) {
                throw new AssertionError((Object)"KtTypeParameter expected");
            }
            KtModifierList ktModifierList = ((KtTypeParameter)typeParameterDeclaration).getModifierList();
            Intrinsics.checkNotNull((Object)ktModifierList);
            PsiElement psiElement = ktModifierList.getModifier(KtTokens.REIFIED_KEYWORD);
            Intrinsics.checkNotNull((Object)psiElement);
            diagnosticHolder.report(Errors.REIFIED_TYPE_PARAMETER_NO_INLINE.on(psiElement));
        }
    }
}

