/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.load.java;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.ide.highlighter.JavaClassFileType;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.FileTypeRegistry;
import ksp.com.intellij.openapi.fileTypes.UnknownFileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.search.DelegatingGlobalSearchScope;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.javax.inject.Inject;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.JvmTarget;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.idea.KotlinFileType;
import ksp.org.jetbrains.kotlin.load.java.JavaClassFinder;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmCodeAnalyzerInitializer;
import ksp.org.jetbrains.kotlin.resolve.jvm.TopPackageNamesProvider;
import ksp.org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "Lksp/org/jetbrains/kotlin/load/java/JavaClassFinder;", "<init>", "()V", "project", "Lksp/com/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "javaSearchScope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "getJavaSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "setJavaSearchScope", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "setScope", "", "scope", "setProjectInstance", "initialize", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "codeAnalyzer", "Lksp/org/jetbrains/kotlin/resolve/lazy/KotlinCodeAnalyzer;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "jvmTarget", "Lksp/org/jetbrains/kotlin/config/JvmTarget;", "FilterOutKotlinSourceFilesScope", "frontend.java"})
public abstract class AbstractJavaClassFinder
implements JavaClassFinder {
    protected Project project;
    protected GlobalSearchScope javaSearchScope;

    @NotNull
    protected final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    protected final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    protected final GlobalSearchScope getJavaSearchScope() {
        GlobalSearchScope globalSearchScope = this.javaSearchScope;
        if (globalSearchScope != null) {
            return globalSearchScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"javaSearchScope");
        return null;
    }

    protected final void setJavaSearchScope(@NotNull GlobalSearchScope globalSearchScope) {
        Intrinsics.checkNotNullParameter((Object)globalSearchScope, (String)"<set-?>");
        this.javaSearchScope = globalSearchScope;
    }

    @Inject
    public final void setScope(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.setJavaSearchScope(Intrinsics.areEqual((Object)scope, (Object)GlobalSearchScope.EMPTY_SCOPE) ? GlobalSearchScope.EMPTY_SCOPE : (GlobalSearchScope)new FilterOutKotlinSourceFilesScope(scope));
    }

    @Inject
    public void setProjectInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setProject(project);
    }

    public void initialize(@NotNull BindingTrace trace, @NotNull KotlinCodeAnalyzer codeAnalyzer, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JvmTarget jvmTarget) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)codeAnalyzer, (String)"codeAnalyzer");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
            CodeAnalyzerInitializer codeAnalyzerInitializer = CodeAnalyzerInitializer.Companion.getInstance(this.getProject());
            JvmCodeAnalyzerInitializer jvmCodeAnalyzerInitializer = codeAnalyzerInitializer instanceof JvmCodeAnalyzerInitializer ? (JvmCodeAnalyzerInitializer)codeAnalyzerInitializer : null;
            if (jvmCodeAnalyzerInitializer == null) break block0;
            ModuleDescriptor moduleDescriptor = codeAnalyzer.getModuleDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"getModuleDescriptor(...)");
            jvmCodeAnalyzerInitializer.initialize(trace, moduleDescriptor, codeAnalyzer, languageVersionSettings, jvmTarget);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/load/java/AbstractJavaClassFinder$FilterOutKotlinSourceFilesScope;", "Lksp/com/intellij/psi/search/DelegatingGlobalSearchScope;", "Lksp/org/jetbrains/kotlin/resolve/jvm/TopPackageNamesProvider;", "baseScope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;Lcom/intellij/psi/search/GlobalSearchScope;)V", "topPackageNames", "", "", "getTopPackageNames", "()Ljava/util/Set;", "contains", "", "file", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "base", "getBase", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getProject", "Lksp/com/intellij/openapi/project/Project;", "toString", "frontend.java"})
    public final class FilterOutKotlinSourceFilesScope
    extends DelegatingGlobalSearchScope
    implements TopPackageNamesProvider {
        @NotNull
        private final GlobalSearchScope base;

        public FilterOutKotlinSourceFilesScope(GlobalSearchScope baseScope) {
            Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
            super(baseScope);
            GlobalSearchScope globalSearchScope = this.myBaseScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myBaseScope");
            this.base = globalSearchScope;
        }

        @Override
        @Nullable
        public Set<String> getTopPackageNames() {
            GlobalSearchScope globalSearchScope = this.myBaseScope;
            TopPackageNamesProvider topPackageNamesProvider = globalSearchScope instanceof TopPackageNamesProvider ? (TopPackageNamesProvider)((Object)globalSearchScope) : null;
            return topPackageNamesProvider != null ? topPackageNamesProvider.getTopPackageNames() : null;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String extension = file2.getExtension();
            if (file2.isDirectory()) {
                bl = false;
            } else if (Intrinsics.areEqual((Object)extension, (Object)"kt")) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)extension, (Object)"java") || Intrinsics.areEqual((Object)extension, (Object)JavaClassFileType.INSTANCE.getDefaultExtension())) {
                bl = false;
            } else {
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getName());
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
                FileType fileTypeByFileName = fileType;
                bl = Intrinsics.areEqual((Object)fileTypeByFileName, (Object)KotlinFileType.INSTANCE) || Intrinsics.areEqual((Object)fileTypeByFileName, (Object)UnknownFileType.INSTANCE) && FileTypeRegistry.getInstance().isFileOfType(file2, KotlinFileType.INSTANCE);
            }
            boolean ktFile = bl;
            return !ktFile && this.myBaseScope.contains(file2);
        }

        @NotNull
        public final GlobalSearchScope getBase() {
            return this.base;
        }

        @Override
        @NotNull
        public Project getProject() {
            return AbstractJavaClassFinder.this.getProject();
        }

        @Override
        @NotNull
        public String toString() {
            return "JCFI: " + this.myBaseScope;
        }
    }
}

