/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.backend.ast;

import java.util.ArrayList;
import java.util.List;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsContext;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import ksp.org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import ksp.org.jetbrains.kotlin.js.util.AstUtil;

public class JsSwitch
extends SourceInfoAwareJsNode
implements JsStatement {
    private final List<JsSwitchMember> cases;
    private JsExpression expression;

    public JsSwitch() {
        this.cases = new ArrayList<JsSwitchMember>();
    }

    public JsSwitch(JsExpression expression2, List<JsSwitchMember> cases) {
        this.expression = expression2;
        this.cases = cases;
    }

    public List<JsSwitchMember> getCases() {
        return this.cases;
    }

    public JsExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JsExpression expression2) {
        this.expression = expression2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visit(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.expression);
        visitor2.acceptWithInsertRemove(this.cases);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.expression = v.accept(this.expression);
            v.acceptList(this.cases);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsSwitch deepCopy() {
        JsExpression expressionCopy = AstUtil.deepCopy(this.expression);
        List<JsSwitchMember> casesCopy = AstUtil.deepCopy(this.cases);
        JsSwitch jsSwitch = (JsSwitch)new JsSwitch(expressionCopy, casesCopy).withMetadataFrom(this);
        if (jsSwitch == null) {
            JsSwitch.$$$reportNull$$$0(0);
        }
        return jsSwitch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/org/jetbrains/kotlin/js/backend/ast/JsSwitch", "deepCopy"));
    }
}

