/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.PropertyReferenceDelegationLowering;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@PhaseDescription(name="MakePropertyDelegateMethodsStatic", prerequisite={PropertyReferenceDelegationLowering.class, JvmLocalDeclarationsLowering.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitSimpleFunction", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "isSyntheticDelegateMethod", "", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nMakePropertyDelegateMethodsStaticLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakePropertyDelegateMethodsStaticLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1557#2:73\n1628#2,3:74\n*S KotlinDebug\n*F\n+ 1 MakePropertyDelegateMethodsStaticLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering\n*L\n51#1:73\n51#1:74,3\n*E\n"})
public final class MakePropertyDelegateMethodsStaticLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public MakePropertyDelegateMethodsStaticLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transform((IrElementTransformer)this, (Object)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this.isSyntheticDelegateMethod(declaration2)) {
            return super.visitSimpleFunction(declaration2);
        }
        IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            return super.visitSimpleFunction(declaration2);
        }
        IrValueParameter oldParameter = irValueParameter;
        IrValueParameter newParameter = IrUtilsKt.copyTo$default(oldParameter, declaration2, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null);
        IrSimpleFunction $this$visitSimpleFunction_u24lambda_u241 = irSimpleFunction = declaration2;
        boolean bl = false;
        Iterable iterable = $this$visitSimpleFunction_u24lambda_u241.getValueParameters();
        Collection collection2 = CollectionsKt.listOf((Object)newParameter);
        IrSimpleFunction irSimpleFunction2 = $this$visitSimpleFunction_u24lambda_u241;
        boolean $i$f$map = false;
        void var11_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it, $this$visitSimpleFunction_u24lambda_u241, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null));
        }
        collection = (List)destination$iv$iv;
        irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        $this$visitSimpleFunction_u24lambda_u241.setDispatchReceiverParameter(null);
        IrBody irBody = $this$visitSimpleFunction_u24lambda_u241.getBody();
        $this$visitSimpleFunction_u24lambda_u241.setBody((IrBody)(irBody != null ? irBody.transform((IrElementTransformer)new VariableRemapper(MapsKt.mapOf((Pair)TuplesKt.to((Object)oldParameter, (Object)newParameter))), (Object)null) : null));
        return irSimpleFunction;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isSyntheticDelegateMethod((IrSimpleFunction)expression2.getSymbol().getOwner())) {
            throw new IllegalStateException(("`$delegate` method should not be called. Please either remove the call, or support remapping of dispatch receiver in MakePropertyDelegateMethodsStaticLowering: " + RenderIrElementKt.render$default(expression2.getSymbol().getOwner(), null, 1, null)).toString());
        }
        return super.visitCall(expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticDelegateMethod(IrSimpleFunction $this$isSyntheticDelegateMethod) {
        if (!Intrinsics.areEqual((Object)$this$isSyntheticDelegateMethod.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_DELEGATE())) return false;
        String string2 = $this$isSyntheticDelegateMethod.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)"$delegate", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

