/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import ksp.org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import ksp.org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import ksp.org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import ksp.org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import ksp.org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtFileAnnotationList;
import ksp.org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import ksp.org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import ksp.org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import ksp.org.jetbrains.kotlin.psi.KtValueArgument;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\tH\u0007J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001bJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lksp/org/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "<init>", "()V", "JVM_NAME", "Lksp/org/jetbrains/kotlin/name/FqName;", "getJVM_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_NAME_SHORT", "", "getJVM_NAME_SHORT", "()Ljava/lang/String;", "getPartFqNameForDeserialized", "descriptor", "Lksp/org/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "getFileClassInternalName", "file", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "getFacadeClassInternalName", "manglePartName", "facadeName", "fileName", "getFileClassInfoNoResolve", "Lksp/org/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "parseJvmNameOnFileNoResolve", "Lksp/org/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "findAnnotationEntryOnFileNoResolve", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "shortName", "getLiteralStringFromAnnotation", "annotation", "getLiteralStringEntryFromAnnotation", "Lksp/org/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "frontend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmFileClassUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFileClassUtil.kt\norg/jetbrains/kotlin/fileClasses/JvmFileClassUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1#2:135\n295#3,2:136\n*S KotlinDebug\n*F\n+ 1 JvmFileClassUtil.kt\norg/jetbrains/kotlin/fileClasses/JvmFileClassUtil\n*L\n80#1:136,2\n*E\n"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();
    @NotNull
    private static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    @NotNull
    private static final String JVM_NAME_SHORT;

    private JvmFileClassUtil() {
    }

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Object object = UtilKt.getImplClassNameForDeserialized(descriptor2);
        if (object == null || (object = ((JvmClassName)object).getFqNameForTopLevelClassMaybeWithDollars()) == null) {
            throw new IllegalStateException(("No implClassName for " + descriptor2).toString());
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String getFacadeClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String manglePartName(@NotNull String facadeName, @NotNull String fileName2) {
        Intrinsics.checkNotNullParameter((Object)facadeName, (String)"facadeName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName2);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file2) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file2.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string2 = parsedAnnotations.getJvmName();
            if (string2 == null) {
                String string3 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                string2 = PackagePartClassUtils.getFilePartShortName(string3);
            }
            String simpleName2 = string2;
            Name name2 = Name.identifier(simpleName2);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            FqName facadeClassFqName = ((FqName)packageFqName).child(name2);
            if (parsedAnnotations.isMultifileClass()) {
                String string4 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                Name name3 = Name.identifier(JvmFileClassUtil.manglePartName(simpleName2, string4));
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(((FqName)packageFqName).child(name3), facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            String string5 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, string5), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     */
    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_NAME_SHORT);
        v0 = jvmNameAnnotation;
        if (v0 == null) ** GOTO lbl-1000
        p0 = v0;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
        v0 = v1;
        if (v1 != null) {
            p0 = var5_6 = v0;
            $i$a$-takeIf-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 = Name.isValidIdentifier((String)p0) ? var5_6 : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = jvmName = null;
        }
        if ((v3 = (jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmStandardClassIds.INSTANCE.getJVM_PACKAGE_NAME_SHORT()))) == null) ** GOTO lbl-1000
        p0 = v3;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
        v3 = v4;
        if (v4 != null) {
            p0 = v3;
            $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = JvmFileClassUtilKt.isJvmMultifileClassFile(file);
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file2, @NotNull String shortName2) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)shortName2, (String)"shortName");
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtExpression ktExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null), (Object)shortName2)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    @Nullable
    public final String getLiteralStringFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = this.getLiteralStringEntryFromAnnotation(annotation);
        return ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
    }

    @Nullable
    public final KtLiteralStringTemplateEntry getLiteralStringEntryFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        Object object;
        block4: {
            block3: {
                KtExpression ktExpression;
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                List<? extends ValueArgument> list = annotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueArguments(...)");
                object = (ValueArgument)CollectionsKt.firstOrNull(list);
                if (object == null) break block3;
                ValueArgument $this$getLiteralStringEntryFromAnnotation_u24lambda_u244 = object;
                boolean bl = false;
                KtStringTemplateExpression ktStringTemplateExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u244 instanceof KtValueArgument ? ((KtValueArgument)$this$getLiteralStringEntryFromAnnotation_u24lambda_u244).getStringTemplateExpression() : ((ktExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u244.getArgumentExpression()) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null);
                object = ktStringTemplateExpression;
                if (ktStringTemplateExpression != null) break block4;
            }
            return null;
        }
        Object stringTemplateExpression = object;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)stringTemplateExpression).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object object2 = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        return object2 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object2 : null;
    }

    static {
        String string2 = JVM_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        JVM_NAME_SHORT = string2;
    }
}

