/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.codegen.AsmUtil;
import ksp.org.jetbrains.kotlin.codegen.StackValue;
import ksp.org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import ksp.org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import ksp.org.jetbrains.org.objectweb.asm.Label;
import ksp.org.jetbrains.org.objectweb.asm.Type;
import ksp.org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import ksp.org.jetbrains.org.objectweb.asm.commons.Method;
import ksp.org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0018\u0010\t\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/codegen/intrinsics/IntrinsicArrayConstructors;", "", "<init>", "()V", "isArrayOf", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isEmptyArray", "isBuiltInsPackage", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "generateArrayConstructorBody", "Lksp/org/jetbrains/org/objectweb/asm/tree/MethodNode;", "method", "Lksp/org/jetbrains/org/objectweb/asm/commons/Method;", "generateEmptyArrayBody", "generateArrayOfBody", "backend"})
public final class IntrinsicArrayConstructors {
    @NotNull
    public static final IntrinsicArrayConstructors INSTANCE = new IntrinsicArrayConstructors();

    private IntrinsicArrayConstructors() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isArrayOf(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"arrayOf")) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        if (!this.isBuiltInsPackage(declarationDescriptor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmptyArray(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"emptyArray")) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        if (!this.isBuiltInsPackage(declarationDescriptor)) return false;
        return true;
    }

    private final boolean isBuiltInsPackage(DeclarationDescriptor $this$isBuiltInsPackage) {
        return $this$isBuiltInsPackage instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)$this$isBuiltInsPackage).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    @NotNull
    public final MethodNode generateArrayConstructorBody(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        MethodNode node = new MethodNode(393216, 25, method.getName(), method.getDescriptor(), null, null);
        Type arrayType2 = method.getReturnType();
        Type type2 = AsmUtil.correctElementType(arrayType2);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"correctElementType(...)");
        Type elementType = type2;
        StackValue.Local local = StackValue.local(0, Type.INT_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)local, (String)"local(...)");
        StackValue.Local size = local;
        StackValue.Local local2 = StackValue.local(1, AsmTypes.FUNCTION1);
        Intrinsics.checkNotNullExpressionValue((Object)local2, (String)"local(...)");
        StackValue.Local lambda = local2;
        StackValue.Local local3 = StackValue.local(2, Type.INT_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)local3, (String)"local(...)");
        StackValue.Local loopIndex = local3;
        StackValue.Local local4 = StackValue.local(3, arrayType2);
        Intrinsics.checkNotNullExpressionValue((Object)local4, (String)"local(...)");
        StackValue.Local array = local4;
        InstructionAdapter iv = new InstructionAdapter(node);
        size.put(iv);
        if (elementType.getSort() == 10) {
            ReifiedTypeInliner.Companion.putReifiedOperationMarker(ReifiedTypeInliner.OperationKind.NEW_ARRAY, new ReificationArgument("T", true, 0), iv);
        }
        iv.newarray(elementType);
        array.store(StackValue.onStack(arrayType2), iv);
        loopIndex.store(StackValue.constant(0), iv);
        Label begin = new Label();
        iv.visitLabel(begin);
        loopIndex.put(iv);
        size.put(iv);
        Label end = new Label();
        iv.ificmpge(end);
        array.put(iv);
        loopIndex.put(iv);
        lambda.put(iv);
        loopIndex.put(AsmUtil.boxType(Type.INT_TYPE), iv);
        Type[] typeArray = new Type[]{AsmTypes.OBJECT_TYPE};
        iv.invokeinterface(AsmTypes.FUNCTION1.getInternalName(), OperatorNameConventions.INVOKE.asString(), Type.getMethodDescriptor(AsmTypes.OBJECT_TYPE, typeArray));
        StackValue.coerce(AsmTypes.OBJECT_TYPE, elementType, iv);
        iv.astore(elementType);
        iv.iinc(loopIndex.index, 1);
        iv.goTo(begin);
        iv.visitLabel(end);
        array.put(iv);
        iv.areturn(arrayType2);
        iv.visitMaxs(5, 4);
        return node;
    }

    @NotNull
    public final MethodNode generateEmptyArrayBody(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        MethodNode node = new MethodNode(393216, 25, method.getName(), method.getDescriptor(), null, null);
        InstructionAdapter iv = new InstructionAdapter(node);
        iv.iconst(0);
        ReifiedTypeInliner.Companion.putReifiedOperationMarker(ReifiedTypeInliner.OperationKind.NEW_ARRAY, new ReificationArgument("T", true, 0), iv);
        iv.newarray(AsmTypes.OBJECT_TYPE);
        iv.areturn(AsmTypes.OBJECT_TYPE);
        iv.visitMaxs(3, 1);
        return node;
    }

    @NotNull
    public final MethodNode generateArrayOfBody(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        MethodNode node = new MethodNode(393216, 25, method.getName(), method.getDescriptor(), null, null);
        InstructionAdapter iv = new InstructionAdapter(node);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.areturn(AsmTypes.OBJECT_TYPE);
        iv.visitMaxs(1, 1);
        return node;
    }
}

