/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;
import ksp.one.util.streamex.ConstSpliterator;
import ksp.one.util.streamex.Internals;

class PrependSpliterator<T>
implements Internals.TailSpliterator<T> {
    private Spliterator<T> source;
    private T element;
    private int mode;

    public PrependSpliterator(Spliterator<T> source, T element2) {
        this.source = source;
        this.element = element2;
        this.mode = source.estimateSize() < 0x7FFFFFFFFFFFFFFEL ? 1 : 2;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.mode == 0) {
            return this.source.tryAdvance(action);
        }
        action.accept(this.element);
        this.element = null;
        this.mode = 0;
        return true;
    }

    @Override
    public Spliterator<T> tryAdvanceOrTail(Consumer<? super T> action) {
        if (this.mode == 0) {
            Spliterator<T> s = this.source;
            this.source = null;
            return s;
        }
        action.accept(this.element);
        this.element = null;
        this.mode = 0;
        return this;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (this.mode != 0) {
            action.accept(this.element);
        }
        this.element = null;
        this.mode = 0;
        this.source.forEachRemaining(action);
    }

    @Override
    public Spliterator<T> forEachOrTail(Consumer<? super T> action) {
        if (this.mode != 0) {
            action.accept(this.element);
        }
        Spliterator<T> s = this.source;
        this.element = null;
        this.mode = 0;
        this.source = null;
        return s;
    }

    @Override
    public Spliterator<T> trySplit() {
        if (this.mode == 0) {
            return this.source.trySplit();
        }
        this.mode = 0;
        return new ConstSpliterator.OfRef<T>(this.element, 1L, true);
    }

    @Override
    public long estimateSize() {
        long size = this.source.estimateSize();
        return this.mode == 0 || size == Long.MAX_VALUE ? size : size + 1L;
    }

    @Override
    public int characteristics() {
        switch (this.mode) {
            case 1: {
                return this.source.characteristics() & 0x4050;
            }
            case 2: {
                return this.source.characteristics() & 0x10;
            }
        }
        return this.source.characteristics();
    }
}

