/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import javax.swing.Icon;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.ui.IconManager;
import ksp.com.intellij.ui.PlatformIcons;
import ksp.com.intellij.ui.icons.RowIcon;

public final class VisibilityIcons {
    private VisibilityIcons() {
    }

    public static void setVisibilityIcon(PsiModifierList modifierList2, RowIcon baseIcon) {
        if (modifierList2 != null) {
            if (modifierList2.hasModifierProperty("public")) {
                VisibilityIcons.setVisibilityIcon(4, baseIcon);
            } else if (modifierList2.hasModifierProperty("private")) {
                VisibilityIcons.setVisibilityIcon(1, baseIcon);
            } else if (modifierList2.hasModifierProperty("protected")) {
                VisibilityIcons.setVisibilityIcon(3, baseIcon);
            } else if (modifierList2.hasModifierProperty("packageLocal")) {
                VisibilityIcons.setVisibilityIcon(2, baseIcon);
            } else {
                Icon emptyIcon = IconManager.getInstance().createEmptyIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Public));
                baseIcon.setIcon(emptyIcon, 1);
            }
        } else {
            Icon emptyIcon = IconManager.getInstance().createEmptyIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Public));
            baseIcon.setIcon(emptyIcon, 1);
        }
    }

    public static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        IconManager iconManager = IconManager.getInstance();
        switch (accessLevel) {
            case 4: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Public);
                break;
            }
            case 3: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Protected);
                break;
            }
            case 2: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Local);
                break;
            }
            case 1: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Private);
                break;
            }
            default: {
                icon = iconManager.createEmptyIcon(iconManager.getPlatformIcon(PlatformIcons.Public));
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

