/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.renderer;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirBackingField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.renderer.FirPrinter;
import ksp.org.jetbrains.kotlin.fir.renderer.FirRendererComponents;
import ksp.org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import ksp.org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\"*\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0014J\f\u0010'\u001a\u00020\"*\u00020\u0011H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/FirModifierRenderer;", "", "<init>", "()V", "components", "Lksp/org/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "printer", "Lksp/org/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "renderModifiers", "", "memberDeclaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "backingField", "Lksp/org/jetbrains/kotlin/fir/declarations/FirBackingField;", "constructor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirConstructor;", "propertyAccessor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "anonymousFunction", "Lksp/org/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "valueParameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "typeParameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "functionTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "renderModifier", "modifier", "", "asString", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "effectiveVisibility", "Lksp/org/jetbrains/kotlin/descriptors/EffectiveVisibility;", "modalityAsString", "Companion", "tree"})
@SourceDebugExtension(value={"SMAP\nFirModifierRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirModifierRenderer.kt\norg/jetbrains/kotlin/fir/renderer/FirModifierRenderer\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,84:1\n11#2:85\n40#2:86\n*S KotlinDebug\n*F\n+ 1 FirModifierRenderer.kt\norg/jetbrains/kotlin/fir/renderer/FirModifierRenderer\n*L\n68#1:85\n69#1:86\n*E\n"})
public abstract class FirModifierRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public FirRendererComponents components;
    @NotNull
    private static final Set<Visibility> visibilitiesToRenderEffectiveSet;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter((Object)firRendererComponents, (String)"<set-?>");
        this.components = firRendererComponents;
    }

    @NotNull
    protected final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    public abstract void renderModifiers(@NotNull FirMemberDeclaration var1);

    public abstract void renderModifiers(@NotNull FirBackingField var1);

    public abstract void renderModifiers(@NotNull FirConstructor var1);

    public abstract void renderModifiers(@NotNull FirPropertyAccessor var1);

    public abstract void renderModifiers(@NotNull FirAnonymousFunction var1);

    public void renderModifiers(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        if (valueParameter2.isCrossinline()) {
            this.renderModifier("crossinline");
        }
        if (valueParameter2.isNoinline()) {
            this.renderModifier("noinline");
        }
        if (valueParameter2.isVararg()) {
            this.renderModifier("vararg");
        }
    }

    public void renderModifiers(@NotNull FirTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        if (typeParameter.isReified()) {
            this.renderModifier("reified");
        }
    }

    public void renderModifiers(@NotNull FirFunctionTypeRef functionTypeRef) {
        Intrinsics.checkNotNullParameter((Object)functionTypeRef, (String)"functionTypeRef");
        if (functionTypeRef.isSuspend()) {
            this.renderModifier("suspend");
        }
    }

    protected void renderModifier(@NotNull String modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Object[] objectArray = new Object[]{modifier + ' '};
        this.getPrinter().print(objectArray);
    }

    @NotNull
    protected String asString(@NotNull Visibility $this$asString, @Nullable EffectiveVisibility effectiveVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$asString, (Object)Visibilities.Unknown.INSTANCE)) {
            return "public?";
        }
        String itself = $this$asString.toString();
        if (effectiveVisibility == null) {
            return itself;
        }
        Visibility effectiveAsVisibility = effectiveVisibility.toVisibility();
        if (Intrinsics.areEqual((Object)effectiveAsVisibility, (Object)$this$asString)) {
            return itself;
        }
        if (Intrinsics.areEqual((Object)effectiveAsVisibility, (Object)Visibilities.Private.INSTANCE) && Intrinsics.areEqual((Object)$this$asString, (Object)Visibilities.PrivateToThis.INSTANCE)) {
            return itself;
        }
        if (!visibilitiesToRenderEffectiveSet.contains($this$asString)) {
            return itself;
        }
        return itself + '[' + effectiveVisibility.getName() + ']';
    }

    public static /* synthetic */ String asString$default(FirModifierRenderer firModifierRenderer, Visibility visibility, EffectiveVisibility effectiveVisibility, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asString");
        }
        if ((n & 1) != 0) {
            effectiveVisibility = null;
        }
        return firModifierRenderer.asString(visibility, effectiveVisibility);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected String modalityAsString(@NotNull FirMemberDeclaration $this$modalityAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$modalityAsString, (String)"<this>");
        FirMemberDeclaration $this$modality$iv = $this$modalityAsString;
        boolean $i$f$getModality = false;
        Object object = $this$modality$iv.getStatus().getModality();
        if (object != null && (object = object.name()) != null) {
            String string2 = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)object);
            object = string2;
            if (string2 != null) return object;
        }
        FirMemberDeclaration $this$modalityAsString_u24lambda_u240 = $this$modalityAsString;
        boolean bl = false;
        if (!($this$modalityAsString_u24lambda_u240 instanceof FirCallableDeclaration)) return "final?";
        FirMemberDeclaration $this$isOverride$iv = $this$modalityAsString_u24lambda_u240;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) return "final?";
        return "open?";
    }

    static {
        Object[] objectArray = new Visibility[]{Visibilities.Private.INSTANCE, Visibilities.PrivateToThis.INSTANCE, Visibilities.Internal.INSTANCE, Visibilities.Protected.INSTANCE, Visibilities.Public.INSTANCE, Visibilities.Local.INSTANCE};
        visibilitiesToRenderEffectiveSet = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/FirModifierRenderer$Companion;", "", "<init>", "()V", "visibilitiesToRenderEffectiveSet", "", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "tree"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

