/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImplicitNothingReturnTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplicitNothingReturnTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,53:1\n40#2:54\n*S KotlinDebug\n*F\n+ 1 FirImplicitNothingReturnTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker\n*L\n28#1:54\n*E\n"})
public final class FirImplicitNothingReturnTypeChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirImplicitNothingReturnTypeChecker INSTANCE = new FirImplicitNothingReturnTypeChecker();

    private FirImplicitNothingReturnTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirSimpleFunction) && !(declaration2 instanceof FirProperty)) {
            return;
        }
        if (declaration2 instanceof FirProperty && ((FirProperty)declaration2).isLocal()) {
            return;
        }
        FirMemberDeclaration $this$isOverride$iv = declaration2;
        boolean $i$f$isOverride = false;
        if ($this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        if (DeclarationUtilsKt.getHasExplicitReturnType(declaration2.getSymbol())) {
            boolean notDeclaredAsNothing = !ConeBuiltinTypeUtilsKt.isNothing(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef())));
            boolean expandedNothing = ConeBuiltinTypeUtilsKt.isNothing(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession(), null, 2, null));
            if (notDeclaredAsNothing && expandedNothing) {
                KtDiagnosticFactory0 ktDiagnosticFactory0;
                FirCallableDeclaration firCallableDeclaration = declaration2;
                if (firCallableDeclaration instanceof FirSimpleFunction) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getABBREVIATED_NOTHING_RETURN_TYPE();
                } else if (firCallableDeclaration instanceof FirProperty) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getABBREVIATED_NOTHING_PROPERTY_TYPE();
                } else {
                    throw new IllegalStateException("Should not be here".toString());
                }
                KtDiagnosticFactory0 factory2 = ktDiagnosticFactory0;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeParametersOwner)((Object)declaration2)).getSource(), factory2, (DiagnosticContext)context2, null, 8, null);
            }
            return;
        }
        if (ConeBuiltinTypeUtilsKt.isNothing(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()))) {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirCallableDeclaration firCallableDeclaration = declaration2;
            if (firCallableDeclaration instanceof FirSimpleFunction) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_RETURN_TYPE();
            } else if (firCallableDeclaration instanceof FirProperty) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_PROPERTY_TYPE();
            } else {
                throw new IllegalStateException("Should not be here".toString());
            }
            KtDiagnosticFactory0 factory3 = ktDiagnosticFactory0;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeParametersOwner)((Object)declaration2)).getSource(), factory3, (DiagnosticContext)context2, null, 8, null);
        }
    }
}

