/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.lower.VisibilityPolicy;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLoweringKt;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmVisibilityPolicy;", "Lksp/org/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;", "<init>", "()V", "forClass", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "inInlineFunctionScope", "", "forConstructor", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "forCapturedField", "value", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "scopedVisibility", "backend.jvm.lower"})
public final class JvmVisibilityPolicy
implements VisibilityPolicy {
    @NotNull
    public static final JvmVisibilityPolicy INSTANCE = new JvmVisibilityPolicy();

    private JvmVisibilityPolicy() {
    }

    @Override
    @NotNull
    public DescriptorVisibility forClass(@NotNull IrClass declaration2, boolean inInlineFunctionScope) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return JvmLocalDeclarationsLoweringKt.isGeneratedLambdaClass(declaration2) ? this.scopedVisibility(inInlineFunctionScope) : declaration2.getVisibility();
    }

    @Override
    @NotNull
    public DescriptorVisibility forConstructor(@NotNull IrConstructor declaration2, boolean inInlineFunctionScope) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return IrUtilsKt.isAnonymousObject(IrUtilsKt.getParentAsClass(declaration2)) ? this.scopedVisibility(inInlineFunctionScope) : declaration2.getVisibility();
    }

    @Override
    @NotNull
    public DescriptorVisibility forCapturedField(@NotNull IrValueSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DescriptorVisibility descriptorVisibility = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PACKAGE_VISIBILITY");
        return descriptorVisibility;
    }

    private final DescriptorVisibility scopedVisibility(boolean inInlineFunctionScope) {
        DescriptorVisibility descriptorVisibility;
        if (inInlineFunctionScope) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        return descriptorVisibility;
    }
}

