/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.components;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "DO_NOT_SHORTEN", "SHORTEN_IF_ALREADY_IMPORTED", "SHORTEN_AND_IMPORT", "SHORTEN_AND_STAR_IMPORT", "Companion", "analysis-api"})
public final class ShortenStrategy
extends Enum<ShortenStrategy> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Function1<KaClassLikeSymbol, ShortenStrategy> defaultClassShortenStrategy;
    @NotNull
    private static final Function1<KaCallableSymbol, ShortenStrategy> defaultCallableShortenStrategy;
    public static final /* enum */ ShortenStrategy DO_NOT_SHORTEN;
    public static final /* enum */ ShortenStrategy SHORTEN_IF_ALREADY_IMPORTED;
    public static final /* enum */ ShortenStrategy SHORTEN_AND_IMPORT;
    public static final /* enum */ ShortenStrategy SHORTEN_AND_STAR_IMPORT;
    private static final /* synthetic */ ShortenStrategy[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public static ShortenStrategy[] values() {
        return (ShortenStrategy[])$VALUES.clone();
    }

    public static ShortenStrategy valueOf(String value2) {
        return Enum.valueOf(ShortenStrategy.class, value2);
    }

    @NotNull
    public static EnumEntries<ShortenStrategy> getEntries() {
        return $ENTRIES;
    }

    private static final ShortenStrategy defaultClassShortenStrategy$lambda$0(KaClassLikeSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClassId classId = it.getClassId();
        return (classId != null ? classId.isNestedClass() : false) ? SHORTEN_IF_ALREADY_IMPORTED : SHORTEN_AND_IMPORT;
    }

    private static final ShortenStrategy defaultCallableShortenStrategy$lambda$1(KaCallableSymbol symbol) {
        ShortenStrategy shortenStrategy;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaCallableSymbol kaCallableSymbol = symbol;
        if (kaCallableSymbol instanceof KaEnumEntrySymbol) {
            shortenStrategy = DO_NOT_SHORTEN;
        } else if (kaCallableSymbol instanceof KaConstructorSymbol) {
            boolean isNestedClassConstructor;
            ClassId classId = ((KaConstructorSymbol)symbol).getContainingClassId();
            boolean bl = classId != null ? classId.isNestedClass() : (isNestedClassConstructor = false);
            shortenStrategy = isNestedClassConstructor ? SHORTEN_IF_ALREADY_IMPORTED : SHORTEN_AND_IMPORT;
        } else {
            CallableId callableId = symbol.getCallableId();
            boolean isNotTopLevel = (callableId != null ? callableId.getClassId() : null) != null;
            shortenStrategy = isNotTopLevel ? SHORTEN_IF_ALREADY_IMPORTED : SHORTEN_AND_IMPORT;
        }
        return shortenStrategy;
    }

    static {
        DO_NOT_SHORTEN = new ShortenStrategy();
        SHORTEN_IF_ALREADY_IMPORTED = new ShortenStrategy();
        SHORTEN_AND_IMPORT = new ShortenStrategy();
        SHORTEN_AND_STAR_IMPORT = new ShortenStrategy();
        $VALUES = shortenStrategyArray = new ShortenStrategy[]{ShortenStrategy.DO_NOT_SHORTEN, ShortenStrategy.SHORTEN_IF_ALREADY_IMPORTED, ShortenStrategy.SHORTEN_AND_IMPORT, ShortenStrategy.SHORTEN_AND_STAR_IMPORT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        defaultClassShortenStrategy = ShortenStrategy::defaultClassShortenStrategy$lambda$0;
        defaultCallableShortenStrategy = ShortenStrategy::defaultCallableShortenStrategy$lambda$1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/components/ShortenStrategy$Companion;", "", "<init>", "()V", "defaultClassShortenStrategy", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "Lksp/org/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "getDefaultClassShortenStrategy", "()Lkotlin/jvm/functions/Function1;", "defaultCallableShortenStrategy", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "getDefaultCallableShortenStrategy", "analysis-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<KaClassLikeSymbol, ShortenStrategy> getDefaultClassShortenStrategy() {
            return defaultClassShortenStrategy;
        }

        @NotNull
        public final Function1<KaCallableSymbol, ShortenStrategy> getDefaultCallableShortenStrategy() {
            return defaultCallableShortenStrategy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

