/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.fasterxml.aalto.in;

import java.text.MessageFormat;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import ksp.com.fasterxml.aalto.impl.ErrorConsts;
import ksp.com.fasterxml.aalto.in.PName;
import ksp.com.fasterxml.aalto.in.ReaderConfig;
import ksp.com.fasterxml.aalto.in.XmlScanner;
import ksp.com.fasterxml.aalto.util.DataUtil;
import ksp.org.codehaus.stax2.XMLStreamLocation2;
import ksp.org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import ksp.org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import ksp.org.codehaus.stax2.typed.Base64Variant;
import ksp.org.codehaus.stax2.typed.TypedArrayDecoder;
import ksp.org.codehaus.stax2.typed.TypedValueDecoder;
import ksp.org.codehaus.stax2.typed.TypedXMLStreamException;

public final class AttributeCollector {
    private static final int INT_SPACE = 32;
    private static final int DEFAULT_ENTRY_COUNT = 12;
    private static final int DEFAULT_BUFFER_LENGTH = 120;
    final ReaderConfig _config;
    private int _attrCount;
    private PName[] _names = null;
    private char[] _valueBuffer = null;
    protected int[] _attrMap = null;
    protected int _hashAreaSize;
    protected int _spillAreaEnd;
    private int[] _valueOffsets = null;
    private boolean _needToResetValues = true;
    private String _errorMsg = null;
    private String _allAttrValues = null;

    protected AttributeCollector(ReaderConfig cfg) {
        this._config = cfg;
        this._attrCount = 0;
    }

    public char[] startNewValue(PName attrName, int currOffset) {
        int count;
        if (this._needToResetValues) {
            this._needToResetValues = false;
            count = 0;
            this._attrCount = 0;
            this._allAttrValues = null;
            if (this._valueBuffer == null) {
                this._names = new PName[12];
                this._valueBuffer = new char[120];
                this._valueOffsets = new int[12];
            }
        } else {
            count = this._attrCount;
            if (count >= this._valueOffsets.length) {
                int[] oldVal = this._valueOffsets;
                PName[] oldNames = this._names;
                int oldLen = oldVal.length;
                int newLen = oldLen + oldLen;
                this._valueOffsets = new int[newLen];
                this._names = new PName[newLen];
                for (int i = 0; i < oldLen; ++i) {
                    this._valueOffsets[i] = oldVal[i];
                    this._names[i] = oldNames[i];
                }
            }
            if (count > 0) {
                this._valueOffsets[count - 1] = currOffset;
            }
        }
        this._names[count] = attrName;
        ++this._attrCount;
        return this._valueBuffer;
    }

    public char[] continueValue() {
        return this._valueBuffer;
    }

    public final int finishLastValue(int endingOffset) {
        if (this._needToResetValues) {
            return 0;
        }
        this._needToResetValues = true;
        int count = this._attrCount;
        this._valueOffsets[count - 1] = endingOffset;
        if (count < 3) {
            PName[] names;
            this._hashAreaSize = 0;
            if (count == 2 && (names = this._names)[0].boundEquals(names[1])) {
                this.noteDupAttr(0, 1);
                return -1;
            }
            return count;
        }
        return this.finishLastValue2();
    }

    public final int finishLastValue2() {
        int hashCount;
        int count = this._attrCount;
        PName[] names = this._names;
        int[] map = this._attrMap;
        int min = count + (count >> 2);
        for (hashCount = 8; hashCount < min; hashCount += hashCount) {
        }
        this._hashAreaSize = hashCount;
        min = hashCount + (hashCount >> 4);
        if (map == null || map.length < min) {
            map = new int[min];
        } else {
            map[7] = 0;
            map[6] = 0;
            map[5] = 0;
            map[4] = 0;
            map[3] = 0;
            map[2] = 0;
            map[1] = 0;
            map[0] = 0;
            for (int i = 8; i < hashCount; ++i) {
                map[i] = 0;
            }
        }
        int mask = hashCount - 1;
        int spillIndex = hashCount;
        for (int i = 0; i < count; ++i) {
            PName newName = names[i];
            int hash = newName.boundHashCode();
            int index = hash & mask;
            int oldNameIndex = map[index];
            if (oldNameIndex == 0) {
                map[index] = i + 1;
                continue;
            }
            if (names[--oldNameIndex].boundEquals(newName) && this._errorMsg == null) {
                this.noteDupAttr(oldNameIndex, i);
            }
            if (spillIndex + 1 >= map.length) {
                map = DataUtil.growArrayBy(map, 8);
            }
            for (int j = hashCount; j < spillIndex; j += 2) {
                if (map[j] != hash || !names[oldNameIndex = map[j + 1]].boundEquals(newName)) continue;
                if (this._errorMsg != null) break;
                this.noteDupAttr(oldNameIndex, i);
                break;
            }
            map[spillIndex++] = hash;
            map[spillIndex++] = i;
        }
        this._spillAreaEnd = spillIndex;
        this._attrMap = map;
        return this._errorMsg == null ? count : -1;
    }

    public char[] valueBufferFull() {
        this._valueBuffer = DataUtil.growArrayBy(this._valueBuffer, this._valueBuffer.length);
        return this._valueBuffer;
    }

    public final int getCount() {
        return this._attrCount;
    }

    public final PName getName(int index) {
        return this._names[index];
    }

    public final QName getQName(int index) {
        return this._names[index].constructQName();
    }

    public String getValue(int index) {
        int len;
        int count = this._attrCount;
        if (this._allAttrValues == null) {
            len = this._valueOffsets[count - 1];
            String string2 = this._allAttrValues = len == 0 ? "" : new String(this._valueBuffer, 0, len);
        }
        if (index == 0) {
            if (count == 1) {
                return this._allAttrValues;
            }
            len = this._valueOffsets[0];
            return len == 0 ? "" : this._allAttrValues.substring(0, len);
        }
        int start = this._valueOffsets[index - 1];
        int end = this._valueOffsets[index];
        return start == end ? "" : this._allAttrValues.substring(start, end);
    }

    public String getValue(String nsUri, String localName) {
        int ix = this.findIndex(nsUri, localName);
        return ix >= 0 ? this.getValue(ix) : null;
    }

    public int findIndex(String nsUri, String localName) {
        int hashSize = this._hashAreaSize;
        if (hashSize < 1) {
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PName curr = this._names[i];
                if (!curr.boundEquals(nsUri, localName)) continue;
                return i;
            }
            return -1;
        }
        int hash = PName.boundHashCode(nsUri, localName);
        int ix = this._attrMap[hash & hashSize - 1];
        if (ix > 0) {
            if (this._names[--ix].boundEquals(nsUri, localName)) {
                return ix;
            }
            int len = this._spillAreaEnd;
            for (int i = hashSize; i < len; i += 2) {
                if (this._attrMap[i] != hash || !this._names[ix = this._attrMap[i + 1]].boundEquals(nsUri, localName)) continue;
                return ix;
            }
        }
        return -1;
    }

    public String getErrorMsg() {
        return this._errorMsg;
    }

    public final void decodeValue(int index, TypedValueDecoder dec) throws IllegalArgumentException {
        int end;
        int start;
        if (index < 0 || index >= this._attrCount) {
            throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + this._attrCount + " attributes");
        }
        if (index == 0) {
            start = 0;
            end = this._valueOffsets[0];
        } else {
            start = this._valueOffsets[index - 1];
            end = this._valueOffsets[index];
        }
        char[] buf = this._valueBuffer;
        while (true) {
            if (start >= end) {
                dec.handleEmptyValue();
                return;
            }
            if (!AttributeCollector.isSpace(buf[start])) break;
            ++start;
        }
        while (--end > start && AttributeCollector.isSpace(buf[end])) {
        }
        dec.decode(buf, start, end + 1);
    }

    public final int decodeValues(int index, TypedArrayDecoder dec, XmlScanner scanner) throws XMLStreamException {
        int end;
        int start;
        if (index < 0 || index >= this._attrCount) {
            throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + this._attrCount + " attributes");
        }
        if (index == 0) {
            start = 0;
            end = this._valueOffsets[0];
        } else {
            start = this._valueOffsets[index - 1];
            end = this._valueOffsets[index];
        }
        return this.decodeValues(dec, this._valueBuffer, start, end, scanner);
    }

    private final int decodeValues(TypedArrayDecoder dec, char[] buf, int ptr, int end, XmlScanner scanner) throws XMLStreamException {
        int count;
        block5: {
            int start = ptr;
            count = 0;
            try {
                while (ptr < end) {
                    while (buf[ptr] <= ' ') {
                        if (++ptr < end) continue;
                        break block5;
                    }
                    start = ptr++;
                    while (ptr < end && buf[ptr] > ' ') {
                        ++ptr;
                    }
                    int tokenEnd = ptr++;
                    ++count;
                    if (!dec.decodeValue(buf, start, tokenEnd) || this.checkExpand(dec)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException iae) {
                XMLStreamLocation2 loc = scanner.getCurrentLocation();
                String lexical = new String(buf, start, ptr - start);
                throw new TypedXMLStreamException(lexical, iae.getMessage(), loc, iae);
            }
        }
        return count;
    }

    public byte[] decodeBinaryValue(int index, Base64Variant v, CharArrayBase64Decoder dec, XmlScanner scanner) throws XMLStreamException {
        int end;
        int start;
        if (index < 0 || index >= this._attrCount) {
            throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + this._attrCount + " attributes");
        }
        if (index == 0) {
            start = 0;
            end = this._valueOffsets[0];
        } else {
            start = this._valueOffsets[index - 1];
            end = this._valueOffsets[index];
        }
        int len = end - start;
        dec.init(v, true, this._valueBuffer, start, end, null);
        try {
            return dec.decodeCompletely();
        }
        catch (IllegalArgumentException iae) {
            String lexical = new String(this._valueBuffer, start, len);
            throw new TypedXMLStreamException(lexical, iae.getMessage(), scanner.getCurrentLocation(), iae);
        }
    }

    private static final boolean isSpace(char c) {
        return c <= ' ';
    }

    private final boolean checkExpand(TypedArrayDecoder tad) {
        if (tad instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)tad).expand();
            return true;
        }
        return false;
    }

    private void noteDupAttr(int ix1, int ix2) {
        this._errorMsg = MessageFormat.format(ErrorConsts.ERR_WF_DUP_ATTRS, this._names[ix1].toString(), ix1, this._names[ix2].toString(), ix2);
    }
}

