/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import ksp.org.jetbrains.kotlin.psi.KtCallExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtValueArgument;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import ksp.org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constantExpressionEvaluator", "Lksp/org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "<init>", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "wasm.frontend"})
public final class WasmJsCallChecker
implements CallChecker {
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public WasmJsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isAnnotationContext() || !JsCallChecker.Companion.isJsCall(resolvedCall2)) {
            return;
        }
        DeclarationDescriptor containingDeclaration = context2.getScope().getOwnerDescriptor();
        if (!(containingDeclaration instanceof FunctionDescriptor) && !(containingDeclaration instanceof PropertyDescriptor) || !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration)) {
            context2.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
        } else {
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)containingDeclaration;
            if (callableMemberDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)containingDeclaration;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (!JsCodeUtilsKt.hasValidJsCodeBody(functionDescriptor, bindingContext)) {
                    context2.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
                } else {
                    if (((FunctionDescriptor)containingDeclaration).isSuspend()) {
                        context2.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "suspend function"));
                    }
                    if (((FunctionDescriptor)containingDeclaration).isInline()) {
                        context2.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "inline function"));
                    }
                    if (((FunctionDescriptor)containingDeclaration).getExtensionReceiverParameter() != null) {
                        context2.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "function with extension receiver"));
                    }
                    for (ValueParameterDescriptor parameter2 : ((FunctionDescriptor)containingDeclaration).getValueParameters()) {
                        String string2 = parameter2.getName().getIdentifierOrNullIfSpecial();
                        if (string2 != null ? IdentifierPolicyKt.isValidES5Identifier(string2) : false) continue;
                        BindingTrace bindingTrace = context2.getTrace();
                        Intrinsics.checkNotNull((Object)parameter2);
                        PsiElement psiElement = SourceLocationUtilsKt.findPsi(parameter2);
                        if (psiElement == null) {
                            psiElement = reportOn;
                        }
                        bindingTrace.report(ErrorsWasm.JSCODE_INVALID_PARAMETER_NAME.on(psiElement));
                    }
                }
            } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)containingDeclaration;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (!JsCodeUtilsKt.hasValidJsCodeBody(propertyDescriptor, bindingContext)) {
                    context2.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
                }
            }
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement expression2 = ktElement;
        if (!(expression2 instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression2).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list = arguments2;
        if (list == null || (list = (KtValueArgument)CollectionsKt.firstOrNull(list)) == null || (list = ((KtValueArgument)((Object)list)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument = list;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.getTrace(), "WasmJsCallChecker");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(...)");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)argument), trace, TypeUtils.NO_EXPECTED_TYPE);
        String code = JsCallChecker.Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context2.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument))));
            return;
        }
        trace.commit();
    }
}

