/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterList;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/TrailingCommaDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class TrailingCommaDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final TrailingCommaDeclarationChecker INSTANCE = new TrailingCommaDeclarationChecker();

    private TrailingCommaDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtDeclaration ktDeclaration = declaration2;
        if (ktDeclaration instanceof KtClass) {
            KtTypeParameterList ktTypeParameterList = ((KtClass)declaration2).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context2.getTrace(), context2.getLanguageVersionSettings());
        } else if (ktDeclaration instanceof KtCallableDeclaration) {
            KtParameterList ktParameterList = ((KtCallableDeclaration)declaration2).getValueParameterList();
            TrailingCommaChecker.INSTANCE.check(ktParameterList != null ? ktParameterList.getTrailingComma() : null, context2.getTrace(), context2.getLanguageVersionSettings());
            KtTypeParameterList ktTypeParameterList = ((KtCallableDeclaration)declaration2).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context2.getTrace(), context2.getLanguageVersionSettings());
            if (declaration2 instanceof KtProperty && ((KtProperty)declaration2).getSetter() != null) {
                KtElementImplStub ktElementImplStub = ((KtProperty)declaration2).getSetter();
                TrailingCommaChecker.INSTANCE.check(ktElementImplStub != null && (ktElementImplStub = ((KtPropertyAccessor)ktElementImplStub).getParameterList()) != null ? ((KtParameterList)ktElementImplStub).getTrailingComma() : null, context2.getTrace(), context2.getLanguageVersionSettings());
            }
        } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
            TrailingCommaChecker.INSTANCE.check(((KtDestructuringDeclaration)declaration2).getTrailingComma(), context2.getTrace(), context2.getLanguageVersionSettings());
        } else if (ktDeclaration instanceof KtTypeAlias) {
            KtTypeParameterList ktTypeParameterList = ((KtTypeAlias)declaration2).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context2.getTrace(), context2.getLanguageVersionSettings());
        }
    }
}

